/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.handler.lighting.LightHandler;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2")
public class TileEntityElectricFloodlight
extends TileEntityFL
implements IEnergyHandler,
IEnergySink {
    private boolean active = false;
    private boolean wasActive = false;
    private boolean wasAddedToEnergyNet = false;
    private int timeout;
    private int storageEU;
    protected EnergyStorage storage = new EnergyStorage(50000);
    private LightHandler lightHandler = LightHandler.getInstance();
    private ConfigHandler configHandler = ConfigHandler.getInstance();

    public TileEntityElectricFloodlight() {
        Random rand = new Random();
        this.timeout = rand.nextInt(141) + 360;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.storage.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("wasActive")) {
            this.wasActive = nbtTagCompound.func_74767_n("wasActive");
        }
        if (nbtTagCompound.func_74764_b("timeout")) {
            this.timeout = nbtTagCompound.func_74762_e("timeout");
        } else {
            Random rand = new Random();
            this.timeout = rand.nextInt(141) + 360;
        }
        if (nbtTagCompound.func_74764_b("teMode")) {
            this.setActive(nbtTagCompound.func_74762_e("teMode") != 0);
        }
        if (nbtTagCompound.func_74764_b("storageEU")) {
            this.storageEU = nbtTagCompound.func_74762_e("storageEU");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.storage.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74757_a("wasActive", this.wasActive);
        nbtTagCompound.func_74768_a("timeout", this.timeout);
        nbtTagCompound.func_74768_a("storageEU", this.storageEU);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection forgeDirection, double v, double v1) {
        if (this.storage.getMaxEnergyStored() - this.storage.getEnergyStored() >= MathHelper.func_76140_b((double)(v * 4.0))) {
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(v * 4.0));
        } else {
            this.storageEU += MathHelper.func_76140_b((double)(v * 4.0)) - (this.storage.getMaxEnergyStored() - this.storage.getEnergyStored());
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(v * 4.0));
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        if (this.storageEU < 4000) {
            return 8192.0;
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="IC2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileUnloadEvent event = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        World world = this.func_145831_w();
        if (ModCompatibility.IC2Loaded && !this.wasAddedToEnergyNet && !world.field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
        if (!world.field_72995_K) {
            ForgeDirection direction = this.getOrientation();
            int realEnergyUsage = ConfigHandler.energyUsage / (this.mode == 0 ? 1 : 2);
            if (this.active ^ this.inverted && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= realEnergyUsage * 4)) {
                if (!this.wasActive || world.func_82737_E() % (long)this.timeout == 0L) {
                    if (world.func_82737_E() % (long)this.timeout == 0L) {
                        this.lightHandler.removeSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                        this.lightHandler.addSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                        world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOrientation().ordinal() + 6, 2);
                    } else {
                        this.lightHandler.addSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                        world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) + 6, 2);
                    }
                }
                if (this.storageEU >= realEnergyUsage * 4) {
                    this.storageEU -= realEnergyUsage * 4;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else {
                if (this.wasActive) {
                    this.lightHandler.removeSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                    world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) - 6, 2);
                }
                this.wasActive = false;
            }
        }
    }

    public void setActive(boolean b) {
        this.active = b;
        this.setState((byte)(this.active ? 1 : 0));
    }

    public void toggleInverted() {
        this.inverted = !this.inverted;
    }

    @Override
    public boolean getInverted() {
        return this.inverted;
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            ForgeDirection direction = this.getOrientation();
            int realEnergyUsage = ConfigHandler.energyUsage / (this.mode == 0 ? 1 : 4);
            this.lightHandler.removeSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
            int n = this.mode = this.mode == 2 ? 0 : this.mode + 1;
            if (this.active ^ this.inverted && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= realEnergyUsage * 4)) {
                this.lightHandler.addSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:straight" : (this.mode == 1 ? "gui.floodlights:narrowCone" : "gui.floodlights:wideCone");
            player.func_145747_a((IChatComponent)new ChatComponentText(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

