/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.handler.lighting.LightHandler;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.util.GeneralUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCarbonFloodlight
extends TileEntityFL
implements ISidedInventory {
    private boolean active = false;
    private boolean wasActive = false;
    private int timeout;
    public int timeRemaining;
    private LightHandler lightHandler = LightHandler.getInstance();
    private ConfigHandler configHandler = ConfigHandler.getInstance();
    private ItemStack[] inventory;

    public TileEntityCarbonFloodlight() {
        Random rand = new Random();
        this.timeout = rand.nextInt(141) + 360;
        this.inventory = new ItemStack[1];
        this.timeRemaining = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        NBTTagList list;
        NBTTagCompound item;
        byte slot;
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("wasActive")) {
            this.wasActive = nbtTagCompound.func_74767_n("wasActive");
        }
        if (nbtTagCompound.func_74764_b("timeout")) {
            this.timeout = nbtTagCompound.func_74762_e("timeout");
        } else {
            Random rand = new Random();
            this.timeout = rand.nextInt(141) + 360;
        }
        if (nbtTagCompound.func_74764_b("teMode")) {
            this.setActive(nbtTagCompound.func_74762_e("teMode") != 0);
        }
        if (nbtTagCompound.func_74764_b("timeRemaining")) {
            this.timeRemaining = nbtTagCompound.func_74762_e("timeRemaining");
        }
        if ((slot = (item = (list = nbtTagCompound.func_150295_c("Items", 10)).func_150305_b(0)).func_74771_c("Items")) >= 0 && slot < this.func_70302_i_()) {
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("wasActive", this.wasActive);
        nbtTagCompound.func_74768_a("timeout", this.timeout);
        nbtTagCompound.func_74768_a("timeRemaining", this.timeRemaining);
        NBTTagList list = new NBTTagList();
        ItemStack itemstack = this.func_70301_a(0);
        if (itemstack != null) {
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Items", (byte)0);
            itemstack.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    public int[] func_94128_d(int par1) {
        int[] slots = new int[]{0};
        return slots;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_145825_b() {
        return "carbonFloodlight";
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0 && GeneralUtil.getBurnTime(itemstack) > 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(slot, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemstack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return itemstack;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return GeneralUtil.getBurnTime(itemstack) > 0;
    }

    public void func_145845_h() {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            ForgeDirection direction = this.getOrientation();
            if (this.timeRemaining == 0 && this.inventory[0] != null) {
                this.timeRemaining = ConfigHandler.carbonTime * GeneralUtil.getBurnTime(this.inventory[0]) / 1600 * (this.mode == 0 ? 20 : 10);
                this.func_70298_a(0, 1);
            }
            if (this.active ^ this.inverted && this.timeRemaining > 0) {
                if (!this.wasActive || world.func_82737_E() % (long)this.timeout == 0L) {
                    if (world.func_82737_E() % (long)this.timeout == 0L) {
                        this.lightHandler.removeSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                        this.lightHandler.addSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                        world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOrientation().ordinal() + 6, 2);
                    } else {
                        this.lightHandler.addSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                        world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOrientation().ordinal() + 6, 2);
                    }
                }
                --this.timeRemaining;
                this.wasActive = true;
            } else {
                if (this.wasActive) {
                    this.lightHandler.removeSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
                    world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) - 6, 2);
                }
                this.wasActive = false;
            }
        }
    }

    public void setActive(boolean b) {
        this.active = b;
        this.setState((byte)(this.active ? 1 : 0));
    }

    public void toggleInverted() {
        this.inverted = !this.inverted;
    }

    @Override
    public boolean getInverted() {
        return this.inverted;
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            ForgeDirection direction = this.getOrientation();
            this.lightHandler.removeSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
            int n = this.mode = this.mode == 2 ? 0 : this.mode + 1;
            if (this.mode == 1) {
                this.timeRemaining /= 4;
            } else if (this.mode == 0) {
                this.timeRemaining *= 4;
            }
            if (this.active ^ this.inverted && this.timeRemaining > 0) {
                this.lightHandler.addSource(world, this.field_145851_c, this.field_145848_d, this.field_145849_e, direction, this.mode);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:straight" : (this.mode == 1 ? "gui.floodlights:narrowCone" : "gui.floodlights:wideCone");
            player.func_145747_a((IChatComponent)new ChatComponentText(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

