/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.handler.lighting;

import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.handler.lighting.LightBlockHandle;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.util.MathUtil;
import java.util.ArrayList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldHandler {
    private ConfigHandler configHandler = ConfigHandler.getInstance();
    private ArrayList<LightBlockHandle> lightBlocks = new ArrayList();
    private World world;
    private int lastPositionInList = 0;

    public WorldHandler(World worldinput) {
        this.world = worldinput;
        this.lastPositionInList = 0;
    }

    public int getDimensionID() {
        return this.world.field_73011_w.field_76574_g;
    }

    public LightBlockHandle getFloodlightHandler(int x, int y, int z) {
        boolean added = false;
        if (this.lightBlocks.size() == 0) {
            added = true;
            this.lightBlocks.add(new LightBlockHandle(x, y, z));
        }
        for (LightBlockHandle f : this.lightBlocks) {
            int[] coords = new int[]{x, y, z};
            if (f.getCoords()[0] != coords[0] || f.getCoords()[1] != coords[1] || f.getCoords()[2] != coords[2]) continue;
            return f;
        }
        if (!added) {
            this.lightBlocks.add(new LightBlockHandle(x, y, z));
        }
        return this.getFloodlightHandler(x, y, z);
    }

    private void straightSource(int sourceX, int sourceY, int sourceZ, ForgeDirection direction, boolean remove) {
        int i = 1;
        while (true) {
            if (i > ConfigHandler.rangeStraightFloodlight) break;
            int x = sourceX + direction.offsetX * i;
            int y = sourceY + direction.offsetY * i;
            int z = sourceZ + direction.offsetZ * i;
            LightBlockHandle handler = this.getFloodlightHandler(x, y, z);
            if (remove) {
                this.lightBlocks.get(this.lightBlocks.indexOf(handler)).removeSource(sourceX, sourceY, sourceZ);
            } else if (this.world.func_147439_a(x, y, z).isAir((IBlockAccess)this.world, x, y, z)) {
                this.lightBlocks.get(this.lightBlocks.indexOf(handler)).addSource(sourceX, sourceY, sourceZ);
            } else if (this.world.func_147439_a(x, y, z).func_149662_c()) break;
            ++i;
        }
    }

    private void narrowConeSource(int sourceX, int sourceY, int sourceZ, ForgeDirection direction, boolean remove) {
        boolean[] failedBeams = new boolean[9];
        block20: for (int j = 0; j <= 16; ++j) {
            LightBlockHandle handler;
            int z;
            int y;
            int x;
            int[] rotatedCoords;
            int c;
            int b;
            int a;
            int i;
            if (j <= 8) {
                i = 1;
                while (true) {
                    if (i > ConfigHandler.rangeConeFloodlight / 2) continue block20;
                    if (i == 1) {
                        LightBlockHandle handler2 = this.getFloodlightHandler(sourceX + direction.offsetX, sourceY + direction.offsetY, sourceZ + direction.offsetZ);
                        if (remove) {
                            this.lightBlocks.get(this.lightBlocks.indexOf(handler2)).removeSource(sourceX, sourceY, sourceZ);
                        } else if (this.world.func_147439_a(sourceX + direction.offsetX, sourceY + direction.offsetY, sourceZ + direction.offsetZ).isAir((IBlockAccess)this.world, sourceX + direction.offsetX, sourceY + direction.offsetY, sourceZ + direction.offsetZ)) {
                            this.lightBlocks.get(this.lightBlocks.indexOf(handler2)).addSource(sourceX, sourceY, sourceZ);
                        } else if (this.world.func_147439_a(sourceX + direction.offsetX, sourceY + direction.offsetY, sourceZ + direction.offsetZ).func_149662_c()) {
                            return;
                        }
                    }
                    a = 2 * i;
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 0: {
                            b += i;
                            break;
                        }
                        case 1: {
                            b -= i;
                            break;
                        }
                        case 2: {
                            c += i;
                            break;
                        }
                        case 3: {
                            c -= i;
                            break;
                        }
                        case 4: {
                            b += i;
                            c += i;
                            break;
                        }
                        case 5: {
                            b += i;
                            c -= i;
                            break;
                        }
                        case 6: {
                            b -= i;
                            c += i;
                            break;
                        }
                        case 7: {
                            b -= i;
                            c -= i;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(a, b, c, direction);
                    x = sourceX + rotatedCoords[0];
                    y = sourceY + rotatedCoords[1];
                    z = sourceZ + rotatedCoords[2];
                    handler = this.getFloodlightHandler(x, y, z);
                    if (remove) {
                        this.lightBlocks.get(this.lightBlocks.indexOf(handler)).removeSource(sourceX, sourceY, sourceZ);
                    } else if (this.world.func_147439_a(x, y, z).isAir((IBlockAccess)this.world, x, y, z)) {
                        this.lightBlocks.get(this.lightBlocks.indexOf(handler)).addSource(sourceX, sourceY, sourceZ);
                    } else if (this.world.func_147439_a(x, y, z).func_149662_c()) {
                        if (i >= ConfigHandler.rangeConeFloodlight / 4) continue block20;
                        failedBeams[j] = true;
                        continue block20;
                    }
                    ++i;
                }
            }
            if (failedBeams[j - 9] && !remove) continue;
            i = ConfigHandler.rangeConeFloodlight / 4;
            while (true) {
                if (i > ConfigHandler.rangeConeFloodlight / 2) continue block20;
                a = 2 * i;
                b = 0;
                c = 0;
                switch (j) {
                    case 9: {
                        b += i / 2;
                        break;
                    }
                    case 10: {
                        b -= i / 2;
                        break;
                    }
                    case 11: {
                        c += i / 2;
                        break;
                    }
                    case 12: {
                        c -= i / 2;
                        break;
                    }
                    case 13: {
                        b += i / 2;
                        c += i / 2;
                        break;
                    }
                    case 14: {
                        b += i / 2;
                        c -= i / 2;
                        break;
                    }
                    case 15: {
                        b -= i / 2;
                        c += i / 2;
                        break;
                    }
                    case 16: {
                        b -= i / 2;
                        c -= i / 2;
                    }
                }
                rotatedCoords = MathUtil.rotate(a, b, c, direction);
                x = sourceX + rotatedCoords[0];
                y = sourceY + rotatedCoords[1];
                z = sourceZ + rotatedCoords[2];
                handler = this.getFloodlightHandler(x, y, z);
                if (remove) {
                    this.lightBlocks.get(this.lightBlocks.indexOf(handler)).removeSource(sourceX, sourceY, sourceZ);
                } else if (this.world.func_147439_a(x, y, z).isAir((IBlockAccess)this.world, x, y, z)) {
                    this.lightBlocks.get(this.lightBlocks.indexOf(handler)).addSource(sourceX, sourceY, sourceZ);
                } else if (this.world.func_147439_a(x, y, z).func_149662_c()) continue block20;
                ++i;
            }
        }
    }

    private void wideConeSource(int sourceX, int sourceY, int sourceZ, ForgeDirection direction, boolean remove) {
        boolean[] failedBeams = new boolean[9];
        block20: for (int j = 0; j <= 16; ++j) {
            LightBlockHandle handler;
            int z;
            int y;
            int x;
            int[] rotatedCoords;
            int c;
            int b;
            int a;
            int i;
            if (j <= 8) {
                i = 1;
                while (true) {
                    if (i > ConfigHandler.rangeConeFloodlight / 2) continue block20;
                    a = i;
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 0: {
                            b += i;
                            break;
                        }
                        case 1: {
                            b -= i;
                            break;
                        }
                        case 2: {
                            c += i;
                            break;
                        }
                        case 3: {
                            c -= i;
                            break;
                        }
                        case 4: {
                            b += i;
                            c += i;
                            break;
                        }
                        case 5: {
                            b += i;
                            c -= i;
                            break;
                        }
                        case 6: {
                            b -= i;
                            c += i;
                            break;
                        }
                        case 7: {
                            b -= i;
                            c -= i;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(a, b, c, direction);
                    x = sourceX + rotatedCoords[0];
                    y = sourceY + rotatedCoords[1];
                    z = sourceZ + rotatedCoords[2];
                    handler = this.getFloodlightHandler(x, y, z);
                    if (remove) {
                        this.lightBlocks.get(this.lightBlocks.indexOf(handler)).removeSource(sourceX, sourceY, sourceZ);
                    } else if (this.world.func_147439_a(x, y, z).isAir((IBlockAccess)this.world, x, y, z)) {
                        this.lightBlocks.get(this.lightBlocks.indexOf(handler)).addSource(sourceX, sourceY, sourceZ);
                    } else if (this.world.func_147439_a(x, y, z).func_149662_c()) {
                        if (i >= ConfigHandler.rangeConeFloodlight / 4) continue block20;
                        failedBeams[j] = true;
                        continue block20;
                    }
                    ++i;
                }
            }
            if (failedBeams[j - 9] && !remove) continue;
            i = ConfigHandler.rangeConeFloodlight / 4;
            while (true) {
                if (i > ConfigHandler.rangeConeFloodlight / 2) continue block20;
                a = i;
                b = 0;
                c = 0;
                switch (j) {
                    case 9: {
                        b += i / 2;
                        break;
                    }
                    case 10: {
                        b -= i / 2;
                        break;
                    }
                    case 11: {
                        c += i / 2;
                        break;
                    }
                    case 12: {
                        c -= i / 2;
                        break;
                    }
                    case 13: {
                        b += i / 2;
                        c += i / 2;
                        break;
                    }
                    case 14: {
                        b += i / 2;
                        c -= i / 2;
                        break;
                    }
                    case 15: {
                        b -= i / 2;
                        c += i / 2;
                        break;
                    }
                    case 16: {
                        b -= i / 2;
                        c -= i / 2;
                    }
                }
                rotatedCoords = MathUtil.rotate(a, b, c, direction);
                x = sourceX + rotatedCoords[0];
                y = sourceY + rotatedCoords[1];
                z = sourceZ + rotatedCoords[2];
                handler = this.getFloodlightHandler(x, y, z);
                if (remove) {
                    this.lightBlocks.get(this.lightBlocks.indexOf(handler)).removeSource(sourceX, sourceY, sourceZ);
                } else if (this.world.func_147439_a(x, y, z).isAir((IBlockAccess)this.world, x, y, z)) {
                    this.lightBlocks.get(this.lightBlocks.indexOf(handler)).addSource(sourceX, sourceY, sourceZ);
                } else if (this.world.func_147439_a(x, y, z).func_149662_c()) continue block20;
                ++i;
            }
        }
    }

    public void addSource(int sourceX, int sourceY, int sourceZ, ForgeDirection direction, int sourcetype) {
        if (sourcetype == 0) {
            this.straightSource(sourceX, sourceY, sourceZ, direction, false);
        } else if (sourcetype == 1) {
            this.narrowConeSource(sourceX, sourceY, sourceZ, direction, false);
        } else if (sourcetype == 2) {
            this.wideConeSource(sourceX, sourceY, sourceZ, direction, false);
        }
    }

    public void removeSource(int sourceX, int sourceY, int sourceZ, ForgeDirection direction, int sourcetype) {
        if (sourcetype == 0) {
            this.straightSource(sourceX, sourceY, sourceZ, direction, true);
        } else if (sourcetype == 1) {
            this.narrowConeSource(sourceX, sourceY, sourceZ, direction, true);
        } else if (sourcetype == 2) {
            this.wideConeSource(sourceX, sourceY, sourceZ, direction, true);
        }
    }

    public void updateRun() {
        WorldServer activeworld = DimensionManager.getWorld((int)this.world.field_73011_w.field_76574_g);
        if (activeworld != null) {
            int j = this.lastPositionInList;
            int i = this.lastPositionInList;
            while (true) {
                int z;
                int y;
                if (i >= j + ConfigHandler.refreshRate) break;
                if (i >= this.lightBlocks.size()) {
                    this.lastPositionInList = 0;
                    break;
                }
                this.lastPositionInList = i;
                LightBlockHandle f = this.lightBlocks.get(i);
                int x = f.getCoords()[0];
                if (activeworld.func_147439_a(x, y = f.getCoords()[1], z = f.getCoords()[2]) != null) {
                    if (activeworld.func_147439_a(x, y, z).func_149739_a().contains("blockLight") && f.sourceNumber() == 0) {
                        activeworld.func_147468_f(x, y, z);
                        this.lightBlocks.remove(i);
                        --i;
                        --j;
                    }
                    if (f.sourceNumber() > 0 && activeworld.func_147439_a(x, y, z).isAir((IBlockAccess)activeworld, x, y, z)) {
                        activeworld.func_147449_b(x, y, z, ModBlocks.blockFLLight);
                    }
                }
                ++i;
            }
        }
    }

    public void removeAllLights() {
        WorldServer activeworld = DimensionManager.getWorld((int)this.world.field_73011_w.field_76574_g);
        if (activeworld != null) {
            for (int i = 0; i < this.lightBlocks.size(); ++i) {
                int z;
                int y;
                LightBlockHandle f = this.lightBlocks.get(i);
                int x = f.getCoords()[0];
                if (activeworld.func_147439_a(x, y = f.getCoords()[1], z = f.getCoords()[2]) == null || !activeworld.func_147439_a(x, y, z).func_149739_a().contains("blockLight")) continue;
                activeworld.func_147468_f(x, y, z);
                this.lightBlocks.remove(i);
                --i;
            }
        }
    }
}

