/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.handler.lighting;

import de.keridos.floodlights.handler.lighting.WorldHandler;
import de.keridos.floodlights.util.DiskIO;
import java.util.ArrayList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LightHandler {
    private static LightHandler instance = null;
    private ArrayList<WorldHandler> worlds = new ArrayList();

    private LightHandler() {
    }

    public static LightHandler getInstance() {
        if (instance == null && (instance = DiskIO.loadFromDisk()) == null) {
            instance = new LightHandler();
        }
        return instance;
    }

    public WorldHandler getWorldHandler(World world) {
        boolean added = false;
        if (this.worlds == null) {
            added = true;
            this.worlds.add(new WorldHandler(world));
        }
        for (WorldHandler w : this.worlds) {
            if (w.getDimensionID() != world.field_73011_w.field_76574_g) continue;
            return w;
        }
        if (!added) {
            this.worlds.add(new WorldHandler(world));
        }
        return this.getWorldHandler(world);
    }

    public void addSource(World world, int x, int y, int z, ForgeDirection direction, int type) {
        boolean foundWorld = false;
        if (this.worlds == null) {
            this.worlds.add(this.getWorldHandler(world));
        }
        for (WorldHandler worldIterator : this.worlds) {
            if (worldIterator == null || worldIterator.getDimensionID() != world.field_73011_w.field_76574_g) continue;
            worldIterator.addSource(x, y, z, direction, type);
            foundWorld = true;
            break;
        }
        if (!foundWorld) {
            this.worlds.add(new WorldHandler(world));
            this.getWorldHandler(world).addSource(x, y, z, direction, type);
        }
    }

    public void removeSource(World world, int x, int y, int z, ForgeDirection direction, int type) {
        if (this.worlds == null) {
            this.worlds.add(this.getWorldHandler(world));
        }
        for (WorldHandler worldIterator : this.worlds) {
            if (worldIterator == null || worldIterator.getDimensionID() != world.field_73011_w.field_76574_g) continue;
            worldIterator.removeSource(x, y, z, direction, type);
            break;
        }
    }

    public void updateLights() {
        if (this.worlds != null) {
            for (WorldHandler world : this.worlds) {
                world.updateRun();
            }
        }
    }

    public void removeAllLights() {
        if (this.worlds != null) {
            for (WorldHandler world : this.worlds) {
                world.removeAllLights();
            }
        }
    }
}

