/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.rota.ee3help.EE3Help;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandAddOreRange;
import com.rota.ee3help.commands.CommandModifyBase;
import cpw.mods.fml.common.registry.GameData;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.RegistryNamespaced;

public class CommandAddItemRange
extends CommandModifyBase {
    EnergyValueRegistry registryValues = EnergyValueRegistry.getInstance();
    RegistryNamespaced registryNames = GameData.getItemRegistry();

    private void addItemRange(String name, int start, int end, float value) {
        if (!this.registryNames.func_148741_d(name)) {
            return;
        }
        ItemStack iStack = new ItemStack((Item)this.registryNames.func_82594_a(name));
        Map<WrappedStack, EnergyValue> valuesPre = Helper.loadPre();
        for (int i = start; i <= end; ++i) {
            iStack.func_77964_b(i);
            WrappedStack w = WrappedStack.wrap((Object)iStack);
            EnergyValue e = new EnergyValue(value);
            if (w == null || e == null || Float.compare(e.getValue(), 0.0f) <= 0) continue;
            if (valuesPre.containsKey(w)) {
                valuesPre.replace(w, e);
                continue;
            }
            valuesPre.put(w, e);
        }
        EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        Helper.savePre(valuesPre);
        if (EE3Help.config.auto_oredict) {
            CommandAddOreRange.addOreRangeForRange(name, start, end, value);
        }
    }

    @Override
    public String func_71517_b() {
        return "add-item-range";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "add-item-range <itemID/name> <dmgstart> <dmgend> <emcvalue>";
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        this.resetFlag();
        try {
            switch (args.length) {
                case 0: {
                    Helper.toChatErr(cs, this.func_71518_a(cs));
                    break;
                }
                case 4: {
                    String name = Helper.getItemName(args[0]);
                    int start = Integer.parseInt(args[1]);
                    int end = Integer.parseInt(args[2]);
                    float value = Float.parseFloat(args[3]);
                    if (name != null) {
                        this.addItemRange(name, start, end, value);
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ITEM RANGE: " + name);
                        break;
                    }
                    Helper.toChatErr(cs, "(X) Invalid item.");
                    break;
                }
                default: {
                    Helper.toChatErr(cs, "Invalid number of arguments for operation.");
                    Helper.toChatErr(cs, this.func_71518_a(cs));
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
    }
}

