/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import latmod.core.util.LatCore;
import latmod.core.util.MathHelperLM;

public class FastList<E>
implements Iterable<E>,
List<E> {
    public Object[] objects;
    private int initSize;
    private int incr;
    private int size = 0;

    public FastList(int init, int inc) {
        this.initSize = init;
        this.incr = MathHelperLM.clampInt(inc, 1, 100);
        this.objects = new Object[this.initSize];
    }

    public FastList(int init) {
        this(init, 5);
    }

    public FastList() {
        this(10);
    }

    public FastList(Object[] o) {
        this();
        this.addAll(o);
    }

    private void expand() {
        Object[] o = new Object[this.objects.length + this.incr];
        for (int i = 0; i < this.objects.length; ++i) {
            o[i] = this.objects[i];
        }
        this.objects = o;
    }

    @Override
    public boolean add(E e) {
        if (this.size == this.objects.length) {
            this.expand();
        }
        this.objects[this.size++] = e;
        return true;
    }

    @Override
    public E set(int i, E e) {
        this.objects[i] = e;
        return e;
    }

    @Override
    public E get(int i) {
        return (E)this.objects[i];
    }

    @Override
    public E remove(int i) {
        --this.size;
        for (int j = i; j < this.size; ++j) {
            this.objects[j] = this.objects[j + 1];
        }
        this.objects[this.size] = null;
        return null;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i != -1) {
            this.remove(i);
        }
        return i != -1;
    }

    @Override
    public int indexOf(Object o) {
        int i;
        if (o == null || this.size == 0) {
            return -1;
        }
        for (i = 0; i < this.size; ++i) {
            if (this.objects[i] != o) continue;
            return i;
        }
        for (i = 0; i < this.size; ++i) {
            if (this.objects[i] == null || !this.objects[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    public E getObj(Object o) {
        int i = this.indexOf(o);
        return i == -1 ? null : (E)this.get(i);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.objects = new Object[this.initSize];
        this.size = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        if (this.size == this.objects.length) {
            return this.objects;
        }
        Object[] o = new Object[this.size];
        System.arraycopy(this.objects, 0, o, 0, this.size);
        this.objects = o;
        return this.objects;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return Arrays.copyOf(this.objects, this.size, a.getClass());
    }

    @Override
    public boolean removeAll(Collection<?> list) {
        for (Object e : list) {
            this.remove(e);
        }
        return true;
    }

    @Override
    public boolean contains(Object e) {
        return this.indexOf(e) != -1;
    }

    public FastList<E> clone() {
        FastList<E> l = new FastList<E>(this.initSize, this.incr);
        l.objects = this.toArray();
        l.size = this.size;
        return l;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        if (this.size > 0) {
            if (c == null) {
                Arrays.sort(this.objects, 0, this.size);
            } else {
                Arrays.sort(this.objects, 0, this.size, c);
            }
        }
    }

    public FastList<E> sortToNew(Comparator<? super E> c) {
        FastList<E> l = new FastList<E>();
        if (this.size > 0) {
            l.addAll(this);
            if (c == null) {
                Arrays.sort(l.objects, 0, this.size);
            } else {
                Arrays.sort(l.objects, 0, this.size, c);
            }
        }
        return l;
    }

    public String toString() {
        return LatCore.strip(LatCore.toStrings(this.toArray()));
    }

    @Override
    public boolean isEmpty() {
        return this.size <= 0;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> l) {
        if (l != null && l.size() > 0) {
            this.addAll(l.toArray());
        }
        return true;
    }

    public void addAll(Object[] e) {
        if (e != null && e.length > 0) {
            int s = e.length;
            int incr0 = this.incr;
            this.incr = this.size + s;
            this.expand();
            this.incr = incr0;
            System.arraycopy(e, 0, this.objects, this.size, s);
            this.size += s;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void add(int i, E e) {
        this.add(e);
    }

    @Override
    public int lastIndexOf(Object o) {
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new FastIterator();
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        FastIterator it = new FastIterator();
        it.pos = i;
        return it;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex <= 0 || toIndex - fromIndex >= this.size) {
            return null;
        }
        FastList<E> al = new FastList<E>();
        al.objects = new Object[toIndex - fromIndex];
        System.arraycopy(this.objects, fromIndex, al.objects, 0, fromIndex + toIndex);
        return al;
    }

    public boolean trim(int t) {
        if (this.size > t) {
            FastList<E> newRes = new FastList<E>();
            for (int i = 0; i < t; ++i) {
                newRes.add(this.get(i));
            }
            this.clear();
            this.addAll(newRes);
            return true;
        }
        return false;
    }

    public FastList<E> flip() {
        FastList<E> al1 = new FastList<E>();
        if (this.size == 0) {
            return al1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            al1.add(this.get(i));
        }
        return al1;
    }

    public boolean allObjectsEquals(E e) {
        if (e == null) {
            return this.size > 0 ? this.allObjectsEquals(this.get(0)) : false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.objects[i] == null || this.objects[i].equals(e)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> FastList<T> asList(T ... a) {
        return new FastList(a);
    }

    private class FastIterator
    implements ListIterator<E> {
        private int pos = 0;

        private FastIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < FastList.this.size;
        }

        @Override
        public E next() {
            Object e = FastList.this.get(this.pos);
            ++this.pos;
            return e;
        }

        @Override
        public void remove() {
            FastList.this.remove(this.pos);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        @Override
        public E previous() {
            Object e = FastList.this.get(this.pos - 1);
            --this.pos;
            return e;
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void set(E e) {
            FastList.this.set(this.pos, e);
        }

        @Override
        public void add(E e) {
            FastList.this.add(e);
        }
    }
}

