/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.recipes;

import latmod.core.InvUtils;
import latmod.core.ODItems;
import latmod.core.recipes.IStackArray;
import latmod.core.util.FastList;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class StackEntry
implements IStackArray {
    public final Object item;
    public final FastList<ItemStack> items;
    private int hashCode;
    private StackEntry[] array;

    public StackEntry(Object o) {
        this.item = o;
        this.items = StackEntry.getItems(o);
        this.hashCode = this.toString().hashCode();
        this.array = new StackEntry[]{this};
    }

    public String toString() {
        return "StackEntry: " + this.items.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        FastList<ItemStack> items1 = null;
        items1 = o instanceof StackEntry ? ((StackEntry)o).items : StackEntry.getItems(o);
        if (items1 != null) {
            for (int i = 0; i < items1.size(); ++i) {
                if (!this.equalsItem(items1.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equalsItem(ItemStack is) {
        if (is == null) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!StackEntry.itemsEquals(this.items.get(i), is)) continue;
            return true;
        }
        return false;
    }

    public static StackEntry[] convert(ItemStack ... o) {
        if (o == null) {
            return null;
        }
        StackEntry[] se = new StackEntry[o.length];
        for (int i = 0; i < o.length; ++i) {
            se[i] = o[i] == null ? null : new StackEntry(o[i]);
        }
        return se;
    }

    public static StackEntry[] convert(Object ... o) {
        if (o == null) {
            return null;
        }
        StackEntry[] se = new StackEntry[o.length];
        for (int i = 0; i < o.length; ++i) {
            se[i] = o[i] == null ? null : new StackEntry(o[i]);
        }
        return se;
    }

    public static StackEntry[] convertInv(IInventory inv, int side) {
        if (inv == null) {
            return null;
        }
        return StackEntry.convert(InvUtils.getAllItems(inv, side));
    }

    public static FastList<ItemStack> getItems(Object o) {
        Object list = new FastList<ItemStack>();
        if (o == null) {
            return list;
        }
        if (o instanceof ItemStack) {
            ((FastList)list).add((ItemStack)((ItemStack)o));
        } else if (o instanceof ItemStack[]) {
            ((FastList)list).addAll((ItemStack[])o);
        } else if (o instanceof Item) {
            ((FastList)list).add((ItemStack)new ItemStack((Item)o));
        } else if (o instanceof Block) {
            ((FastList)list).add((ItemStack)new ItemStack((Block)o));
        } else if (o instanceof String) {
            list = ODItems.getOres((String)o).clone();
        } else if (o instanceof FluidStack) {
            FluidStack fs = (FluidStack)o;
            FluidContainerRegistry.FluidContainerData[] fd = FluidContainerRegistry.getRegisteredFluidContainerData();
            if (fd != null && fd.length > 0) {
                for (FluidContainerRegistry.FluidContainerData f : fd) {
                    if (f.fluid.getFluid() != fs.getFluid() || f.fluid.amount < fs.amount || f.filledContainer == null) continue;
                    ((FastList)list).add(f.filledContainer.func_77946_l());
                }
            }
        } else if (o instanceof Fluid) {
            return StackEntry.getItems(new FluidStack((Fluid)o, 1000));
        }
        return list;
    }

    public static boolean itemsEquals(ItemStack is1, ItemStack is2) {
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null || is2 == null) {
            return false;
        }
        if (is1.func_77973_b() == is2.func_77973_b()) {
            int dmg2;
            int dmg1 = is1.func_77960_j();
            return dmg1 == (dmg2 = is1.func_77960_j()) || dmg2 == Short.MAX_VALUE;
        }
        return false;
    }

    @Override
    public boolean matches(ItemStack[] ai) {
        return ai != null && ai.length == 1 && this.equalsItem(ai[0]);
    }

    @Override
    public StackEntry[] getItems() {
        return this.array;
    }

    public static ItemStack getFrom(Object o) {
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        return null;
    }
}

