/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.LMPlayer;
import latmod.core.LatCoreMC;
import latmod.core.event.LMPlayerEvent;
import latmod.core.gui.ButtonLM;
import latmod.core.gui.ContainerEmpty;
import latmod.core.gui.GuiLM;
import latmod.core.gui.TextBoxLM;
import latmod.core.gui.TextureCoords;
import latmod.core.mod.LC;
import latmod.core.mod.client.LCClient;
import latmod.core.mod.client.LCGuiFactory;
import latmod.core.net.MessageLM;
import latmod.core.net.MessageManageGroups;
import latmod.core.util.FastList;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFriends
extends GuiLM {
    public static final ResourceLocation texPlayers = LC.mod.getLocation("textures/gui/players.png");
    public static final ResourceLocation texActions = LC.mod.getLocation("textures/gui/actions.png");
    public static final ResourceLocation texView = LC.mod.getLocation("textures/gui/view.png");
    public static final TextureCoords[] icon_status = new TextureCoords[]{new TextureCoords(texPlayers, 161, 0), new TextureCoords(texPlayers, 179, 0), new TextureCoords(texPlayers, 197, 0)};
    public final LMPlayer owner;
    public final FastList<Player> players;
    public TextBoxLM searchBox;
    public ButtonLM buttonSave;
    public ButtonLM buttonPrevPage;
    public ButtonLM buttonNextPage;
    public ButtonPlayer pbOwner;
    public ButtonPlayer[] pbPlayers;
    public int page = 0;
    public boolean changed = false;
    private static LMPlayer selectedPlayer = null;
    private static boolean viewOpen = false;
    private static float viewPos = 0.0f;
    private static AbstractClientPlayer selectedPlayerEntity = null;
    public ButtonLM buttonAdd;
    public ButtonLM buttonInfo;
    public ButtonLM buttonClose;
    public ButtonLM buttonView;

    public GuiFriends(EntityPlayer ep) {
        super(new ContainerEmpty(ep, null), texPlayers);
        this.owner = LMPlayer.getPlayer(ep);
        this.players = new FastList();
        this.field_146999_f = 161;
        this.field_147000_g = 184;
        this.searchBox = new TextBoxLM(this, 24, 5, 113, 18){

            @Override
            public void textChanged() {
                GuiFriends.this.updateButtons();
            }
        };
        this.widgets.add(this.searchBox);
        this.searchBox.charLimit = 15;
        this.buttonSave = new ButtonLM(this, 139, 6, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                GuiFriends.this.playClickSound();
                GuiFriends.this.changed = true;
                GuiFriends.this.field_146297_k.field_71439_g.func_71053_j();
            }
        };
        this.widgets.add(this.buttonSave);
        this.buttonSave.title = EnumChatFormatting.GREEN + LC.mod.translate("button.save", new Object[0]);
        this.buttonPrevPage = new ButtonLM(this, 7, 158, 35, 16){

            @Override
            public void onButtonPressed(int b) {
                --GuiFriends.this.page;
                GuiFriends.this.playClickSound();
                GuiFriends.this.updateButtons();
            }
        };
        this.widgets.add(this.buttonPrevPage);
        this.buttonPrevPage.title = "Prev Page";
        this.buttonNextPage = new ButtonLM(this, 120, 159, 35, 16){

            @Override
            public void onButtonPressed(int b) {
                ++GuiFriends.this.page;
                GuiFriends.this.playClickSound();
                GuiFriends.this.updateButtons();
            }
        };
        this.widgets.add(this.buttonNextPage);
        this.buttonNextPage.title = "Next Page";
        this.buttonAdd = new ButtonLM(this, -39, 20, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                GuiFriends.this.playClickSound();
                if (selectedPlayer.equals(GuiFriends.this.owner)) {
                    GuiFriends.this.field_146297_k.func_147108_a((GuiScreen)new LCGuiFactory.ModGuiConfig((GuiScreen)GuiFriends.this));
                } else if (GuiFriends.this.owner.isFriendRaw(selectedPlayer)) {
                    GuiFriends.this.sendUpdate(2, selectedPlayer.playerID);
                } else {
                    GuiFriends.this.sendUpdate(1, selectedPlayer.playerID);
                }
                GuiFriends.this.refreshActionButtons();
            }

            @Override
            public boolean isEnabled() {
                return selectedPlayer != null;
            }
        };
        this.widgets.add(this.buttonAdd);
        this.buttonInfo = new ButtonLM(this, -20, 39, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                GuiFriends.this.playClickSound();
            }

            @Override
            public boolean isEnabled() {
                return LatCoreMC.isDevEnv;
            }
        };
        this.widgets.add(this.buttonInfo);
        this.buttonInfo.title = "[WIP] " + LC.mod.translate("button.info", new Object[0]);
        this.buttonClose = new ButtonLM(this, -20, 20, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                GuiFriends.this.playClickSound();
                selectedPlayer = null;
            }

            @Override
            public boolean isEnabled() {
                return selectedPlayer != null;
            }
        };
        this.widgets.add(this.buttonClose);
        this.buttonClose.title = LC.mod.translate("button.close", new Object[0]);
        this.buttonView = new ButtonLM(this, -39, 39, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                GuiFriends.this.playClickSound();
                viewOpen = !viewOpen;
                GuiFriends.this.refreshActionButtons();
            }

            @Override
            public boolean isEnabled() {
                return selectedPlayer != null;
            }
        };
        this.widgets.add(this.buttonView);
        this.buttonView.title = LC.mod.translate("button.viewPlayer", new Object[0]);
        this.pbOwner = new ButtonPlayer(this, -1, 5, 5);
        this.widgets.add(this.pbOwner);
        this.pbOwner.setPlayer(new Player(this.owner));
        this.pbPlayers = new ButtonPlayer[56];
        for (int i = 0; i < this.pbPlayers.length; ++i) {
            this.pbPlayers[i] = new ButtonPlayer(this, i, 5 + i % 8 * 19, 25 + i / 8 * 19);
            this.widgets.add(this.pbPlayers[i]);
        }
        this.updateButtons();
    }

    public void refreshActionButtons() {
        if (selectedPlayer == null) {
            return;
        }
        this.buttonAdd.title = this.owner.equals(selectedPlayer) ? LC.mod.translate("button.settings", new Object[0]) : (this.owner.isFriendRaw(selectedPlayer) ? LC.mod.translate("button.remFriend", new Object[0]) : LC.mod.translate("button.addFriend", new Object[0]));
    }

    public void sendUpdate(int c, int u) {
        this.changed = true;
        MessageLM.NET.sendToServer((IMessage)new MessageManageGroups(this.owner, c, u));
    }

    public int maxPages() {
        return this.players.size() / this.pbPlayers.length + 1;
    }

    @Override
    public void func_146976_a(float f, int mx, int my) {
        if (selectedPlayer != null) {
            if (viewOpen) {
                if (viewPos > 0.0f) {
                    viewPos -= 2.33f;
                }
                if (viewPos < 0.0f) {
                    viewPos = 0.0f;
                }
            } else {
                if (viewPos < 65.0f) {
                    viewPos += 2.33f;
                }
                if (viewPos > 65.0f) {
                    viewPos = 65.0f;
                }
            }
            if (viewPos > 0.0f) {
                this.setTexture(texView);
                this.func_73729_b(this.field_147003_i - (int)viewPos, this.field_147009_r + 63, 0, 0, 65, 101);
            }
        }
        super.func_146976_a(f, mx, my);
        this.pbOwner.render();
        for (int i = 0; i < this.pbPlayers.length; ++i) {
            this.pbPlayers[i].render();
        }
        if (selectedPlayer != null) {
            this.setTexture(texActions);
            this.func_73729_b(this.field_147003_i - 46, this.field_147009_r + 13, 0, 0, 65, 49);
            this.setTexture(this.texture);
            if (this.owner.equals(selectedPlayer)) {
                this.buttonAdd.render(GuiLM.Icons.settings);
            } else {
                this.buttonAdd.render(this.owner.isFriendRaw(selectedPlayer) ? GuiLM.Icons.Friends.remove : GuiLM.Icons.Friends.add);
            }
            this.buttonInfo.render(GuiLM.Icons.help);
            this.buttonView.render(GuiLM.Icons.Friends.view);
            this.buttonClose.render(GuiLM.Icons.cancel);
        } else {
            viewPos = 0.0f;
        }
        this.buttonSave.render(GuiLM.Icons.accept);
        if (selectedPlayer != null && viewPos > 60.0f && selectedPlayerEntity != null) {
            int x = this.field_147003_i - 31 + (int)(65.0f - viewPos);
            int y = this.field_147009_r + 147;
            if (GuiFriends.func_146272_n()) {
                for (int i = 0; i < 4; ++i) {
                    GuiFriends.selectedPlayerEntity.field_71071_by.field_70460_b[i] = null;
                }
            } else {
                EntityPlayer ep1 = this.field_146297_k.field_71441_e.func_152378_a(GuiFriends.selectedPlayer.uuid);
                if (ep1 != null) {
                    GuiFriends.selectedPlayerEntity.field_71071_by.field_70462_a = (ItemStack[])ep1.field_71071_by.field_70462_a.clone();
                    GuiFriends.selectedPlayerEntity.field_71071_by.field_70460_b = (ItemStack[])ep1.field_71071_by.field_70460_b.clone();
                    GuiFriends.selectedPlayerEntity.field_71071_by.field_70462_a[0] = ep1.field_71071_by.func_70448_g();
                } else {
                    for (int i = 0; i < 4; ++i) {
                        GuiFriends.selectedPlayerEntity.field_71071_by.field_70460_b[i] = GuiFriends.selectedPlayer.lastArmor[i];
                    }
                    GuiFriends.selectedPlayerEntity.field_71071_by.field_70462_a[0] = GuiFriends.selectedPlayer.lastArmor[4];
                }
            }
            GuiInventory.func_147046_a((int)x, (int)y, (int)35, (float)(x - mx), (float)(y - 50 - my), (EntityLivingBase)selectedPlayerEntity);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawText(int mx, int my) {
        this.searchBox.render(30, 10, -5789785);
        this.func_73732_a(this.field_146289_q, this.page + 1 + " / " + this.maxPages(), this.field_147003_i + 81, this.field_147009_r + 163, -12303292);
        if (selectedPlayer != null) {
            String s = GuiFriends.selectedPlayer.username;
            this.func_73731_b(this.field_146289_q, s, this.field_147003_i - this.field_146289_q.func_78256_a(s) - 2, this.field_147009_r + 3, -1);
        }
        super.drawText(mx, my);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        LatCoreMC.EVENT_BUS.register((Object)this);
    }

    public void func_146281_b() {
        LatCoreMC.EVENT_BUS.unregister((Object)this);
        if (this.changed) {
            this.sendUpdate(0, 0);
        }
        super.func_146281_b();
    }

    @SubscribeEvent
    public void onClientEvent(LMPlayerEvent.DataChanged e) {
        this.updateButtons();
    }

    @Override
    protected void func_73869_a(char c, int k) {
        if (k == LCClient.key.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(c, k);
    }

    public void updateButtons() {
        int i;
        this.players.clear();
        for (i = 0; i < LMPlayer.map.values.size(); ++i) {
            LMPlayer p = (LMPlayer)LMPlayer.map.values.get(i);
            if (p.equals(this.owner)) continue;
            this.players.add(new Player(p));
        }
        if (!this.searchBox.text.isEmpty()) {
            FastList<Player> l = new FastList<Player>();
            String s = this.searchBox.text.trim().toLowerCase();
            for (int i2 = 0; i2 < this.players.size(); ++i2) {
                String s1 = this.players.get((int)i2).player.username.toLowerCase();
                if (!s1.contains(s)) continue;
                l.add(this.players.get(i2));
            }
            this.players.clear();
            this.players.addAll(l);
        }
        if (this.page < 0) {
            this.page = this.maxPages() - 1;
        }
        if (this.page >= this.maxPages()) {
            this.page = 0;
        }
        this.players.sort(null);
        for (i = 0; i < this.pbPlayers.length; ++i) {
            int j = i + this.page * this.pbPlayers.length;
            if (j < 0 || j >= this.players.size()) {
                j = -1;
            }
            this.pbPlayers[i].setPlayer(j == -1 ? null : this.players.get(j));
        }
        this.refreshActionButtons();
    }

    public class ButtonPlayer
    extends ButtonLM {
        public Player player;

        public ButtonPlayer(GuiLM g, int i, int x, int y) {
            super(g, x, y, 18, 18);
            this.player = null;
        }

        public void setPlayer(Player p) {
            this.player = p;
        }

        @Override
        public void onButtonPressed(int b) {
            if (this.player != null) {
                selectedPlayer = this.player.player;
                selectedPlayerEntity = new AbstractClientPlayer((World)GuiFriends.this.field_146297_k.field_71441_e, new GameProfile(selectedPlayer.uuid, selectedPlayer.username)){

                    public void func_145747_a(IChatComponent p_145747_1_) {
                    }

                    public boolean func_70003_b(int p_70003_1_, String p_70003_2_) {
                        return false;
                    }

                    public ChunkCoordinates func_82114_b() {
                        return new ChunkCoordinates(0, 0, 0);
                    }

                    public boolean func_98034_c(EntityPlayer ep) {
                        return true;
                    }
                };
                selectedPlayerEntity.func_152121_a(MinecraftProfileTexture.Type.SKIN, AbstractClientPlayer.func_110311_f((String)selectedPlayer.username));
                selectedPlayerEntity.field_71071_by.field_70461_c = 0;
            }
            GuiFriends.this.refreshActionButtons();
        }

        @Override
        public void addMouseOverText(FastList<String> al) {
            if (this.player != null) {
                LMPlayer p = LMPlayer.getPlayer(this.player.player.playerID);
                if (p == null) {
                    return;
                }
                al.add(p.username);
                if (p.isOnline()) {
                    al.add(EnumChatFormatting.GREEN + "[" + LC.mod.translate("label.online", new Object[0]) + "]");
                }
                if (!this.player.isOwner()) {
                    boolean raw1 = p.isFriendRaw(GuiFriends.this.owner);
                    boolean raw2 = GuiFriends.this.owner.isFriendRaw(p);
                    if (raw1 && raw2) {
                        al.add(EnumChatFormatting.GREEN + "[" + LC.mod.translate("label.friend", new Object[0]) + "]");
                    } else if (raw1 || raw2) {
                        al.add((raw1 ? EnumChatFormatting.GOLD : EnumChatFormatting.BLUE) + "[" + LC.mod.translate("label.pfriend", new Object[0]) + "]");
                    }
                }
            }
        }

        public void render() {
            if (this.player != null) {
                int status;
                this.background = null;
                GuiFriends.this.drawPlayerHead(this.player.player.username, GuiFriends.this.field_147003_i + this.posX + 1, GuiFriends.this.field_147009_r + this.posY + 1, 16.0, 16.0);
                if (this.player.player.isOnline()) {
                    this.render(GuiLM.Icons.Friends.online);
                }
                if (!this.player.isOwner() && (status = this.player.getStatus()) > 0) {
                    this.render(icon_status[status - 1]);
                }
            }
        }
    }

    public class Player
    implements Comparable<Player> {
        public final LMPlayer player;
        public final boolean isOwner;

        public Player(LMPlayer p) {
            this.player = p;
            this.isOwner = this.player.equals(GuiFriends.this.owner);
        }

        @Override
        public int compareTo(Player o) {
            int s0 = this.getStatus();
            int s1 = o.getStatus();
            if (s0 == 0 && s1 != 0) {
                return 1;
            }
            if (s0 != 0 && s1 == 0) {
                return -1;
            }
            if (s0 == s1) {
                boolean on0 = this.player.isOnline();
                boolean on1 = o.player.isOnline();
                if (on0 && !on1) {
                    return -1;
                }
                if (!on0 && on1) {
                    return 1;
                }
                return this.player.username.compareToIgnoreCase(o.player.username);
            }
            return Integer.compare(s0, s1);
        }

        public boolean equals(Object o) {
            if (o instanceof Player) {
                return this.equals(((Player)o).player);
            }
            return this.player.equals(o);
        }

        public boolean isOwner() {
            return GuiFriends.this.owner.equals(this.player);
        }

        public int getStatus() {
            boolean b1 = GuiFriends.this.owner.isFriendRaw(this.player);
            boolean b2 = this.player.isFriendRaw(GuiFriends.this.owner);
            if (b1 && b2) {
                return 1;
            }
            if (b1 && !b2) {
                return 2;
            }
            if (!b1 && b2) {
                return 3;
            }
            return 0;
        }
    }
}

