/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Map;
import latmod.core.LMMod;
import latmod.core.LatCoreMC;
import latmod.core.ODItems;
import latmod.core.mod.LCCommon;
import latmod.core.mod.LCConfig;
import latmod.core.mod.LCEventHandler;
import latmod.core.mod.LCGuiHandler;
import latmod.core.mod.cmd.CmdLMFriends;
import latmod.core.mod.cmd.CmdLatCore;
import latmod.core.mod.cmd.CmdLatCoreAdmin;
import latmod.core.net.MessageLM;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

@Mod(modid="LatCoreMC", name="LatCoreMC", version="1.6.9", dependencies="required-after:Forge@[10.13.2.1291,);after:Baubles;after:Waila", guiFactory="latmod.core.mod.client.LCGuiFactory")
public class LC {
    protected static final String MOD_ID = "LatCoreMC";
    public static final String VERSION = "1.6.9";
    @Mod.Instance(value="LatCoreMC")
    public static LC inst;
    @SidedProxy(clientSide="latmod.core.mod.client.LCClient", serverSide="latmod.core.mod.LCCommon")
    public static LCCommon proxy;
    public static LMMod mod;
    private ModMetadata modMeta;

    public LC() {
        LatCoreMC.addEventHandler(LCEventHandler.instance, true, true, true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        if (LatCoreMC.isDevEnv) {
            LatCoreMC.logger.info("Loading LatCoreMC, Dev Build");
        } else {
            LatCoreMC.logger.info("Loading LatCoreMC, Build #1.6.9");
        }
        this.modMeta = e.getModMetadata();
        LatCoreMC.latmodFolder = new File(e.getModConfigurationDirectory().getParentFile(), "latmod/");
        if (!LatCoreMC.latmodFolder.exists()) {
            LatCoreMC.latmodFolder.mkdirs();
        }
        mod = new LMMod(e, new LCConfig(e), null);
        LC.mod.logger = LatCoreMC.logger;
        ODItems.preInit();
        mod.onPostLoaded();
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        MessageLM.init();
        proxy.init(e);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"latmod.core.event.RegisterWailaEvent.registerHandlers");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        ODItems.postInit();
        mod.loadRecipes();
        LCConfig.Recipes.loadRecipes();
        proxy.postInit(e);
        boolean addedDesc = false;
        if (this.modMeta != null) {
            for (int i = 0; i < LMMod.modsMap.size(); ++i) {
                LMMod m = (LMMod)LMMod.modsMap.values.get(i);
                if (m.modID.equals(LC.mod.modID)) continue;
                if (!addedDesc) {
                    this.modMeta.description = this.modMeta.description + EnumChatFormatting.GREEN + "\n\nMods using LatCoreMC:";
                    addedDesc = true;
                }
                this.modMeta.description = this.modMeta.description + "\n" + m.modID;
            }
        }
        for (String s : LCGuiHandler.IDs) {
            LatCoreMC.addLMGuiHandler(s, LCGuiHandler.instance);
        }
    }

    @Mod.EventHandler
    public void registerCommands(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CmdLatCore());
        e.registerServerCommand((ICommand)new CmdLMFriends());
        e.registerServerCommand((ICommand)new CmdLatCoreAdmin());
    }

    @Mod.EventHandler
    public void shuttingDown(FMLServerStoppingEvent e) {
        if (LatCoreMC.hasOnlinePlayers()) {
            for (EntityPlayerMP ep : LatCoreMC.getAllOnlinePlayers().values) {
                LCEventHandler.instance.playerLoggedOut(new PlayerEvent.PlayerLoggedOutEvent((EntityPlayer)ep));
            }
        }
    }

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> m, Side side) {
        String s = m.get(MOD_ID);
        return s == null || s.equals(VERSION) || VERSION.equals("@VERSION@");
    }
}

