/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.gui.GuiLM;
import latmod.core.gui.TextureCoords;
import latmod.core.util.FastList;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class WidgetLM {
    public final GuiLM gui;
    public int posX;
    public int posY;
    public int width;
    public int height;
    public String title = null;

    public WidgetLM(GuiLM g, int x, int y, int w, int h) {
        this.gui = g;
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
    }

    public boolean isAt(int x, int y) {
        return x >= this.posX && y >= this.posY && x < this.posX + this.width && y < this.posY + this.height;
    }

    public boolean mouseOver(int mx, int my) {
        return this.isAt(mx - this.gui.getPosX(), my - this.gui.getPosY());
    }

    public void render(Object icon, double rw, double rh) {
        if (icon == null) {
            return;
        }
        if (icon instanceof IIcon) {
            this.gui.setTexture(TextureMap.field_110576_c);
            this.gui.func_94065_a(this.posX + this.gui.getPosX(), this.posY + this.gui.getPosY(), (IIcon)icon, (int)((double)this.width * rw), (int)((double)this.height * rh));
        } else if (icon instanceof TextureCoords) {
            ((TextureCoords)icon).render(this.gui, this.posX, this.posY, (int)((double)this.width * rw), (int)((double)this.height * rh));
        }
    }

    public void render(Object icon) {
        this.render(icon, 1.0, 1.0);
    }

    public boolean mousePressed(int mx, int my, int b) {
        return false;
    }

    public void voidMousePressed(int mx, int my, int b) {
    }

    public boolean keyPressed(int key, char keyChar) {
        return false;
    }

    public void addMouseOverText(FastList<String> l) {
        if (this.title != null) {
            l.add(this.title);
        }
    }
}

