/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.event;

import latmod.core.event.EventLM;
import latmod.core.tile.IWailaTile;
import latmod.core.waila.BasicWailaHandler;
import latmod.core.waila.WailaLMTile;
import latmod.core.waila.WailaType;
import mcp.mobius.waila.api.IWailaRegistrar;

public class RegisterWailaEvent
extends EventLM {
    public final IWailaRegistrar registry;

    public RegisterWailaEvent(IWailaRegistrar i) {
        this.registry = i;
    }

    public void register(Class<?> block, BasicWailaHandler h) {
        if (h.types.contains((Object)WailaType.STACK)) {
            this.registry.registerStackProvider(h, block);
        }
        if (h.types.contains((Object)WailaType.HEAD)) {
            this.registry.registerHeadProvider(h, block);
        }
        if (h.types.contains((Object)WailaType.BODY)) {
            this.registry.registerBodyProvider(h, block);
        }
        if (h.types.contains((Object)WailaType.TAIL)) {
            this.registry.registerTailProvider(h, block);
        }
    }

    public static void registerHandlers(IWailaRegistrar i) {
        RegisterWailaEvent e = new RegisterWailaEvent(i);
        e.register(IWailaTile.Stack.class, new WailaLMTile(e, WailaType.STACK));
        e.register(IWailaTile.Head.class, new WailaLMTile(e, WailaType.HEAD));
        e.register(IWailaTile.Body.class, new WailaLMTile(e, WailaType.BODY));
        e.register(IWailaTile.Tail.class, new WailaLMTile(e, WailaType.TAIL));
        e.post();
    }
}

