/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.client.playerdeco;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.client.playerdeco.PDDustCol;
import latmod.core.client.playerdeco.PDFTB;
import latmod.core.client.playerdeco.PDLatMod;
import latmod.core.client.playerdeco.PDParticles;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderPlayerEvent;

@SideOnly(value=Side.CLIENT)
public abstract class PlayerDecorator {
    public static final FastMap<String, Class<? extends PlayerDecorator>> map = new FastMap();
    private String name = null;

    public String toString() {
        if (this.name == null) {
            this.name = map.getKey(this.getClass());
        }
        return this.name;
    }

    public static PlayerDecorator getFromLine(String line) {
        String[] s = LatCore.split(line, ":");
        Class<? extends PlayerDecorator> c = map.get(s[0]);
        if (c == null) {
            return null;
        }
        try {
            PlayerDecorator pd = c.newInstance();
            if (s.length == 2) {
                FastMap<String, String> data = new FastMap<String, String>();
                String[] s1 = LatCore.split(s[1], ";");
                for (int i = 0; i < s1.length; ++i) {
                    String[] s2 = LatCore.split(s1[i], "=");
                    if (s2.length != 2) continue;
                    data.put(s2[0], s2[1]);
                }
                pd.onDataLoaded(data);
            }
            return pd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasMoved(Entity e) {
        if (e.field_70169_q != e.field_70165_t) {
            return true;
        }
        if (e.field_70167_r != e.field_70163_u) {
            return true;
        }
        return e.field_70166_s != e.field_70161_v;
    }

    public abstract void onDataLoaded(FastMap<String, String> var1);

    public abstract void onPlayerRender(RenderPlayerEvent.Specials.Post var1);

    public String getS(FastMap<String, String> map, String key, String def) {
        String s = map.get(key);
        return s == null ? def : s;
    }

    public Number getN(FastMap<String, String> map, String key, Number def) {
        return new Double(Double.parseDouble(this.getS(map, key, def + "")));
    }

    static {
        map.put("latmod", PDLatMod.class);
        map.put("ftb", PDFTB.class);
        map.put("part", PDParticles.class);
        map.put("dust", PDDustCol.class);
    }
}

