/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.client.playerdeco;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.ParticleHelper;
import latmod.core.client.playerdeco.PlayerDecorator;
import latmod.core.util.FastMap;
import latmod.core.util.MathHelperLM;
import net.minecraftforge.client.event.RenderPlayerEvent;

@SideOnly(value=Side.CLIENT)
public class PDParticles
extends PlayerDecorator {
    public String part = null;
    public int rarity_still;
    public int rarity_moving;
    public int quantity_still;
    public int quantity_moving;
    public double parA = 0.0;
    public double parB = 0.0;
    public double parC = 0.0;

    @Override
    public void onDataLoaded(FastMap<String, String> data) {
        this.part = this.getS(data, "id", null);
        if (this.part != null) {
            this.rarity_still = this.getN(data, "rs", 10).intValue();
            this.rarity_moving = this.getN(data, "rm", 3).intValue();
            this.quantity_still = this.getN(data, "qs", 1).intValue();
            this.quantity_moving = this.getN(data, "qm", 1).intValue();
            this.parA = this.getN(data, "pA", 0.0).doubleValue();
            this.parB = this.getN(data, "pB", 0.0).doubleValue();
            this.parC = this.getN(data, "pC", 0.0).doubleValue();
        }
    }

    @Override
    public void onPlayerRender(RenderPlayerEvent.Specials.Post e) {
        if (this.part != null) {
            boolean hasMoved = this.hasMoved(e.entity);
            boolean spawnPart = false;
            if (hasMoved && this.rarity_moving > 0 && this.quantity_moving > 0) {
                boolean bl = spawnPart = this.rarity_moving == 1 || ParticleHelper.rand.nextInt(this.rarity_moving) == 0;
            }
            if (!hasMoved && this.rarity_still > 0 && this.quantity_still > 0) {
                boolean bl = spawnPart = this.rarity_still == 1 || ParticleHelper.rand.nextInt(this.rarity_still) == 0;
            }
            if (spawnPart) {
                for (int i = 0; i < (hasMoved ? this.quantity_moving : this.quantity_still); ++i) {
                    double w = (double)e.entity.field_70130_N / 2.0;
                    double x = MathHelperLM.randomDouble(ParticleHelper.rand, e.entity.field_70165_t - w, e.entity.field_70165_t + w);
                    double y = MathHelperLM.randomDouble(ParticleHelper.rand, e.entity.field_70121_D.field_72338_b, e.entity.field_70121_D.field_72337_e);
                    double z = MathHelperLM.randomDouble(ParticleHelper.rand, e.entity.field_70161_v - w, e.entity.field_70161_v + w);
                    ParticleHelper.spawnPart(e.entity.field_70170_p, this.part, x, y, z, this.parA, this.parB, this.parC);
                }
            }
        }
    }
}

