/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.client.playerdeco;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import latmod.core.ParticleHelper;
import latmod.core.client.playerdeco.PlayerDecorator;
import latmod.core.mod.LC;
import latmod.core.util.FastMap;
import latmod.core.util.MathHelperLM;
import net.minecraftforge.client.event.RenderPlayerEvent;

@SideOnly(value=Side.CLIENT)
public class PDDustCol
extends PlayerDecorator {
    public int rarity_still;
    public int rarity_moving;
    public int quantity_still;
    public int quantity_moving;
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public int color;

    @Override
    public void onDataLoaded(FastMap<String, String> data) {
        this.rarity_still = this.getN(data, "rs", 10).intValue();
        this.rarity_moving = this.getN(data, "rm", 3).intValue();
        this.quantity_still = this.getN(data, "qs", 1).intValue();
        this.quantity_moving = this.getN(data, "qm", 1).intValue();
        this.red = this.getN(data, "r", Float.valueOf(1.0f)).floatValue();
        this.green = this.getN(data, "g", Float.valueOf(1.0f)).floatValue();
        this.blue = this.getN(data, "b", Float.valueOf(1.0f)).floatValue();
        this.alpha = this.getN(data, "a", Float.valueOf(1.0f)).floatValue();
        this.color = new Color((int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f), (int)(this.alpha * 255.0f)).getRGB();
    }

    @Override
    public void onPlayerRender(RenderPlayerEvent.Specials.Post e) {
        if (!LC.proxy.inGameHasFocus()) {
            return;
        }
        boolean hasMoved = this.hasMoved(e.entity);
        boolean spawnPart = false;
        if (hasMoved && this.rarity_moving > 0 && this.quantity_moving > 0) {
            boolean bl = spawnPart = this.rarity_moving == 1 || ParticleHelper.rand.nextInt(this.rarity_moving) == 0;
        }
        if (!hasMoved && this.rarity_still > 0 && this.quantity_still > 0) {
            boolean bl = spawnPart = this.rarity_still == 1 || ParticleHelper.rand.nextInt(this.rarity_still) == 0;
        }
        if (spawnPart) {
            for (int i = 0; i < (hasMoved ? this.quantity_moving : this.quantity_still); ++i) {
                double w = (double)e.entity.field_70130_N / 2.0;
                double x = MathHelperLM.randomDouble(ParticleHelper.rand, e.entity.field_70165_t - w, e.entity.field_70165_t + w);
                double y = MathHelperLM.randomDouble(ParticleHelper.rand, e.entity.field_70121_D.field_72338_b, e.entity.field_70121_D.field_72337_e);
                double z = MathHelperLM.randomDouble(ParticleHelper.rand, e.entity.field_70161_v - w, e.entity.field_70161_v + w);
                LC.proxy.spawnDust(e.entity.field_70170_p, x, y, z, this.color);
            }
        }
    }
}

