/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import latmod.core.LatCoreMC;
import latmod.core.client.LMRenderHelper;
import latmod.core.client.model.Face;
import latmod.core.client.model.Group;
import latmod.core.util.FastList;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class OBJModel {
    public FastList<Face> totalFaces = new FastList();
    public FastList<Vector3f> vertices = new FastList();
    public FastList<Vector3f> vertexNormals = new FastList();
    public FastList<Vector3f> texVertices = new FastList();
    public Group[] groups = new Group[0];
    private Group current = null;
    public String[] groupNames = null;
    public double sizeV = 0.0;
    public FastMap<Integer, Group> groupIDMap = new FastMap();

    protected OBJModel() {
    }

    public static OBJModel load(ResourceLocation rl) {
        try {
            return OBJModel.load(OBJModel.class.getResourceAsStream(LatCoreMC.getPath(rl)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OBJModel load(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        OBJModel m = new OBJModel();
        if (br.ready()) {
            double minSizeV = Double.POSITIVE_INFINITY;
            double maxSizeV = Double.NEGATIVE_INFINITY;
            FastList<String> gnames = new FastList<String>();
            FastList<Group> groups0 = new FastList<Group>();
            String s = null;
            while ((s = br.readLine()) != null) {
                Face f;
                float z;
                float y;
                if (s.length() <= 0 || s.charAt(0) == '#') continue;
                String[] s3 = LatCore.split(s, " ");
                if (s3[0].equals("o")) {
                    Group g = new Group(m, s3[1]);
                    if (m.current != null) {
                        groups0.add(m.current);
                    }
                    m.current = g;
                    gnames.add(g.groupName);
                    continue;
                }
                if (s3[0].equals("g") || s3[0].equals("s") || s3[0].equals("mtllib") || s3[0].equals("usemtl")) continue;
                if (s3[0].equals("v")) {
                    float x = Float.parseFloat(s3[1]);
                    y = Float.parseFloat(s3[2]);
                    z = Float.parseFloat(s3[3]);
                    m.vertices.add(new Vector3f(x, y, z));
                    if ((double)y < minSizeV) {
                        minSizeV = y;
                    }
                    if (!((double)y > maxSizeV)) continue;
                    maxSizeV = y;
                    continue;
                }
                if (s3[0].equals("vn")) {
                    float x = Float.parseFloat(s3[1]);
                    y = Float.parseFloat(s3[2]);
                    z = Float.parseFloat(s3[3]);
                    m.vertexNormals.add(new Vector3f(x, y, z));
                    continue;
                }
                if (s3[0].equals("vt")) {
                    if (s3.length == 3) {
                        float x = Float.parseFloat(s3[1]);
                        y = Float.parseFloat(s3[2]);
                        m.texVertices.add(new Vector3f(x, 1.0f - y, -1.0f));
                        continue;
                    }
                    if (s3.length != 4) continue;
                    float x = Float.parseFloat(s3[1]);
                    y = Float.parseFloat(s3[2]);
                    z = Float.parseFloat(s3[3]);
                    m.texVertices.add(new Vector3f(x, 1.0f - y, z));
                    continue;
                }
                if (!s3[0].equals("f")) continue;
                if (m.current == null) {
                    m.current = new Group(m, "Default");
                }
                if ((f = Face.parseFace(m, s, s3)) == null) continue;
                m.current.faces.add(f);
                m.totalFaces.add(f);
            }
            groups0.add(m.current);
            m.groups = groups0.toArray((E[])new Group[0]);
            m.groupNames = gnames.toArray((E[])new String[0]);
            m.sizeV = maxSizeV - minSizeV;
        }
        if (m != null && m.texVertices != null) {
            LMRenderHelper.enableTexture();
        } else {
            LMRenderHelper.disableTexture();
        }
        m.renderAll();
        return m;
    }

    public void renderAll() {
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i].render();
        }
    }

    public void render(int ... index) {
        for (int i = 0; i < index.length; ++i) {
            if (index[i] < 0 || index[i] >= this.groups.length) continue;
            this.groups[index[i]].render();
        }
    }

    public void renderAllExcept(int ... index) {
        for (int i = 0; i < this.groups.length; ++i) {
            boolean render = true;
            for (int j = 0; j < index.length; ++j) {
                if (!render || i != index[j]) continue;
                render = false;
            }
            if (!render) continue;
            this.groups[i].render();
        }
    }

    public boolean hasGroup(String s) {
        return this.getGroup(s) != null;
    }

    public Group getGroup(String s) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].groupName.equalsIgnoreCase(s)) continue;
            return this.groups[i];
        }
        return null;
    }

    public int getGroupIndex(String s) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].groupName.equalsIgnoreCase(s)) continue;
            return i;
        }
        return -1;
    }

    public OBJModel copy(boolean render) {
        OBJModel m = new OBJModel();
        m.vertices.addAll(this.vertices);
        m.texVertices.addAll(this.texVertices);
        m.vertexNormals.addAll(this.vertexNormals);
        m.groups = (Group[])this.groups.clone();
        m.groupNames = (String[])this.groupNames.clone();
        m.totalFaces.addAll(this.totalFaces);
        m.sizeV = this.sizeV;
        if (render) {
            if (m != null && m.texVertices != null) {
                LMRenderHelper.enableTexture();
            } else {
                LMRenderHelper.disableTexture();
            }
            m.renderAll();
        }
        return m;
    }
}

