/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.client.LMRenderHelper;
import latmod.core.client.model.Face;
import latmod.core.client.model.OBJModel;
import latmod.core.util.FastList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class Group {
    public OBJModel parent;
    public String groupName;
    public FastList<Face> faces = new FastList();
    private int listID = -1;
    public Vector3f pos;
    public Vector3f rotation;
    public Vector3f offset;

    public Group(OBJModel m, String s) {
        this.parent = m;
        this.groupName = s;
        this.pos = new Vector3f();
        this.rotation = new Vector3f();
        this.offset = new Vector3f();
    }

    public void render() {
        boolean hasRotation;
        if (this.listID == -1) {
            if (this.parent.texVertices == null) {
                LMRenderHelper.disableTexture();
            } else {
                LMRenderHelper.enableTexture();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.listID = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.listID, (int)4864);
            float posX0 = 0.0f;
            float posY0 = 0.0f;
            float posZ0 = 0.0f;
            float vSize = 0.0f;
            for (int i = 0; i < this.faces.size(); ++i) {
                Face f = this.faces.get(i);
                GL11.glBegin((int)f.drawMode);
                for (int j = 0; j < f.verticies.length; ++j) {
                    Vector3f vn;
                    Vector3f v = this.parent.vertices.get(f.verticies[j]);
                    if (f.texVerticies != null) {
                        Vector3f vt = this.parent.texVertices.get(f.texVerticies[j]);
                        if (vt.z == -1.0f) {
                            GL11.glTexCoord2f((float)vt.x, (float)vt.y);
                        } else {
                            GL11.glTexCoord3f((float)vt.x, (float)vt.y, (float)vt.z);
                        }
                    }
                    if ((vn = this.parent.vertexNormals.get(f.normals[j])) != null) {
                        GL11.glNormal3f((float)vn.x, (float)vn.y, (float)vn.z);
                    } else {
                        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    GL11.glVertex3f((float)v.x, (float)v.y, (float)v.z);
                    posX0 += v.x;
                    posY0 += v.y;
                    posZ0 += v.z;
                    vSize += 1.0f;
                }
                GL11.glEnd();
            }
            GL11.glEndList();
            this.pos.x = posX0 / vSize;
            this.pos.y = posY0 / vSize;
            this.pos.z = posZ0 / vSize;
        }
        boolean hasOffset = this.offset.lengthSquared() != 0.0f;
        boolean bl = hasRotation = this.rotation.lengthSquared() != 0.0f;
        if (hasOffset || hasRotation) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.pos.x, (float)this.pos.y, (float)this.pos.z);
            if (hasOffset) {
                GL11.glTranslatef((float)this.offset.x, (float)this.offset.y, (float)this.offset.z);
            }
            if (hasRotation) {
                GL11.glRotatef((float)this.rotation.y, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.rotation.x, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)this.rotation.z, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (hasOffset) {
                GL11.glTranslatef((float)this.offset.x, (float)this.offset.y, (float)this.offset.z);
            }
            GL11.glTranslatef((float)(-this.pos.x), (float)(-this.pos.y), (float)(-this.pos.z));
            GL11.glCallList((int)this.listID);
            GL11.glPopMatrix();
        } else {
            GL11.glCallList((int)this.listID);
        }
    }
}

