/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.client.model.OBJModel;
import latmod.core.util.LatCore;

@SideOnly(value=Side.CLIENT)
public class Face {
    public int[] verticies = null;
    public int[] texVerticies = null;
    public int[] normals = null;
    public int drawMode = -1;

    private Face(int i, boolean tex, boolean norm) {
        this.verticies = new int[i];
        if (tex) {
            this.texVerticies = new int[i];
        }
        if (norm) {
            this.normals = new int[i];
        }
        this.drawMode = i == 3 ? 4 : (i == 4 ? 7 : 9);
    }

    public static final Face parseFace(OBJModel m, String line, String[] s1) {
        String[] s = new String[s1.length - 1];
        for (int i = 0; i < s.length; ++i) {
            s[i] = s1[i + 1];
        }
        if (Face.isValidFace_V_VN_Line(line)) {
            Face face = new Face(s.length, false, true);
            for (int i = 0; i < s.length; ++i) {
                String[] s2 = s[i].split("//");
                face.verticies[i] = Integer.parseInt(s2[0]) - 1;
                face.normals[i] = Integer.parseInt(s2[1]) - 1;
            }
            return face;
        }
        if (Face.isValidFace_V_VT_VN_Line(line)) {
            Face face = new Face(s.length, true, true);
            for (int i = 0; i < s.length; ++i) {
                String[] s2 = s[i].split("/");
                face.verticies[i] = Integer.parseInt(s2[0]) - 1;
                face.texVerticies[i] = Integer.parseInt(s2[1]) - 1;
                face.normals[i] = Integer.parseInt(s2[2]) - 1;
            }
            return face;
        }
        if (Face.isValidFace_V_VT_Line(line)) {
            Face face = new Face(s.length, true, false);
            for (int i = 0; i < s.length; ++i) {
                String[] s2 = s[i].split("/");
                face.verticies[i] = Integer.parseInt(s2[0]) - 1;
                face.texVerticies[i] = Integer.parseInt(s2[1]) - 1;
            }
            return face;
        }
        if (Face.isValidFace_V_Line(line)) {
            Face face = new Face(s.length, false, false);
            for (int i = 0; i < s.length; ++i) {
                face.verticies[i] = Integer.parseInt(s[i]) - 1;
            }
            return face;
        }
        System.err.println("[LM_Obj_Loader] Unknown face format: " + line);
        return null;
    }

    private static boolean isValidFace_V_VT_VN_Line(String line) {
        String[] s1;
        if (!line.contains("/") || !line.contains(" ")) {
            return false;
        }
        String[] s = LatCore.split(line, " ");
        return s != null && s.length > 1 && (s1 = s[1].split("/")) != null && s1.length == 3;
    }

    private static boolean isValidFace_V_VT_Line(String line) {
        String[] s1;
        if (!line.contains("/") || !line.contains(" ")) {
            return false;
        }
        String[] s = LatCore.split(line, " ");
        return s != null && s.length > 1 && (s1 = s[1].split("/")) != null && s1.length == 2;
    }

    private static boolean isValidFace_V_VN_Line(String line) {
        return line.contains("//") && line.contains(" ");
    }

    private static boolean isValidFace_V_Line(String line) {
        return line.contains(" ");
    }
}

