/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import latmod.core.InvUtils;
import latmod.core.util.FastList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ODItems {
    public static final int ANY = Short.MAX_VALUE;
    public static final String WOOD = "logWood";
    public static final String SAPLING = "treeSapling";
    public static final String PLANKS = "plankWood";
    public static final String STICK = "stickWood";
    public static final String GLASS = "blockGlassColorless";
    public static final String GLASS_ANY = "blockGlass";
    public static final String GLASS_PANE = "paneGlassColorless";
    public static final String GLASS_PANE_ANY = "paneGlass";
    public static final String STONE = "stone";
    public static final String COBBLE = "cobblestone";
    public static final String SAND = "sand";
    public static final ItemStack OBSIDIAN = new ItemStack(Blocks.field_150343_Z);
    public static final ItemStack WOOL = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
    public static final ItemStack WOOL_WHITE = new ItemStack(Blocks.field_150325_L, 1, 0);
    public static final String SLIMEBALL = "slimeball";
    public static final String MEAT_RAW = "meatRaw";
    public static final String MEAT_COOKED = "meatCooked";
    public static final String RUBBER = "itemRubber";
    public static final String REDSTONE = "dustRedstone";
    public static final String GLOWSTONE = "dustGlowstone";
    public static final String QUARTZ = "gemQuartz";
    public static final String LAPIS = "gemLapis";
    public static final String IRON = "ingotIron";
    public static final String GOLD = "ingotGold";
    public static final String DIAMOND = "gemDiamond";
    public static final String EMERALD = "gemEmerald";
    public static final String TIN = "ingotTin";
    public static final String COPPER = "ingotCopper";
    public static final String LEAD = "ingotLead";
    public static final String BRONZE = "ingotBronze";
    public static final String SILVER = "ingotSilver";
    public static final String RUBY = "gemRuby";
    public static final String SAPPHIRE = "gemSapphire";
    public static final String PERIDOT = "gemPeridot";
    public static final String NUGGET_GOLD = "nuggetGold";
    public static final String NUGGET_TIN = "nuggetTin";
    public static final String NUGGET_COPPER = "nuggetCopper";
    public static final String NUGGET_LEAD = "nuggetLead";
    public static final String NUGGET_SILVER = "nuggetSilver";
    public static final String TOOL_SAW = "toolSaw";
    private static boolean hasFMP = false;

    public static void preInit() {
        ODItems.add(MEAT_RAW, new ItemStack(Items.field_151082_bd));
        ODItems.add(MEAT_RAW, new ItemStack(Items.field_151147_al));
        ODItems.add(MEAT_RAW, new ItemStack(Items.field_151076_bf));
        ODItems.add(MEAT_COOKED, new ItemStack(Items.field_151083_be));
        ODItems.add(MEAT_COOKED, new ItemStack(Items.field_151157_am));
        ODItems.add(MEAT_COOKED, new ItemStack(Items.field_151077_bg));
    }

    public static void postInit() {
        hasFMP = false;
        hasFMP |= ODItems.addOreName("ForgeMicroblock:sawStone", Short.MAX_VALUE, TOOL_SAW);
        hasFMP |= ODItems.addOreName("ForgeMicroblock:sawIron", Short.MAX_VALUE, TOOL_SAW);
        hasFMP |= ODItems.addOreName("ForgeMicroblock:sawDiamond", Short.MAX_VALUE, TOOL_SAW);
        Item wrench = InvUtils.getItemFromRegName("ThermalExpansion:wrench");
        if (wrench != null) {
            wrench.setHarvestLevel("wrench", 0);
        }
    }

    public static boolean hasFMP() {
        return hasFMP;
    }

    private static boolean addOreName(String item, int damage, String name) {
        Item i = InvUtils.getItemFromRegName(item);
        if (i != null) {
            ODItems.add(name, new ItemStack(i, 1, damage));
        }
        return i != null;
    }

    public static void add(String name, ItemStack is) {
        ItemStack is1 = InvUtils.singleCopy(is);
        if (!ODItems.getOres(name).contains(is1)) {
            OreDictionary.registerOre((String)name, (ItemStack)is1);
        }
    }

    public static FastList<String> getOreNames(ItemStack is) {
        int[] ai = OreDictionary.getOreIDs((ItemStack)is);
        if (ai == null || ai.length == 0) {
            return new FastList<String>();
        }
        FastList<String> l = new FastList<String>();
        for (int i : ai) {
            l.add(OreDictionary.getOreName((int)i));
        }
        return l;
    }

    public static FastList<ItemStack> getOres(String name) {
        FastList<ItemStack> l = new FastList<ItemStack>();
        l.addAll(OreDictionary.getOres((String)name));
        return l;
    }

    public static ItemStack getFirstOre(String name) {
        FastList<ItemStack> l = ODItems.getOres(name);
        if (!l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public static boolean hasOre(String s) {
        return !ODItems.getOres(s).isEmpty();
    }

    public static final class OreStackEntry {
        public final ItemStack itemStack;
        public final String oreName;

        public OreStackEntry(ItemStack is, String s) {
            this.itemStack = is;
            this.oreName = s;
        }

        public boolean equals(Object o) {
            ItemStack is = o == null ? null : (o instanceof OreStackEntry ? ((OreStackEntry)o).itemStack : (ItemStack)o);
            return is.func_77973_b() == this.itemStack.func_77973_b() && (is.func_77960_j() == this.itemStack.func_77960_j() || this.itemStack.func_77960_j() == Short.MAX_VALUE);
        }
    }
}

