/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.UUID;
import java.util.regex.Pattern;
import latmod.core.ILMGuiHandler;
import latmod.core.Notification;
import latmod.core.item.IItemLM;
import latmod.core.mod.LC;
import latmod.core.net.MessageLM;
import latmod.core.net.MessageNotifyPlayer;
import latmod.core.net.MessageOpenGui;
import latmod.core.tile.IGuiTile;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import latmod.core.util.Vertex;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LatCoreMC {
    public static final String MC_VERSION = "1.7.10";
    public static final String DEV_VERSION = "@VERSION@";
    public static final Logger logger = LogManager.getLogger((String)"LatCoreMC");
    public static final EventBus EVENT_BUS = new EventBus();
    public static final int TOP = 1;
    public static final int BOTTOM = 0;
    public static final int FRONT = 3;
    public static final boolean isDevEnv = "1.6.9".equals("@VERSION@");
    public static final String FORMATTING = "\u00a7";
    public static final Pattern textFormattingPattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static File latmodFolder = null;
    private static final FastMap<String, ILMGuiHandler> guiHandlers = new FastMap();
    @SideOnly(value=Side.CLIENT)
    public static IIcon blockNullIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon unknownItemIcon;

    public static ILMGuiHandler getLMGuiHandler(String id) {
        return guiHandlers.get(id);
    }

    public static void addLMGuiHandler(String id, ILMGuiHandler i) {
        guiHandlers.put(id, i);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addEntityRenderer(Class<? extends Entity> c, Render r) {
        RenderingRegistry.registerEntityRenderingHandler(c, (Render)r);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addTileRenderer(Class<? extends TileEntity> c, TileEntitySpecialRenderer r) {
        ClientRegistry.bindTileEntitySpecialRenderer(c, (TileEntitySpecialRenderer)r);
    }

    @SideOnly(value=Side.CLIENT)
    public static final int getNewArmorID(String s) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)s);
    }

    @SideOnly(value=Side.CLIENT)
    public static final int getNewBlockRenderID() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addBlockRenderer(int i, ISimpleBlockRenderingHandler r) {
        RenderingRegistry.registerBlockHandler((int)i, (ISimpleBlockRenderingHandler)r);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addItemRenderer(Item item, IItemRenderer i) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)i);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addItemRenderer(Block block, IItemRenderer i) {
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)i);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnPart(EntityFX e) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(e);
    }

    @SideOnly(value=Side.CLIENT)
    public static KeyBinding addKeyBinding(String name, int key, String cat) {
        KeyBinding k = new KeyBinding(name, key, cat);
        ClientRegistry.registerKeyBinding((KeyBinding)k);
        return k;
    }

    public static final Configuration loadConfig(FMLPreInitializationEvent e, String s) {
        return new Configuration(new File(e.getModConfigurationDirectory(), s));
    }

    public static final void printChat(ICommandSender ep, Object o, boolean broadcast) {
        if (ep == null && isDevEnv) {
            ep = LC.proxy.getClientPlayer();
        }
        if (ep != null) {
            ChatComponentText msg;
            Object object = msg = o != null && o instanceof IChatComponent ? (IChatComponent)o : new ChatComponentText("" + o);
            if (broadcast && ep instanceof MinecraftServer) {
                ((MinecraftServer)ep).func_71203_ab().func_148539_a((IChatComponent)msg);
            } else {
                ep.func_145747_a((IChatComponent)msg);
            }
        } else {
            logger.info(o);
        }
    }

    public static final void printChat(ICommandSender ep, Object o) {
        LatCoreMC.printChat(ep, o, false);
    }

    public static final void addItem(IItemLM i) {
        LatCoreMC.addItem((Item)i, i.getItemID());
    }

    public static final void addItem(Item i, String name) {
        GameRegistry.registerItem((Item)i, (String)name);
    }

    public static final void addBlock(Block b, Class<? extends ItemBlock> c, String name) {
        GameRegistry.registerBlock((Block)b, c, (String)name);
    }

    public static final void addBlock(Block b, String name) {
        LatCoreMC.addBlock(b, ItemBlock.class, name);
    }

    public static final void addTileEntity(Class<? extends TileEntity> c, String s, String ... alt) {
        if (alt == null || alt.length == 0) {
            GameRegistry.registerTileEntity(c, (String)s);
        } else {
            GameRegistry.registerTileEntityWithAlternatives(c, (String)s, (String[])alt);
        }
    }

    public static final void addEntity(Class<? extends Entity> c, String s, int id, Object mod) {
        EntityRegistry.registerModEntity(c, (String)s, (int)id, (Object)mod, (int)50, (int)1, (boolean)true);
    }

    public static final int getNewEntityID() {
        return EntityRegistry.findGlobalUniqueEntityId();
    }

    public static void addWorldGenerator(IWorldGenerator i, int w) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)i, (int)w);
    }

    public static void addEventHandler(Object o, boolean forge, boolean cpw, boolean lm) {
        if (forge) {
            MinecraftForge.EVENT_BUS.register(o);
        }
        if (cpw) {
            FMLCommonHandler.instance().bus().register(o);
        }
        if (lm) {
            EVENT_BUS.register(o);
        }
    }

    public static Fluid addFluid(Fluid f) {
        Fluid f1 = FluidRegistry.getFluid((String)f.getName());
        if (f1 != null) {
            return f1;
        }
        FluidRegistry.registerFluid((Fluid)f);
        return f;
    }

    public static boolean isServer() {
        return LatCoreMC.getEffectiveSide().isServer();
    }

    public static Side getEffectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static String getPath(ResourceLocation res) {
        return "/assets/" + res.func_110624_b() + "/" + res.func_110623_a();
    }

    public static void teleportEntity(Entity e, int dim) {
        if (e.field_70170_p.field_72995_K || e.field_70128_L || e.field_71093_bK == dim) {
            return;
        }
        if (e instanceof EntityPlayerMP) {
            e.func_71027_c(dim);
            MinecraftServer.func_71276_C().func_71203_ab().func_72356_a((EntityPlayerMP)e, dim);
            return;
        }
        e.field_70170_p.field_72984_F.func_76320_a("changeDimension");
        MinecraftServer ms = MinecraftServer.func_71276_C();
        int dim0 = e.field_71093_bK;
        WorldServer ws0 = ms.func_71218_a(dim0);
        WorldServer ws1 = ms.func_71218_a(dim);
        e.field_71093_bK = dim;
        e.field_70170_p.func_72900_e(e);
        e.field_70128_L = false;
        e.field_70170_p.field_72984_F.func_76320_a("reposition");
        ms.func_71203_ab().func_82448_a(e, dim0, ws0, ws1);
        e.field_70170_p.field_72984_F.func_76318_c("reloading");
        Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)e), (World)ws1);
        if (entity != null) {
            entity.func_82141_a(e, true);
            ws1.func_72838_d(entity);
        }
        e.field_70128_L = true;
        e.field_70170_p.field_72984_F.func_76319_b();
        ws0.func_82742_i();
        ws1.func_82742_i();
        e.field_70170_p.field_72984_F.func_76319_b();
    }

    public static void teleportPlayer(EntityPlayerMP ep, double x, double y, double z, int dim) {
        if (ep.field_71093_bK != dim) {
            LatCoreMC.teleportEntity((Entity)ep, dim);
        }
        ep.field_71135_a.func_147364_a(x, y, z, ep.field_70177_z, ep.field_70125_A);
    }

    public static boolean isWrench(ItemStack is) {
        return is != null && is.func_77973_b() != null && is.func_77973_b().getHarvestLevel(is, "wrench") != -1;
    }

    public static boolean hasOnlinePlayers() {
        return !MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.isEmpty();
    }

    public static FastMap<UUID, EntityPlayerMP> getAllOnlinePlayers() {
        FastMap<UUID, EntityPlayerMP> m = new FastMap<UUID, EntityPlayerMP>();
        for (int i = 0; i < MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size(); ++i) {
            EntityPlayerMP ep = (EntityPlayerMP)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.get(i);
            m.put(ep.func_110124_au(), ep);
        }
        return m;
    }

    public static Vertex getSpawnPoint(World w) {
        ChunkCoordinates c = w.func_72861_E();
        return new Vertex((double)c.field_71574_a + 0.5, (double)c.field_71572_b + 0.5, (double)c.field_71573_c + 0.5);
    }

    public static boolean remap(FMLMissingMappingsEvent.MissingMapping m, String id, Item i) {
        if (m.type == GameRegistry.Type.ITEM && id.equals(m.name)) {
            m.remap(i);
            return true;
        }
        return false;
    }

    public static boolean remap(FMLMissingMappingsEvent.MissingMapping m, String id, Block b) {
        if (id.equals(m.name)) {
            if (m.type == GameRegistry.Type.BLOCK) {
                m.remap(b);
            } else if (m.type == GameRegistry.Type.ITEM) {
                m.remap(Item.func_150898_a((Block)b));
            }
            return true;
        }
        return false;
    }

    public static boolean isModInstalled(String s) {
        return Loader.isModLoaded((String)s);
    }

    public static FluidStack getFluid(ItemStack is) {
        FluidStack fs;
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        if (is.func_77973_b() instanceof IFluidContainerItem && (fs = ((IFluidContainerItem)is.func_77973_b()).getFluid(is)) != null) {
            return fs;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
    }

    public static boolean isBucket(ItemStack is) {
        return FluidContainerRegistry.isBucket((ItemStack)is);
    }

    public static String removeFormatting(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return "";
        }
        return textFormattingPattern.matcher(s).replaceAll("");
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static Exception executeCommand(ICommandSender ics, String s) {
        try {
            LatCoreMC.getServer().func_71187_D().func_71556_a(ics, s);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public static Exception executeCommand(ICommandSender ics, String cmd, String[] args) {
        return LatCoreMC.executeCommand(ics, cmd + " " + LatCore.unsplit(args, " "));
    }

    public static void notifyPlayer(EntityPlayerMP ep, Notification n) {
        if (ep != null) {
            MessageLM.NET.sendTo((IMessage)new MessageNotifyPlayer(n), ep);
        } else {
            MessageLM.NET.sendToAll((IMessage)new MessageNotifyPlayer(n));
        }
    }

    public static Object invokeStatic(String className, String methodName) throws Exception {
        Class<?> c = Class.forName(className);
        return c.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
    }

    public static void openGui(EntityPlayer ep, String id, NBTTagCompound data) {
        if (ep == null || ep instanceof FakePlayer) {
            return;
        }
        ILMGuiHandler h = LatCoreMC.getLMGuiHandler(id);
        if (h == null) {
            return;
        }
        if (ep instanceof EntityPlayerMP) {
            Container c = h.getContainer(ep, id, data);
            if (c == null) {
                return;
            }
            EntityPlayerMP epM = (EntityPlayerMP)ep;
            epM.func_71117_bO();
            epM.func_71128_l();
            epM.field_71070_bA = c;
            epM.field_71070_bA.field_75152_c = epM.field_71139_cq;
            epM.field_71070_bA.func_75132_a((ICrafting)epM);
            MessageLM.NET.sendTo((IMessage)new MessageOpenGui(id, data, epM.field_71139_cq), epM);
        } else if (LatCoreMC.getEffectiveSide() == Side.CLIENT) {
            LC.proxy.openClientGui(ep, id, data);
        }
    }

    public static void openGui(EntityPlayer ep, IGuiTile i, NBTTagCompound data) {
        TileEntity te = i.getTile();
        if (data == null) {
            data = new NBTTagCompound();
        }
        data.func_74783_a("XYZ", new int[]{te.field_145851_c, te.field_145848_d, te.field_145849_e});
        LatCoreMC.openGui(ep, "lmc.tile", data);
    }
}

