/*
 * Decompiled with CFR 0.152.
 */
package latmod.core;

import java.util.Arrays;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InvUtils {
    public static ItemStack singleCopy(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        ItemStack is1 = is.func_77946_l();
        is1.field_77994_a = 1;
        return is1;
    }

    public static IInventory getInvAt(World w, double x, double y, double z, boolean entities) {
        if (entities) {
            return TileEntityHopper.func_145893_b((World)w, (double)x, (double)y, (double)z);
        }
        TileEntity te = w.func_147438_o((int)x, (int)y, (int)z);
        return te != null && te instanceof IInventory ? (IInventory)te : null;
    }

    public static IInventory getInvAt(TileEntity te, ForgeDirection side, boolean entities) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return InvUtils.getInvAt(te.func_145831_w(), (double)(te.field_145851_c + side.offsetX) + 0.5, (double)(te.field_145848_d + side.offsetY) + 0.5, (double)(te.field_145849_e + side.offsetZ) + 0.5, entities);
    }

    public static boolean itemsEquals(ItemStack is1, ItemStack is2, boolean size, boolean nbt) {
        return !(is1.func_77973_b() != is2.func_77973_b() || is1.func_77960_j() != is2.func_77960_j() || nbt && !ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2) || size && is1.field_77994_a != is2.field_77994_a);
    }

    public static int[] getAllSlots(IInventory inv, int side) {
        if (side != -1 && inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_94128_d(side);
        }
        int[] ai = new int[inv.func_70302_i_()];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = i;
        }
        return ai;
    }

    public static int getFirstIndexWhereFits(IInventory inv, ItemStack filter, int side) {
        if (inv == null) {
            return -1;
        }
        if (filter != null) {
            int[] slots = InvUtils.getAllSlots(inv, side);
            for (int i = 0; i < slots.length; ++i) {
                ItemStack is1 = inv.func_70301_a(slots[i]);
                if (is1 == null || is1.field_77994_a >= is1.func_77976_d()) continue;
                if (filter == null) {
                    return i;
                }
                if (!InvUtils.itemsEquals(filter, is1, false, true) || is1.field_77994_a >= is1.func_77976_d()) continue;
                return i;
            }
        }
        return InvUtils.getFirstEmptyIndex(inv, side);
    }

    public static int getFirstIndexWithItem(IInventory inv, ItemStack filter, int side, boolean size, boolean nbt) {
        if (inv == null || filter == null) {
            return -1;
        }
        int[] slots = InvUtils.getAllSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 == null || !InvUtils.itemsEquals(filter, is1, size, nbt)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstFilledIndex(IInventory inv, ItemStack filter, int side) {
        if (inv == null) {
            return -1;
        }
        int[] slots = InvUtils.getAllSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 == null) continue;
            if (filter == null) {
                return i;
            }
            if (!InvUtils.itemsEquals(filter, is1, false, true)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstEmptyIndex(IInventory inv, int side) {
        if (inv == null) {
            return -1;
        }
        int[] slots = InvUtils.getAllSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 != null && is1.field_77994_a > 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean reduceItemInInv(IInventory inv, int i) {
        if (inv == null || i == -1 || i >= inv.func_70302_i_()) {
            return false;
        }
        ItemStack is = inv.func_70301_a(i);
        if (is != null) {
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                is = null;
            }
            inv.func_70299_a(i, is);
            inv.func_70296_d();
        }
        return false;
    }

    public static void reduceItemInInv(IInventory inv, int[] slots, ItemStack is, int size) {
        for (int i = 0; i < slots.length; ++i) {
            ItemStack is1 = inv.func_70301_a(slots[i]);
            if (is1 == null || !InvUtils.itemsEquals(is1, is, false, true)) continue;
            int s = Math.min(is1.field_77994_a, size);
            size -= s;
            is1.field_77994_a -= s;
            if (is1.field_77994_a <= 0) {
                inv.func_70299_a(i, null);
            }
            if (size > 0) continue;
            return;
        }
        inv.func_70296_d();
    }

    public static boolean addSingleItemToInv(ItemStack is, IInventory inv, int[] slots, int side, boolean doAdd) {
        ItemStack is1;
        int i;
        if (is == null) {
            return false;
        }
        ItemStack single = InvUtils.singleCopy(is);
        for (i = 0; i < slots.length; ++i) {
            is1 = inv.func_70301_a(slots[i]);
            if (is1 == null || is1.field_77994_a <= 0 || !InvUtils.itemsEquals(is, is1, false, true) || is1.field_77994_a + 1 > is1.func_77976_d() || side != -1 && !InvUtils.canInsert(inv, single, i, side)) continue;
            if (doAdd) {
                ++is1.field_77994_a;
                inv.func_70299_a(slots[i], is1);
                inv.func_70296_d();
            }
            return true;
        }
        for (i = 0; i < slots.length; ++i) {
            is1 = inv.func_70301_a(slots[i]);
            if (is1 != null && is1.field_77994_a != 0 || side != -1 && !InvUtils.canInsert(inv, single, i, side)) continue;
            if (doAdd) {
                inv.func_70299_a(slots[i], single);
                inv.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public static boolean addSingleItemToInv(ItemStack is, IInventory inv, int side, boolean doAdd) {
        return InvUtils.addSingleItemToInv(is, inv, InvUtils.getAllSlots(inv, side), side, doAdd);
    }

    public static NBTTagCompound removeTags(NBTTagCompound tag, String ... tags) {
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        for (int i = 0; i < tags.length; ++i) {
            tag.func_82580_o(tags[i]);
        }
        if (tag.func_82582_d()) {
            tag = null;
        }
        return tag;
    }

    public static ItemStack removeTags(ItemStack is, String ... tags) {
        if (is == null) {
            return null;
        }
        is.func_77982_d(InvUtils.removeTags(is.field_77990_d, tags));
        return is;
    }

    public static void writeItemsToNBT(ItemStack[] stacks, NBTTagCompound tag, String s) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74777_a("Slot", (short)i);
            stacks[i].func_77955_b(tag1);
            list.func_74742_a((NBTBase)tag1);
        }
        if (list.func_74745_c() > 0) {
            tag.func_74782_a(s, (NBTBase)list);
        }
    }

    public static void readItemsFromNBT(ItemStack[] stacks, NBTTagCompound tag, String s) {
        Arrays.fill(stacks, null);
        if (tag.func_74764_b(s)) {
            NBTTagList list = tag.func_150295_c(s, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag1 = list.func_150305_b(i);
                short slot = tag1.func_74765_d("Slot");
                stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)tag1);
                if (i >= stacks.length) break;
            }
        }
    }

    public static ItemStack decrStackSize(IInventory inv, int slot, int amt) {
        ItemStack stack = inv.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                inv.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    inv.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public static ItemStack getStackInSlotOnClosing(IInventory inv, int i) {
        ItemStack is = inv.func_70301_a(i);
        if (is != null) {
            inv.func_70299_a(i, null);
            return is;
        }
        return null;
    }

    public static void dropItem(World w, double x, double y, double z, double mx, double my, double mz, ItemStack is, int delay) {
        if (w == null || is == null || is.field_77994_a == 0) {
            return;
        }
        EntityItem ei = new EntityItem(w, x, y, z, is.func_77946_l());
        ei.field_70159_w = mx;
        ei.field_70181_x = my;
        ei.field_70179_y = mz;
        ei.field_145804_b = delay;
        w.func_72838_d((Entity)ei);
    }

    public static void dropItem(World w, double x, double y, double z, ItemStack is, int delay) {
        InvUtils.dropItem(w, x, y, z, w.field_73012_v.nextGaussian() * (double)0.07f, w.field_73012_v.nextFloat() * 0.05f, w.field_73012_v.nextGaussian() * (double)0.07f, is, delay);
    }

    public static void dropItem(Entity e, ItemStack item) {
        if (e == null || item == null || item.field_77994_a <= 0) {
            return;
        }
        InvUtils.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, item, 0);
    }

    public static void giveItem(EntityPlayer ep, ItemStack item) {
        InvUtils.giveItem(ep, item, -1);
    }

    public static void giveItem(EntityPlayer ep, ItemStack item, int optionalSlot) {
        if (ep == null || ep.field_71071_by == null || item == null || item.field_77994_a <= 0) {
            return;
        }
        ItemStack is = item.func_77946_l();
        boolean changed = false;
        int size = is.field_77994_a;
        for (int i = 0; i < size; ++i) {
            if (!InvUtils.addSingleItemToInv(is, (IInventory)ep.field_71071_by, InvUtils.getPlayerSlots(ep), -1, true)) continue;
            --is.field_77994_a;
            changed = true;
        }
        if (changed) {
            ep.field_71071_by.func_70296_d();
            if (ep.field_71070_bA != null) {
                ep.field_71070_bA.func_75142_b();
            }
        }
        if (is.field_77994_a > 0) {
            InvUtils.dropItem((Entity)ep, is);
        }
    }

    public static void dropAllItems(World w, double x, double y, double z, ItemStack[] items) {
        if (w.field_72995_K || items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].field_77994_a <= 0) continue;
            InvUtils.dropItem(w, x, y, z, items[i], 10);
        }
    }

    public static boolean canStack(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return false;
        }
        return is1.field_77994_a + is2.field_77994_a <= is1.func_77976_d() && is1.field_77994_a + is2.field_77994_a <= is2.func_77976_d();
    }

    public static ItemStack[] getAllItems(IInventory inv, int side) {
        if (inv == null) {
            return null;
        }
        int[] slots = InvUtils.getAllSlots(inv, side);
        ItemStack[] ai = new ItemStack[slots.length];
        if (ai.length == 0) {
            return ai;
        }
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = inv.func_70301_a(slots[i]);
        }
        return ai;
    }

    public static boolean canExtract(IInventory inv, ItemStack is, int slot, int side) {
        return !(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_102008_b(slot, is, side);
    }

    public static boolean canInsert(IInventory inv, ItemStack is, int slot, int side) {
        return !(inv instanceof ISidedInventory) || ((ISidedInventory)inv).func_102007_a(slot, is, side);
    }

    public static FastMap<Integer, ItemStack> getAllItemsMap(IInventory inv, int side) {
        ItemStack[] is = InvUtils.getAllItems(inv, side);
        if (is == null) {
            return null;
        }
        FastMap<Integer, ItemStack> map = new FastMap<Integer, ItemStack>();
        for (int i = 0; i < is.length; ++i) {
            if (is[i] == null) continue;
            map.put(i, is[i]);
        }
        return map;
    }

    public static int[] getPlayerSlots(EntityPlayer ep) {
        int[] ai = new int[ep.field_71071_by.field_70462_a.length];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = i;
        }
        return ai;
    }

    public static ItemStack reduceItem(ItemStack is) {
        if (is.field_77994_a == 1) {
            if (is.func_77973_b().hasContainerItem(is)) {
                return is.func_77973_b().getContainerItem(is);
            }
            return null;
        }
        is.func_77979_a(1);
        return is;
    }

    public static ItemStack loadStack(NBTTagCompound tag, String s) {
        if (tag.func_74764_b(s)) {
            return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(s));
        }
        return null;
    }

    public static void saveStack(NBTTagCompound tag, String s, ItemStack is) {
        if (is != null) {
            NBTTagCompound tag1 = new NBTTagCompound();
            is.func_77955_b(tag1);
            tag.func_74782_a(s, (NBTBase)tag1);
        }
    }

    public static Item getItemFromRegName(String s) {
        return (Item)Item.field_150901_e.func_82594_a(s);
    }

    public static String getRegName(Item item) {
        return Item.field_150901_e.func_148750_c((Object)item);
    }

    public static String getRegName(Block block) {
        return Block.field_149771_c.func_148750_c((Object)block);
    }

    public static String getRegName(ItemStack is) {
        return is != null && is.func_77973_b() != null ? InvUtils.getRegName(is.func_77973_b()) : null;
    }

    public static ItemStack parseItem(String s) {
        try {
            String regex = "@";
            if (s.contains(";")) {
                regex = ";";
            } else if (s.contains(" x ")) {
                regex = " x ";
            }
            String[] s1 = LatCore.split(s, regex);
            if (s1.length <= 0 || s1.length > 3) {
                return null;
            }
            Item item = InvUtils.getItemFromRegName(s1[0]);
            if (item == null) {
                return null;
            }
            int dmg = 0;
            int size = 1;
            if (s1.length == 2) {
                dmg = Integer.parseInt(s1[1]);
            }
            if (s1.length == 3) {
                size = Integer.parseInt(s1[1]);
                dmg = Integer.parseInt(s1[2]);
            }
            return new ItemStack(item, size, dmg);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

