/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.core.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.lomeli.lomlib.core.network.AbstractPacket;
import net.lomeli.lomlib.core.network.SidedPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@SidedPacket(acceptedClientSide=false)
public class PacketSaveTablet
extends AbstractPacket {
    private NBTTagCompound tag;
    private UUID playerUUID;
    private int dim;

    public PacketSaveTablet() {
    }

    public PacketSaveTablet(NBTTagCompound tag, UUID playerUUID, int dim) {
        this.tag = tag;
        this.playerUUID = playerUUID;
        this.dim = dim;
    }

    public void encodeInto(ByteBuf buffer) {
        buffer.writeLong(this.playerUUID.getMostSignificantBits());
        buffer.writeLong(this.playerUUID.getLeastSignificantBits());
        buffer.writeInt(this.dim);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.tag);
    }

    public void decodeInto(ByteBuf buffer) {
        long most = buffer.readLong();
        long least = buffer.readLong();
        this.playerUUID = new UUID(most, least);
        this.dim = buffer.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public void handlePacket(Side side) {
        ItemStack stack;
        EntityPlayer player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim).func_152378_a(this.playerUUID);
        if (player != null && (stack = player.func_71045_bC()) != null && stack.func_77973_b() != null) {
            stack.field_77990_d = this.tag;
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
        }
    }
}

