/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModTankDisplay
extends SocketModule {
    public ModTankDisplay(int id) {
        super(id, "eng_toolbox:tankDisplay", "eng_toolbox:tankOverlay");
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    @Override
    public String getLocalizedName() {
        return "Tank Interface";
    }

    public void getToolTip(List l) {
        l.add("Displays an internal tank");
        l.add("Allows players to fill and empty fluid");
        l.add("containersby right clicking");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to display");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ggg", "slr", " b ", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('s'), Items.field_151114_aO, Character.valueOf('l'), "dyeBlue", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public void onTankChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.tank) {
            ts.sendClientTankSlot(index);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getTankToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return config.tank;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon[] getAdditionalOverlays(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return new IIcon[]{emasher.blocks.Blocks.socket().textures[this.moduleID][1]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean flipBottomOverlay() {
        return true;
    }

    @Override
    public void onSideActivated(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        if (config.tank != -1 && is != null) {
            FluidStack inContainer = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
            if (inContainer != null) {
                int amnt = ts.fillInternal(config.tank, inContainer, false);
                if (amnt == inContainer.amount) {
                    ts.fillInternal(config.tank, inContainer, true);
                    if (FluidContainerRegistry.isBucket((ItemStack)is)) {
                        is.func_77973_b().func_77642_a(Items.field_151133_ar);
                        is.func_77964_b(0);
                        is.field_77994_a = 1;
                        is.func_77982_d(null);
                    } else {
                        --is.field_77994_a;
                    }
                }
            } else {
                ItemStack filled;
                FluidStack liquid;
                FluidStack available = ts.getFluidInTank(config.tank);
                if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)is)))) != null) {
                    if (is.field_77994_a > 1) {
                        if (player.field_71071_by.func_70441_a(filled)) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ModTankDisplay.consumeItem(is));
                        }
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ModTankDisplay.consumeItem(is));
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    }
                    ts.drainInternal(config.tank, liquid.amount, true);
                }
            }
        }
    }

    @Override
    public void indicatorUpdated(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.tank != -1) {
            ts.sendClientTankSlot(config.tank);
        }
    }
}

