/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ModFreezer
extends SocketModule {
    private static final FluidStack waterStack = new FluidStack(FluidRegistry.WATER, 1000);

    public ModFreezer(int id) {
        super(id, "eng_toolbox:freezer");
    }

    @Override
    public String getLocalizedName() {
        return "Freezer";
    }

    public void getToolTip(List l) {
        l.add("Turns water from an internal");
        l.add("tank into ice blocks");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Input tank");
        l.add(Config.PREF_GREEN() + "Output inventory");
        l.add(Config.PREF_AQUA() + "Requires 160 RF/operation");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return "eng_toolbox:inner_freezer";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_freezer"};
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"wpw", " b ", Character.valueOf('w'), Items.field_151133_ar, Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), emasher.items.Items.blankSide()});
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        ++config.meta;
        if (config.meta >= 80) {
            FluidStack taken;
            config.meta = 0;
            if (ts.getEnergyStored() > 160 && config.tank >= 0 && config.tank < 3 && (taken = ts.drainInternal(config.tank, 1000, false)) != null && taken.amount >= 1000 && taken.isFluidEqual(waterStack) && config.inventory >= 0 && config.inventory < 3 && ts.addItemInternal(new ItemStack(Blocks.field_150432_aD), false, config.inventory) == 1) {
                ts.drainInternal(config.tank, 1000, true);
                ts.addItemInternal(new ItemStack(Blocks.field_150432_aD), true, config.inventory);
                ts.useEnergy(160, false);
            }
        }
    }
}

