/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;

public class ModDFBlade
extends SocketModule {
    public ModDFBlade(int id) {
        super(id, "eng_toolbox:DFBlade_IN", "eng_toolbox:DFBlade");
    }

    @Override
    public String getLocalizedName() {
        return "Deadly Flashing Blade";
    }

    public void getToolTip(List l) {
        l.add("Hurts entities within one block");
        l.add("on a sustained internal redstone signal");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{" s ", "ipi", " b ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('s'), Items.field_151048_u, Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('b'), emasher.items.Items.blankSide()});
    }

    @Override
    public int getCurrentTexture(SideConfig config) {
        if (config.tank < 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.tank == 0 && ts.getEnergyStored() >= 10) {
            for (int i = 0; i < 3; ++i) {
                if (config.rsControl[i] && ts.getRSControl(i)) {
                    config.tank = 1;
                    ts.sendClientSideState(side.ordinal());
                    break;
                }
                if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
                config.tank = 1;
                ts.sendClientSideState(side.ordinal());
                break;
            }
        }
        if (config.tank == 1) {
            ++config.meta;
            if (config.meta == 20) {
                config.meta = 0;
                if (ts.getEnergyStored() < 10) {
                    config.tank = 0;
                    ts.sendClientSideState(side.ordinal());
                    return;
                }
                ts.useEnergy(10, false);
                double x = ts.field_145851_c + side.offsetX;
                double y = ts.field_145848_d + side.offsetY;
                double z = ts.field_145849_e + side.offsetZ;
                List l = ts.func_145831_w().func_72839_b((Entity)null, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)));
                for (Object o : l) {
                    if (!(o instanceof EntityLiving)) continue;
                    EntityLiving live = (EntityLiving)o;
                    live.func_70097_a(DamageSource.field_76377_j, 10.0f);
                }
            }
        }
    }

    @Override
    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (on && config.rsControl[index] && ts.getEnergyStored() >= 10) {
            config.tank = 1;
        } else if (!on && config.rsControl[index]) {
            boolean turnOff = true;
            for (int i = 0; i < 3; ++i) {
                if (config.rsControl[i] && ts.getRSControl(i)) {
                    turnOff = false;
                }
                if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
                turnOff = false;
            }
            if (turnOff) {
                config.tank = 0;
                config.meta = 0;
            }
        }
        ts.sendClientSideState(side.ordinal());
    }

    @Override
    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (on && config.rsLatch[index] && ts.getEnergyStored() >= 10) {
            config.tank = 1;
        } else if (!on && config.rsLatch[index]) {
            boolean turnOff = true;
            for (int i = 0; i < 3; ++i) {
                if (config.rsControl[i] && ts.getRSControl(i)) {
                    turnOff = false;
                }
                if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
                turnOff = false;
            }
            if (turnOff) {
                config.tank = 0;
                config.meta = 0;
            }
        }
        ts.sendClientSideState(side.ordinal());
    }
}

