/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.item;

import com.whammich.sstow.utils.Config;
import com.whammich.sstow.utils.EntityMapper;
import com.whammich.sstow.utils.Register;
import com.whammich.sstow.utils.TierHandler;
import com.whammich.sstow.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemShardSoul
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon unbound;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemShardSoul() {
        this.func_77655_b("soul_shard");
        this.func_77637_a(Register.CREATIVE_TAB);
        this.func_77625_d(64);
        this.func_77656_e(0);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        Utils.checkAndFixShard(stack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || Utils.hasMaxedKills(stack) || !Config.ALLOW_SPAWNER_ABSORB) {
            return stack;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return stack;
        }
        TileEntity tile = world.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (tile instanceof TileEntityMobSpawner) {
            String name = ((TileEntityMobSpawner)tile).func_145881_a().func_98276_e();
            EntityLiving ent = EntityMapper.getNewEntityInstance(world, name);
            if (ent == null) {
                return stack;
            }
            ent = ((TileEntityMobSpawner)tile).func_145881_a().func_98265_a((Entity)ent);
            if (ent instanceof EntitySkeleton && ((EntitySkeleton)ent).func_82202_m() == 1) {
                name = "Wither Skeleton";
            }
            if (!EntityMapper.isEntityValid(name)) {
                return stack;
            }
            if (Utils.isShardBound(stack)) {
                if (Utils.getShardBoundEnt(stack).equals(name)) {
                    Utils.increaseShardKillCount(stack, (short)Config.SPAWNER_ABSORB_BONUS);
                    Utils.checkForAchievements(player, stack);
                    world.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
                }
            } else if (EntityMapper.isEntityValid(name)) {
                if (stack.field_77994_a > 1) {
                    --stack.field_77994_a;
                    ItemStack newStack = new ItemStack(Register.SOUL_SHARD, 1);
                    Utils.setShardBoundEnt(newStack, name);
                    Utils.writeEntityHeldItem(newStack, ent);
                    Utils.increaseShardKillCount(newStack, (short)Config.SPAWNER_ABSORB_BONUS);
                    boolean emptySpot = false;
                    for (int counter = 0; !emptySpot && counter < 36; ++counter) {
                        ItemStack inventoryStack = player.field_71071_by.func_70301_a(counter);
                        if (inventoryStack != null) continue;
                        player.field_71071_by.func_70441_a(newStack);
                        emptySpot = true;
                    }
                    if (!emptySpot) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, newStack));
                    }
                } else {
                    Utils.setShardBoundEnt(stack, name);
                    Utils.writeEntityHeldItem(stack, ent);
                    Utils.increaseShardKillCount(stack, (short)Config.SPAWNER_ABSORB_BONUS);
                }
                world.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, true);
            }
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        if (Utils.isShardBound(stack)) {
            return "item.sstow.shard";
        }
        return "item.sstow.shard_unbound";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return Utils.hasMaxedKills(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i <= 5; ++i) {
            ItemStack stack = new ItemStack(item, 1);
            Utils.setShardKillCount(stack, TierHandler.getMinKills(i));
            Utils.setShardTier(stack, (byte)i);
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (Utils.isShardBound(stack)) {
            list.add("Bound to: " + Utils.getEntityNameTransltated(Utils.getShardBoundEnt(stack)));
        }
        if (Utils.getShardKillCount(stack) >= 0) {
            list.add("Kills: " + Utils.getShardKillCount(stack));
        }
        list.add("Tier: " + Utils.getShardTier(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (!Utils.isShardBound(stack)) {
            return this.unbound;
        }
        return this.icons[Utils.getShardTier(stack)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.unbound = register.func_94245_a("sstow:unbound");
        this.icons = new IIcon[6];
        for (int i = 0; i <= 5; ++i) {
            this.icons[i] = register.func_94245_a("sstow:tier" + i);
        }
    }
}

