/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageIO;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldDataSpaceRaces;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenTransmitter;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityHydrogenPipe;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class TickHandlerServer {
    private static Map<Integer, CopyOnWriteArrayList<ScheduledBlockChange>> scheduledBlockChanges = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<ScheduledBlockChange>>();
    private static Map<Integer, CopyOnWriteArrayList<BlockVec3>> scheduledTorchUpdates = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<BlockVec3>>();
    private static Map<Integer, List<BlockVec3>> edgeChecks = new HashMap<Integer, List<BlockVec3>>();
    private static LinkedList<EnergyNetwork> networkTicks = new LinkedList();
    public static Map<Integer, Map<Long, List<Footprint>>> serverFootprintMap = new HashMap<Integer, Map<Long, List<Footprint>>>();
    public static List<NetworkRegistry.TargetPoint> footprintRefreshList = Lists.newArrayList();
    public static WorldDataSpaceRaces spaceRaceData = null;
    public static ArrayList<EntityPlayerMP> playersRequestingMapData = Lists.newArrayList();
    private static long tickCount;
    public static LinkedList<TileEntityOxygenTransmitter> oxygenTransmitterUpdates;
    public static LinkedList<TileEntityHydrogenPipe> hydrogenTransmitterUpdates;
    public static LinkedList<TileBaseConductor> energyTransmitterUpdates;
    private final int MAX_BLOCKS_PER_TICK = 50000;

    public static void restart() {
        scheduledBlockChanges.clear();
        scheduledTorchUpdates.clear();
        edgeChecks.clear();
        networkTicks.clear();
        serverFootprintMap.clear();
        oxygenTransmitterUpdates.clear();
        hydrogenTransmitterUpdates.clear();
        energyTransmitterUpdates.clear();
        playersRequestingMapData.clear();
        networkTicks.clear();
        for (SpaceRace race : SpaceRaceManager.getSpaceRaces()) {
            SpaceRaceManager.removeSpaceRace(race);
        }
        spaceRaceData = null;
        tickCount = 0L;
        MapUtil.calculatingMap.set(false);
        MapUtil.doneOverworldTexture = false;
    }

    public static void addFootprint(long chunkKey, Footprint print, int dimID) {
        List<Footprint> footprints;
        Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(dimID);
        if (footprintMap == null) {
            footprintMap = new HashMap<Long, List<Footprint>>();
            footprints = new ArrayList<Footprint>();
        } else {
            footprints = footprintMap.get(chunkKey);
            if (footprints == null) {
                footprints = new ArrayList<Footprint>();
            }
        }
        footprints.add(print);
        footprintMap.put(chunkKey, footprints);
        serverFootprintMap.put(dimID, footprintMap);
    }

    public static void scheduleNewBlockChange(int dimID, ScheduledBlockChange change) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.add(change);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewBlockChange(int dimID, List<ScheduledBlockChange> changeAdd) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.addAll(changeAdd);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewTorchUpdate(int dimID, List<BlockVec3> torches) {
        CopyOnWriteArrayList<BlockVec3> updateList = scheduledTorchUpdates.get(dimID);
        if (updateList == null) {
            updateList = new CopyOnWriteArrayList();
        }
        updateList.addAll(torches);
        scheduledTorchUpdates.put(dimID, updateList);
    }

    public static void scheduleNewEdgeCheck(int dimID, BlockVec3 edgeBlock) {
        List<BlockVec3> updateList = edgeChecks.get(dimID);
        if (updateList == null) {
            updateList = new ArrayList<BlockVec3>();
        }
        updateList.add(edgeBlock);
        edgeChecks.put(dimID, updateList);
    }

    public static boolean scheduledForChange(int dimID, BlockVec3 test) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList != null) {
            for (ScheduledBlockChange change : changeList) {
                if (!test.equals(change.getChangePosition())) continue;
                return true;
            }
        }
        return false;
    }

    public static void scheduleNetworkTick(EnergyNetwork grid) {
        networkTicks.add(grid);
    }

    public static void removeNetworkTick(EnergyNetwork grid) {
        networkTicks.remove(grid);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if (MapUtil.calculatingMap.get()) {
                MapUtil.BiomeMapNextTick();
            } else if (!MapUtil.doneOverworldTexture) {
                MapUtil.makeOverworldTexture();
            }
            if (spaceRaceData == null) {
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
                spaceRaceData = (WorldDataSpaceRaces)world.field_72988_C.func_75742_a(WorldDataSpaceRaces.class, "GCSpaceRaceData");
                if (spaceRaceData == null) {
                    spaceRaceData = new WorldDataSpaceRaces("GCSpaceRaceData");
                    world.field_72988_C.func_75745_a("GCSpaceRaceData", (WorldSavedData)spaceRaceData);
                }
            }
            SpaceRaceManager.tick();
            if (tickCount % 100L == 0L) {
                WorldServer[] worlds = server.field_71305_c;
                for (int i = 0; i < worlds.length; ++i) {
                    Object world = worlds[i];
                    ChunkProviderServer chunkProviderServer = ((WorldServer)world).field_73059_b;
                    Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(((WorldServer)world).field_73011_w.field_76574_g);
                    if (footprintMap == null) continue;
                    boolean mapChanged = false;
                    if (chunkProviderServer != null) {
                        for (Chunk chunk : chunkProviderServer.field_73245_g) {
                            long chunkKey = ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
                            List<Footprint> footprints = footprintMap.get(chunkKey);
                            if (footprints == null) continue;
                            ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
                            for (int j = 0; j < footprints.size(); ++j) {
                                footprints.get((int)j).age = (short)(footprints.get((int)j).age + 100);
                                if (footprints.get((int)j).age < 3200) continue;
                                toRemove.add(footprints.get(j));
                            }
                            if (!toRemove.isEmpty()) {
                                footprints.removeAll(toRemove);
                            }
                            footprintMap.put(chunkKey, footprints);
                            mapChanged = true;
                            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_FOOTPRINT_LIST, new Object[]{chunkKey, footprints.toArray(new Footprint[footprints.size()])}), ((WorldServer)worlds[i]).field_73011_w.field_76574_g);
                        }
                    }
                    if (!mapChanged) continue;
                    serverFootprintMap.put(((WorldServer)world).field_73011_w.field_76574_g, footprintMap);
                }
            } else if (!footprintRefreshList.isEmpty()) {
                for (NetworkRegistry.TargetPoint targetPoint : footprintRefreshList) {
                    WorldServer[] worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
                    for (int i = 0; i < worlds.length; ++i) {
                        List<Footprint> footprints;
                        WorldServer world = worlds[i];
                        if (world.field_73011_w.field_76574_g != targetPoint.dimension) continue;
                        long chunkKey = ChunkCoordIntPair.func_77272_a((int)((int)targetPoint.x >> 4), (int)((int)targetPoint.z >> 4));
                        Map<Long, List<Footprint>> footprintMap = serverFootprintMap.get(world.field_73011_w.field_76574_g);
                        if (footprintMap == null || footprintMap.isEmpty() || (footprints = footprintMap.get(chunkKey)) == null) continue;
                        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_FOOTPRINT_LIST, new Object[]{chunkKey, footprints.toArray(new Footprint[footprints.size()])}), targetPoint);
                    }
                }
            }
            if (tickCount % 20L == 0L && !playersRequestingMapData.isEmpty()) {
                ArrayList<EntityPlayerMP> copy = new ArrayList<EntityPlayerMP>(playersRequestingMapData);
                for (EntityPlayerMP playerMP : copy) {
                    GCPlayerStats gCPlayerStats = GCPlayerStats.get(playerMP);
                    ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair((int)Math.floor(gCPlayerStats.coordsTeleportedFromX) >> 4, (int)Math.floor(gCPlayerStats.coordsTeleportedFromZ) >> 4);
                    BufferedImage image = new BufferedImage(400, 400, 1);
                    for (int x0 = -12; x0 <= 12; ++x0) {
                        for (int z0 = -12; z0 <= 12; ++z0) {
                            Chunk chunk = MinecraftServer.func_71276_C().func_71218_a(0).func_72964_e(chunkCoordIntPair.field_77276_a + x0, chunkCoordIntPair.field_77275_b + z0);
                            if (chunk == null) continue;
                            for (int z = 0; z < 16; ++z) {
                                for (int x = 0; x < 16; ++x) {
                                    int l4 = chunk.func_76611_b(x, z) + 1;
                                    Block block = Blocks.field_150350_a;
                                    int i5 = 0;
                                    if (l4 > 1) {
                                        while ((block = chunk.func_150810_a(x, --l4, z)).func_149728_f(i5 = chunk.func_76628_c(x, l4, z)) == MapColor.field_151660_b && l4 > 0) {
                                        }
                                    }
                                    int col = block.func_149728_f((int)i5).field_76291_p;
                                    image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                                }
                            }
                        }
                    }
                    try {
                        File outputFile;
                        File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
                        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
                            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
                        }
                        if ((outputFile = new File(baseFolder, "" + chunkCoordIntPair.field_77276_a + "_" + chunkCoordIntPair.field_77275_b + ".jpg")).exists() && (!outputFile.canWrite() || !outputFile.canRead())) continue;
                        ImageIO.write((RenderedImage)image, "jpg", outputFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                playersRequestingMapData.removeAll(copy);
            }
            if (++tickCount >= Long.MAX_VALUE) {
                tickCount = 0L;
            }
            ++EnergyNetwork.tickCount;
        } else if (event.phase == TickEvent.Phase.END) {
            LinkedList<Object> pass;
            int maxPasses = 10;
            while (!networkTicks.isEmpty()) {
                pass = new LinkedList<Object>();
                pass.addAll(networkTicks);
                networkTicks.clear();
                for (EnergyNetwork energyNetwork : pass) {
                    energyNetwork.tickEnd();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!oxygenTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(oxygenTransmitterUpdates);
                oxygenTransmitterUpdates.clear();
                for (TileEntityOxygenTransmitter tileEntityOxygenTransmitter : pass) {
                    if (tileEntityOxygenTransmitter.func_145837_r()) continue;
                    tileEntityOxygenTransmitter.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!hydrogenTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(hydrogenTransmitterUpdates);
                hydrogenTransmitterUpdates.clear();
                for (TileEntityHydrogenPipe tileEntityHydrogenPipe : pass) {
                    if (tileEntityHydrogenPipe.func_145837_r()) continue;
                    tileEntityHydrogenPipe.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
            maxPasses = 10;
            while (!energyTransmitterUpdates.isEmpty()) {
                pass = new LinkedList();
                pass.addAll(energyTransmitterUpdates);
                energyTransmitterUpdates.clear();
                for (TileBaseConductor tileBaseConductor : pass) {
                    if (tileBaseConductor.func_145837_r()) continue;
                    tileBaseConductor.refresh();
                }
                if (--maxPasses > 0) continue;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CopyOnWriteArrayList<BlockVec3> torchList;
            WorldServer world = (WorldServer)event.world;
            CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(world.field_73011_w.field_76574_g);
            if (changeList != null && !changeList.isEmpty()) {
                CopyOnWriteArrayList<ScheduledBlockChange> newList = new CopyOnWriteArrayList<ScheduledBlockChange>();
                int blockCount = 0;
                int blockCountMax = Math.max(this.MAX_BLOCKS_PER_TICK, changeList.size() / 4);
                for (ScheduledBlockChange change : changeList) {
                    BlockVec3 changePosition;
                    if (++blockCount > blockCountMax) {
                        newList.add(change);
                        continue;
                    }
                    if (change == null || (changePosition = change.getChangePosition()) == null || !world.func_147439_a(changePosition.x, changePosition.y, changePosition.z).isAir((IBlockAccess)world, changePosition.x, changePosition.y, changePosition.z)) continue;
                    world.func_147465_d(changePosition.x, changePosition.y, changePosition.z, change.getChangeID(), change.getChangeMeta(), 2);
                }
                changeList.clear();
                scheduledBlockChanges.remove(world.field_73011_w.field_76574_g);
                if (newList.size() > 0) {
                    scheduledBlockChanges.put(world.field_73011_w.field_76574_g, newList);
                }
            }
            if ((torchList = scheduledTorchUpdates.get(world.field_73011_w.field_76574_g)) != null && !torchList.isEmpty()) {
                for (BlockVec3 torch : torchList) {
                    Block b;
                    if (torch == null || !((b = world.func_147439_a(torch.x, torch.y, torch.z)) instanceof BlockUnlitTorch)) continue;
                    world.func_147454_a(torch.x, torch.y, torch.z, b, 2 + world.field_73012_v.nextInt(30), 0);
                }
                torchList.clear();
                scheduledTorchUpdates.remove(world.field_73011_w.field_76574_g);
            }
            if (world.field_73011_w instanceof IOrbitDimension) {
                Object[] entityList;
                for (Object o : entityList = world.field_72996_f.toArray()) {
                    IOrbitDimension dimension;
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    if (!(e.field_70170_p.field_73011_w instanceof IOrbitDimension) || !(e.field_70163_u <= (double)(dimension = (IOrbitDimension)e.field_70170_p.field_73011_w).getYCoordToTeleportToPlanet())) continue;
                    Integer dim = WorldUtil.getProviderForName((String)dimension.getPlanetToOrbit()).field_76574_g;
                    WorldUtil.transferEntityToDimension(e, dim, world, false, null);
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            List<BlockVec3> edgesList = edgeChecks.get(world.field_73011_w.field_76574_g);
            HashSet<BlockVec3> checkedThisTick = new HashSet<BlockVec3>();
            if (edgesList != null && !edgesList.isEmpty()) {
                ArrayList<BlockVec3> edgesListCopy = new ArrayList<BlockVec3>();
                edgesListCopy.addAll(edgesList);
                for (BlockVec3 edgeBlock : edgesListCopy) {
                    if (edgeBlock == null || checkedThisTick.contains(edgeBlock) || TickHandlerServer.scheduledForChange(world.field_73011_w.field_76574_g, edgeBlock)) continue;
                    ThreadFindSeal done = new ThreadFindSeal((World)world, edgeBlock, 2000, new ArrayList<TileEntityOxygenSealer>());
                    checkedThisTick.addAll(done.checked);
                }
                edgeChecks.remove(world.field_73011_w.field_76574_g);
            }
        }
    }

    static {
        oxygenTransmitterUpdates = new LinkedList();
        hydrogenTransmitterUpdates = new LinkedList();
        energyTransmitterUpdates = new LinkedList();
    }
}

