/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.util.concurrent.GenericFutureListener;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.ConnectionPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.Packet;

public class ConnectionEvents {
    private static boolean clientConnected = false;

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ChunkLoadingCallback.onPlayerLogout(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ChunkLoadingCallback.onPlayerLogin(event.player);
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP thePlayer = (EntityPlayerMP)event.player;
            GCPlayerStats stats = GCPlayerStats.get(thePlayer);
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, new Object[]{stats.spaceStationDimensionID}), thePlayer);
            SpaceRace raceForPlayer = SpaceRaceManager.getSpaceRaceFromPlayer(thePlayer.func_146103_bH().getName());
            if (raceForPlayer != null) {
                SpaceRaceManager.sendSpaceRaceData(thePlayer, raceForPlayer);
            }
        }
        if (event.player.field_70170_p.field_73011_w instanceof WorldProviderOrbit && event.player instanceof EntityPlayerMP) {
            ((WorldProviderOrbit)event.player.field_70170_p.field_73011_w).sendPacketsToClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onConnectionReceived(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        if (ConfigManagerCore.enableDebug) {
            Integer[] idList = (Integer[])WorldUtil.getPlanetList().get(0);
            String ids = "";
            for (int j = 0; j < idList.length; ++j) {
                ids = ids + idList[j].toString() + " ";
            }
            GCLog.info("Galacticraft server sending dimension IDs to connecting client: " + ids);
        }
        event.manager.func_150725_a((Packet)ConnectionPacket.createDimPacket(WorldUtil.getPlanetListInts()), new GenericFutureListener[0]);
        event.manager.func_150725_a((Packet)ConnectionPacket.createSSPacket(WorldUtil.getSpaceStationListInts()), new GenericFutureListener[0]);
        event.manager.func_150725_a((Packet)ConnectionPacket.createConfigPacket(ConfigManagerCore.getServerConfigOverride()), new GenericFutureListener[0]);
    }

    @SubscribeEvent
    public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal) {
            clientConnected = true;
        }
    }

    @SubscribeEvent
    public void onConnectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (clientConnected) {
            clientConnected = false;
            WorldUtil.unregisterPlanets();
            WorldUtil.unregisterSpaceStations();
            ConfigManagerCore.restoreClientConfigOverrideable();
        }
    }

    static {
        EnumConnectionState.field_150761_f.put(PacketSimple.class, EnumConnectionState.PLAY);
        EnumConnectionState.PLAY.field_150770_i.put((Object)2515, PacketSimple.class);
    }
}

