/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.FreefallHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerClient;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.MinecraftForge;

public class PlayerClient
implements IPlayerClient {
    private boolean saveSneak;
    private double downMot2;

    @Override
    public void moveEntity(EntityPlayerSP player, double par1, double par3, double par5) {
        this.updateFeet(player, par1, par5);
    }

    @Override
    public boolean wakeUpPlayer(EntityPlayerSP player, boolean par1, boolean par2, boolean par3) {
        return this.wakeUpPlayer(player, par1, par2, par3, false);
    }

    @Override
    public void onUpdate(EntityPlayerSP player) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        ++stats.tick;
        if (stats.usingParachute && !player.field_71075_bZ.field_75100_b && !player.func_70072_I()) {
            player.field_70181_x = -0.5;
            player.field_70159_w *= 0.5;
            player.field_70179_y *= 0.5;
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock(EntityPlayerSP player, boolean vanillaInside) {
        if (vanillaInside && GCPlayerStatsClient.get((EntityPlayerSP)player).inFreefall) {
            GCPlayerStatsClient.get((EntityPlayerSP)player).inFreefall = false;
            return false;
        }
        return !(player.field_70154_o instanceof EntityLanderBase) && vanillaInside;
    }

    @Override
    public void onLivingUpdatePre(EntityPlayerSP player) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            stats.inFreefallLast = stats.inFreefall;
            stats.inFreefall = FreefallHandler.testFreefall((EntityPlayer)player);
            if (player.field_70170_p.field_73011_w instanceof WorldProviderOrbit) {
                this.downMot2 = stats.downMotionLast;
                stats.downMotionLast = player.field_70181_x;
                ((WorldProviderOrbit)player.field_70170_p.field_73011_w).preVanillaMotion(player);
            }
        }
        if (player.field_70121_D != null && stats.boundingBoxBefore == null) {
            stats.boundingBoxBefore = player.field_70121_D;
            player.field_70121_D.func_72324_b(stats.boundingBoxBefore.field_72340_a + 0.4, stats.boundingBoxBefore.field_72338_b + 0.9, stats.boundingBoxBefore.field_72339_c + 0.4, stats.boundingBoxBefore.field_72336_d - 0.4, stats.boundingBoxBefore.field_72337_e - 0.9, stats.boundingBoxBefore.field_72334_f - 0.4);
        } else if (player.field_70121_D != null && stats.boundingBoxBefore != null) {
            player.field_70121_D.func_72328_c(stats.boundingBoxBefore);
        }
    }

    @Override
    public void onLivingUpdatePost(EntityPlayerSP player) {
        boolean ridingThirdPersonEntity;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        if (player.field_70170_p.field_73011_w instanceof WorldProviderOrbit) {
            ((WorldProviderOrbit)player.field_70170_p.field_73011_w).postVanillaMotion(player);
        }
        if (stats.inFreefall) {
            player.field_70754_ba -= player.field_70721_aZ;
            player.field_70721_aZ = player.field_70722_aY;
            float adjust = Math.min(Math.abs(player.field_70754_ba), Math.abs(player.field_70721_aZ) / 3.0f);
            if (player.field_70754_ba < 0.0f) {
                player.field_70754_ba += adjust;
            } else if (player.field_70754_ba > 0.0f) {
                player.field_70754_ba -= adjust;
            }
            player.field_70721_aZ = (float)((double)player.field_70721_aZ * 0.9);
        } else if (stats.inFreefallLast && this.downMot2 < -0.01) {
            stats.landingTicks = 2 - (int)(Math.min(this.downMot2, stats.downMotionLast) * 75.0);
            if (stats.landingTicks > 6) {
                stats.landingTicks = 6;
            }
        }
        if (stats.landingTicks > 0) {
            --stats.landingTicks;
        }
        boolean bl = ridingThirdPersonEntity = player.field_70154_o instanceof ICameraZoomEntity && ((ICameraZoomEntity)player.field_70154_o).defaultThirdPerson();
        if (ridingThirdPersonEntity && !stats.lastRidingCameraZoomEntity) {
            FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = 1;
        }
        if (player.field_70154_o != null && player.field_70154_o instanceof ICameraZoomEntity) {
            stats.lastZoomed = true;
            TickHandlerClient.zoom(((ICameraZoomEntity)player.field_70154_o).getCameraZoom());
        } else if (stats.lastZoomed) {
            stats.lastZoomed = false;
            TickHandlerClient.zoom(4.0f);
        }
        stats.lastRidingCameraZoomEntity = ridingThirdPersonEntity;
        if (stats.usingParachute) {
            player.field_70143_R = 0.0f;
        }
        PlayerGearData gearData = ClientProxyCore.playerItemData.get(player.func_70005_c_());
        stats.usingParachute = false;
        if (gearData != null) {
            boolean bl2 = stats.usingParachute = gearData.getParachute() != null;
        }
        if (stats.usingParachute && player.field_70122_E) {
            stats.setParachute(false);
            FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = stats.thirdPersonView;
        }
        if (!stats.lastUsingParachute && stats.usingParachute) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(GalacticraftCore.TEXTURE_PREFIX + "player.parachute"), 0.95f + player.func_70681_au().nextFloat() * 0.1f, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v));
        }
        stats.lastUsingParachute = stats.usingParachute;
        stats.lastOnGround = player.field_70122_E;
    }

    @Override
    public float getBedOrientationInDegrees(EntityPlayerSP player, float vanillaDegrees) {
        if (player.field_71081_bT != null) {
            int x = player.field_71081_bT.field_71574_a;
            int y = player.field_71081_bT.field_71572_b;
            int z = player.field_71081_bT.field_71573_c;
            if (player.field_70170_p.func_147438_o(x, y, z) instanceof TileEntityAdvanced) {
                switch (player.field_70170_p.func_72805_g(x, y, z) - 4) {
                    case 0: {
                        return 90.0f;
                    }
                    case 1: {
                        return 270.0f;
                    }
                    case 2: {
                        return 180.0f;
                    }
                    case 3: {
                        return 0.0f;
                    }
                }
            } else {
                return vanillaDegrees;
            }
        }
        return vanillaDegrees;
    }

    private void updateFeet(EntityPlayerSP player, double motionX, double motionZ) {
        int iPosZ;
        int iPosY;
        int iPosX;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        double motionSqrd = motionX * motionX + motionZ * motionZ;
        if (motionSqrd > 0.001 && player.field_70170_p != null && player.field_70170_p.field_73011_w instanceof WorldProviderMoon && player.field_70154_o == null && !player.field_71075_bZ.field_75100_b && player.field_70170_p.func_147439_a(iPosX = (int)Math.floor(player.field_70165_t), iPosY = (int)Math.floor(player.field_70163_u - 2.0), iPosZ = (int)Math.floor(player.field_70161_v)) == GCBlocks.blockMoon && player.field_70170_p.func_72805_g(iPosX, iPosY, iPosZ) == 5) {
            if (stats.distanceSinceLastStep > 0.35) {
                Vector3 pos = new Vector3((Entity)player);
                pos.y = (float)MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)) + player.func_70681_au().nextFloat() / 100.0f;
                switch (stats.lastStep) {
                    case 0: {
                        pos.translate(new Vector3(Math.sin(Math.toRadians(-player.field_70177_z + 90.0f)) * 0.25, 0.0, Math.cos(Math.toRadians(-player.field_70177_z + 90.0f)) * 0.25));
                        break;
                    }
                    case 1: {
                        pos.translate(new Vector3(Math.sin(Math.toRadians(-player.field_70177_z - 90.0f)) * 0.25, 0.0, Math.cos(Math.toRadians(-player.field_70177_z - 90.0f)) * 0.25));
                    }
                }
                pos = WorldUtil.getFootprintPosition(player.field_70170_p, player.field_70177_z - 180.0f, pos, new BlockVec3((Entity)player));
                long chunkKey = ChunkCoordIntPair.func_77272_a((int)(pos.intX() >> 4), (int)(pos.intZ() >> 4));
                ClientProxyCore.footprintRenderer.addFootprint(chunkKey, player.field_70170_p.field_73011_w.field_76574_g, pos, player.field_70177_z, player.func_70005_c_());
                ++stats.lastStep;
                stats.lastStep %= 2;
                stats.distanceSinceLastStep = 0.0;
            } else {
                stats.distanceSinceLastStep += motionSqrd;
            }
        }
    }

    public boolean wakeUpPlayer(EntityPlayerSP player, boolean par1, boolean par2, boolean par3, boolean bypass) {
        ChunkCoordinates c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event = new EventWakePlayer((EntityPlayer)player, c.field_71574_a, c.field_71572_b, c.field_71573_c, par1, par2, par3, bypass);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (bypass || event.result == null || event.result == EntityPlayer.EnumStatus.OK) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onBuild(int i, EntityPlayerSP player) {
        int repeatCount;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        int flag = stats.buildFlags;
        if (flag == -1) {
            flag = 0;
        }
        if ((repeatCount = flag >> 9) <= 3) {
            ++repeatCount;
        }
        if ((flag & 1 << i) > 0) {
            return;
        }
        stats.buildFlags = ((flag |= 1 << i) & 0x1FF) + (repeatCount << 9);
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_BUILDFLAGS_UPDATE, new Object[]{stats.buildFlags}));
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                player.func_145747_a(IChatComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.help1") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + GalacticraftCore.PREFIX + "com/wiki/1" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + GalacticraftCore.PREFIX + "com/wiki/1" + "\"}}]")));
                player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.message.help1a") + (Object)((Object)EnumColor.AQUA) + " /gchelp"));
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                player.func_145747_a(IChatComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.help2") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + GalacticraftCore.PREFIX + "com/wiki/2" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + GalacticraftCore.PREFIX + "com/wiki/2" + "\"}}]")));
                break;
            }
            case 7: {
                player.func_145747_a(IChatComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.help3") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + GalacticraftCore.PREFIX + "com/wiki/oil" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + GalacticraftCore.PREFIX + "com/wiki/oil" + "\"}}]")));
                break;
            }
            case 8: {
                player.func_145747_a(IChatComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.prelaunch") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + GalacticraftCore.PREFIX + "com/wiki/pre" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + GalacticraftCore.PREFIX + "com/wiki/pre" + "\"}}]")));
            }
        }
    }
}

