/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.wiiemc.providers;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.lomeli.wiiemc.WIIEMC;
import net.lomeli.wiiemc.config.ModConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityEMCDataProvider
implements IWailaEntityProvider {
    private static DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");

    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(Entity entity, List<String> tooltip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tooltip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        EntityPlayer player = accessor.getPlayer();
        if (entity != null && player != null) {
            EnergyValue entityValue = null;
            EnergyValue itemEnergy = null;
            ItemStack entityItem = null;
            if (entity instanceof EntityPainting) {
                entityItem = new ItemStack(Items.field_151159_an);
                entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
            } else if (entity instanceof EntityItemFrame) {
                ItemStack stack;
                entityItem = new ItemStack(Items.field_151160_bD);
                entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
                if (ModConfig.showItemFrameEMC && (stack = ((EntityItemFrame)entity).func_82335_i()) != null && stack.func_77973_b() != null && EnergyValueRegistryProxy.hasEnergyValue((Object)stack)) {
                    itemEnergy = EnergyValueRegistryProxy.getEnergyValue((Object)stack);
                }
            } else if (entity instanceof EntityMinecart) {
                if (entity instanceof EntityMinecartChest) {
                    entityItem = new ItemStack(Items.field_151108_aI);
                    entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
                } else if (entity instanceof EntityMinecartFurnace) {
                    entityItem = new ItemStack(Items.field_151109_aJ);
                    entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
                } else if (entity instanceof EntityMinecartTNT) {
                    entityItem = new ItemStack(Items.field_151142_bV);
                    entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
                } else if (entity instanceof EntityMinecartHopper) {
                    entityItem = new ItemStack(Items.field_151140_bW);
                    entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
                } else if (entity instanceof EntityMinecartEmpty) {
                    entityItem = new ItemStack(Items.field_151143_au);
                    entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
                }
            } else if (entity instanceof EntityBoat) {
                entityItem = new ItemStack(Items.field_151124_az);
                entityValue = EnergyValueRegistryProxy.getEnergyValue((Object)entityItem);
            }
            if (entityItem != null) {
                boolean isKnown = WIIEMC.proxy.doesPlayerKnow(entityItem);
                boolean canBeLearned = WIIEMC.proxy.canPlayerLearn(entityItem);
                if (entityValue != null && entityValue.getValue() > 0.0f) {
                    if (ModConfig.showEMC) {
                        String tip = StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.value");
                        String energy = energyValueDecimalFormat.format(entityValue.getValue());
                        tooltip.add(String.format(tip, energy));
                    }
                    if (itemEnergy != null && ModConfig.showItemFrameEMC) {
                        String itemTip = StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.storeditememc");
                        String itemValue = energyValueDecimalFormat.format(itemEnergy.getValue());
                        tooltip.add(String.format(itemTip, itemValue));
                    }
                } else if (ModConfig.showNoEMC) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.none"));
                }
                if (canBeLearned) {
                    if (ModConfig.showCanLearn) {
                        tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.knowledge.isunknown"));
                    }
                } else if (isKnown && ModConfig.showIsLearned) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.knowledge.isknown"));
                } else if (ModConfig.showCantLearn) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.knowledge.cantlearn"));
                }
            }
        }
        return tooltip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tooltip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaEntityProvider)new EntityEMCDataProvider(), Entity.class);
    }
}

