/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.wiiemc.core.helper;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ObfUtil {
    public static boolean isObf() {
        try {
            Field[] fields;
            for (Field f : fields = Class.forName("net.minecraft.world.World").getDeclaredFields()) {
                f.setAccessible(true);
                if (!f.getName().equalsIgnoreCase("loadedEntityList")) continue;
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static boolean isFieldAccessible(Class<?> clazz, String ... names) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                for (String fieldName : names) {
                    if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                    return field.isAccessible();
                }
            }
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToFindFieldException(names, e);
        }
        return false;
    }

    public static void setFieldAccessible(Class<?> clazz, String ... names) {
        try {
            Field field = ObfUtil.getField(clazz, names);
            if (field != null) {
                field.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T, E> void setFieldValue(Class<? extends E> clazz, E instance, Object value, String ... names) {
        try {
            Field field = ObfUtil.getField(clazz, names);
            if (field != null) {
                field.set(instance, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T, E> T getFieldValue(Class<? extends E> clazz, E instance, String ... names) {
        try {
            return (T)ObfUtil.getField(clazz, names).get(instance);
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToAccessFieldException(names, e);
        }
    }

    public static Field getField(Class<?> clazz, String ... names) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                for (String fieldName : names) {
                    if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToFindFieldException(names, e);
        }
        return null;
    }

    public static boolean isMethodAccessable(Class<?> clazz, String ... names) {
        try {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                for (String methodName : names) {
                    if (!method.getName().equalsIgnoreCase(methodName)) continue;
                    return method.isAccessible();
                }
            }
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToFindMethodException(names, e);
        }
        return false;
    }

    public static <T, E> Object invokeMethod(Class<? extends E> clazz, E instance, String[] names, Object ... args) {
        try {
            Method method = ObfUtil.getMethod(clazz, names);
            if (method != null) {
                return method.invoke(instance, args);
            }
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToFindMethodException(names, e);
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String ... names) {
        try {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                for (String methodName : names) {
                    if (!method.getName().equalsIgnoreCase(methodName)) continue;
                    method.setAccessible(true);
                    return method;
                }
            }
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToFindMethodException(names, e);
        }
        return null;
    }
}

