/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature.vanilla;

import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class VanillaTree
extends AbstractTree {
    public VanillaTree(boolean fromSapling) {
        super(fromSapling);
    }

    @Override
    protected boolean hasRoomToGrow(World world, int x, int y, int z, int height) {
        for (int y1 = y; y1 <= y + 1 + height; ++y1) {
            int radius = y1 >= y + 1 + height - 2 ? 2 : (y1 == y ? 0 : 1);
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    if (y1 >= 0 && y1 < 256) {
                        if (this.isReplaceable(world, x1, y1, z1)) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = 4 + rand.nextInt(3) + rand.nextInt(7);
        if (this.isPoorGrowthConditions(world, x, y, z, height, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        this.placeCanopy(world, rand, x, y, z, height);
        for (int dY = 0; dY < height; ++dY) {
            this.placeLog(world, x, y + dY, z);
        }
        return true;
    }

    private void placeCanopy(World world, Random rand, int x, int y, int z, int height) {
        for (int y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int distanceToTopOfTrunk = y1 - (y + height);
            int radius = 1 - distanceToTopOfTrunk / 2;
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                int dX = x1 - x;
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    int dZ = z1 - z;
                    if (Math.abs(dX) == radius && Math.abs(dZ) == radius && (rand.nextInt(2) == 0 || distanceToTopOfTrunk == 0)) continue;
                    this.placeLeaves(world, x1, y1, z1);
                }
            }
        }
    }
}

