/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature.hekur;

import com.google.common.base.Objects;
import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class NormalHekurTree
extends AbstractTree {
    private int logDirection = 0;

    public NormalHekurTree(boolean fromSapling) {
        super(fromSapling);
    }

    @Override
    protected boolean isPoorGrowthConditions(World world, int x, int y, int z, int unused, IPlantable plantable) {
        Block block = world.func_147439_a(x, y - 1, z);
        return !block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, plantable);
    }

    @Override
    protected int getLogMetadata() {
        return super.getLogMetadata() | this.logDirection;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("logDirection", this.logDirection).toString();
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Random random = new Random();
        random.setSeed(rand.nextLong());
        if (this.isPoorGrowthConditions(world, x, y, z, 0, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        this.genRoots(world, random, x, y, z);
        this.growTrunk(world, random, x, y, z);
        return true;
    }

    private void genRoots(World world, Random random, int x, int y, int z) {
        for (ImmutablePair branchDirection : BRANCH_DIRECTIONS) {
            if (random.nextInt(3) != 0) continue;
            this.genRoot(world, random, x, y, z, (Integer)branchDirection.getLeft(), (Integer)branchDirection.getRight());
        }
        this.genRoot(world, random, x, y, z, 0, 0);
    }

    void genRoot(World world, Random rand, int x, int y, int z, int dX, int dZ) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        this.setLogDirection(dX, dZ);
        for (int i = 0; i < 6; ++i) {
            if (rand.nextInt(3) == 0) {
                if (dX == -1) {
                    --x1;
                }
                if (dX == 1) {
                    ++x1;
                }
                if (dZ == -1) {
                    --z1;
                }
                if (dZ == 1) {
                    ++z1;
                }
            }
            this.placeRoot(world, x1, y1, z1);
            --y1;
        }
        this.clearLogDirection();
    }

    private void setLogDirection(int dX, int dZ) {
        if (dX != 0) {
            this.logDirection = 4;
        }
        if (dZ != 0) {
            this.logDirection = 8;
        }
    }

    boolean canBeReplacedByRoot(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Material material = block.func_149688_o();
        return this.canBeReplacedByLog(world, x, y, z) || material.equals(Material.field_151595_p) || material.equals(Material.field_151578_c);
    }

    boolean placeRoot(World world, int x, int y, int z) {
        if (this.canBeReplacedByRoot(world, x, y, z)) {
            this.func_150516_a(world, x, y, z, (Block)this.getLogBlock(), this.getLogMetadata());
            return true;
        }
        return false;
    }

    void growTrunk(World world, Random random, int i1, int j1, int k1) {
        this.placeLog(world, i1, j1, k1);
        switch (random.nextInt(4)) {
            case 0: {
                this.placeLog(world, i1, j1 + 2, k1);
                this.placeLog(world, i1 - 1, j1 + 1, k1);
                this.largeDirect(world, random, 1, 0, i1, j1 + 2, k1, 1, 2, 0, 2);
                break;
            }
            case 1: {
                this.placeLog(world, i1, j1 + 1, k1);
                this.placeLog(world, i1, j1 + 2, k1);
                this.placeLog(world, i1, j1 + 1, k1 - 1);
                this.largeDirect(world, random, 0, 1, i1, j1 + 2, k1, 1, 2, 0, 2);
                break;
            }
            case 2: {
                this.placeLog(world, i1, j1 + 1, k1);
                this.placeLog(world, i1, j1 + 2, k1);
                this.placeLog(world, i1 + 1, j1 + 1, k1);
                this.largeDirect(world, random, -1, 0, i1, j1 + 2, k1, 1, 2, 0, 2);
                break;
            }
            default: {
                this.placeLog(world, i1, j1 + 1, k1);
                this.placeLog(world, i1, j1 + 2, k1);
                this.placeLog(world, i1, j1 + 1, k1 + 1);
                this.largeDirect(world, random, 0, -1, i1, j1 + 1, k1, 1, 2, 0, 2);
            }
        }
    }

    void largeDirect(World world, Random rand, int dX, int dZ, int x, int y, int z, int size, int splitCount, int splitCount1, int splitCount2) {
        int z1 = z;
        int x1 = x;
        int y1 = y;
        this.setLogDirection(dX, dZ);
        int dSize = 0;
        if (size == 2) {
            dSize = 2;
        }
        for (int next = 0; next <= 5 * size; ++next) {
            if (size == 1) {
                ++y1;
            }
            this.placeLog(world, x1, y1, z1);
            if (next <= 9 && size == 2) {
                this.placeLog(world, x1 - dX, y1, z1 - dZ);
            }
            if (next == 5 * size) {
                this.branchAndLeaf(world, x1, y1 + 1, z1);
            }
            if (size == 2) {
                ++y1;
            }
            x1 += dX;
            z1 += dZ;
            if (next == splitCount) {
                this.firstBranchSplit(world, rand, x1, y1, z1, dX, dZ, splitCount);
                this.secondBranchSplit(world, rand, x1, y1, z1, dX, dZ, splitCount);
            }
            if (next == 3 * size && size == 2) {
                this.fifthBranchSplit(world, rand, x1, y1, z1, dX, dZ, splitCount1);
                this.sixthBranchSplit(world, rand, x1, y1, z1, dX, dZ, splitCount1);
            }
            if (next == 3 * size) {
                this.thirdBranchSplit(world, rand, x1, y1, z1, dX, dZ, 4 * size - dSize);
                this.fourthBranchSplit(world, rand, x1, y1, z1, dX, dZ, 4 * size - dSize);
            }
            if (next != 4 * size) continue;
            this.fifthBranchSplit(world, rand, x1, y1, z1, dX, dZ, splitCount2);
            this.sixthBranchSplit(world, rand, x1, y1, z1, dX, dZ, splitCount2);
        }
        this.clearLogDirection();
    }

    private void firstBranchSplit(World world, Random rand, int x, int y, int z, int dX, int dZ, int splitCount) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        for (int i = 0; i <= splitCount; ++i) {
            if (dX != 0) {
                if (rand.nextInt(5) > 0) {
                    x1 = dX == 1 ? --x1 : ++x1;
                }
                z1 += rand.nextInt(2);
            }
            if (dZ == 1) {
                x1 -= rand.nextInt(2);
                if (rand.nextInt(5) > 0) {
                    --z1;
                }
            } else if (dZ == -1) {
                x1 += rand.nextInt(2);
                if (rand.nextInt(5) > 0) {
                    ++z1;
                }
            }
            this.placeLog(world, x1, ++y1, z1);
            if (i != splitCount) continue;
            this.branchAndLeaf(world, x1, y1, z1);
        }
    }

    private void secondBranchSplit(World world, Random rand, int x, int y, int z, int dX, int dZ, int splitCount) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        for (int i = 0; i <= splitCount; ++i) {
            if (dX != 0) {
                if (rand.nextInt(5) > 0) {
                    x1 = dX == 1 ? --x1 : ++x1;
                }
                z1 -= rand.nextInt(2);
            }
            if (dZ == 1) {
                x1 += rand.nextInt(2);
                if (rand.nextInt(5) > 0) {
                    --z1;
                }
            } else if (dZ == -1) {
                x1 -= rand.nextInt(2);
                if (rand.nextInt(5) > 0) {
                    ++z1;
                }
            }
            this.placeLog(world, x1, ++y1, z1);
            if (i != splitCount) continue;
            this.branchAndLeaf(world, x1, y1, z1);
        }
    }

    private void thirdBranchSplit(World world, Random rand, int x, int y, int z, int dX, int dZ, int length) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        for (int i = 0; i <= length; ++i) {
            if (dX != 0) {
                x1 = dX == 1 ? (x1 += rand.nextInt(2)) : (x1 -= rand.nextInt(2));
                z1 += rand.nextInt(2);
            }
            if (dZ != 0) {
                z1 = dZ == 1 ? (z1 += rand.nextInt(2)) : (z1 -= rand.nextInt(2));
                x1 += rand.nextInt(2);
            }
            if (i >= 3) {
                y1 += rand.nextInt(2);
            }
            this.placeLog(world, x1, y1, z1);
            if (i != length) continue;
            this.branchAndLeaf(world, x1, y1, z1);
        }
    }

    private void fourthBranchSplit(World world, Random rand, int x, int y, int z, int dX, int dZ, int length) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        for (int i = 0; i <= length; ++i) {
            if (dX != 0) {
                x1 = dX == 1 ? (x1 += rand.nextInt(2)) : (x1 -= rand.nextInt(2));
                z1 -= rand.nextInt(2);
            }
            if (dZ != 0) {
                z1 = dZ == 1 ? (z1 += rand.nextInt(2)) : (z1 -= rand.nextInt(2));
                x1 -= rand.nextInt(2);
            }
            if (i >= 3) {
                y1 += rand.nextInt(2);
            }
            this.placeLog(world, x1, y1, z1);
            if (i != length) continue;
            this.branchAndLeaf(world, x1, y1, z1);
        }
    }

    private void fifthBranchSplit(World world, Random rand, int x, int y, int z, int dX, int dZ, int splitCount2) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        for (int i = 0; i <= splitCount2; ++i) {
            if (dX == 1) {
                x1 -= rand.nextInt(2);
                z1 += rand.nextInt(2);
            }
            if (dX == -1) {
                x1 += rand.nextInt(2);
                z1 += rand.nextInt(2);
            }
            if (dZ == 1) {
                x1 -= rand.nextInt(2);
                z1 -= rand.nextInt(2);
            }
            if (dZ == -1) {
                x1 += rand.nextInt(2);
                z1 += rand.nextInt(2);
            }
            this.placeLog(world, x1, ++y1, z1);
            if (i != splitCount2) continue;
            this.branchAndLeaf(world, x1, y1, z1);
        }
    }

    private void sixthBranchSplit(World world, Random rand, int x, int y, int z, int dX, int dZ, int splitCount2) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        for (int i = 0; i <= splitCount2; ++i) {
            if (dX != 0) {
                x1 = dX == 1 ? (x1 -= rand.nextInt(2)) : (x1 += rand.nextInt(2));
                z1 -= rand.nextInt(2);
            }
            if (dZ == 1) {
                x1 += rand.nextInt(2);
                z1 -= rand.nextInt(2);
            } else if (dZ == -1) {
                x1 -= rand.nextInt(2);
                z1 += rand.nextInt(2);
            }
            this.placeLog(world, x1, ++y1, z1);
            if (i != splitCount2) continue;
            this.branchAndLeaf(world, x1, y1, z1);
        }
    }

    private void clearLogDirection() {
        this.logDirection = 0;
    }

    void branchAndLeaf(World world, int x, int y, int z) {
        this.placeLog(world, x, y, z);
        for (int dX = -3; dX <= 3; ++dX) {
            for (int dZ = -3; dZ <= 3; ++dZ) {
                if (!(Math.abs(dX) == 3 && Math.abs(dZ) == 3 || Math.abs(dX) == 2 && Math.abs(dZ) == 3 || Math.abs(dX) == 3 && Math.abs(dZ) == 2)) {
                    this.placeLeaves(world, x + dX, y, z + dZ);
                }
                if (Math.abs(dX) >= 3 || Math.abs(dZ) >= 3 || Math.abs(dX) == 2 && Math.abs(dZ) == 2) continue;
                this.placeLeaves(world, x + dX, y + 1, z + dZ);
            }
        }
    }
}

