/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature.cedrum;

import com.google.common.base.Objects;
import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class NormalCedrumTree
extends AbstractTree {
    int logDirection = 0;

    public NormalCedrumTree(boolean fromSapling) {
        super(fromSapling);
    }

    @Override
    protected boolean canBeReplacedByLog(World world, int x, int y, int z) {
        return super.canBeReplacedByLog(world, x, y, z) || world.func_147439_a(x, y, z).func_149688_o().equals(Material.field_151586_h);
    }

    @Override
    protected int getLogMetadata() {
        return super.getLogMetadata() | this.logDirection;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("logDirection", this.logDirection).toString();
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        return super.isReplaceable(world, x, y, z) || world.func_147439_a(x, y, z).func_149688_o().equals(Material.field_151586_h);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(10) + 9;
        if (this.isPoorGrowthConditions(world, x, y, z, height, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        for (int level = 0; level <= height; ++level) {
            this.placeLog(world, x, y + level, z);
            if (level == height) {
                this.leafTop(world, x, y + level, z);
            }
            if (level <= 5 || level >= height) continue;
            if (level == height - 1) {
                this.leafGen(world, 2, x, y + level, z);
            }
            if (level == height - 4 || level == height - 7) {
                for (int next = 1; next < 3; ++next) {
                    this.logDirection = 4;
                    this.placeLog(world, x + next, y + level - 2, z);
                    this.placeLog(world, x - next, y + level - 2, z);
                    this.logDirection = 8;
                    this.placeLog(world, x, y + level - 2, z + next);
                    this.placeLog(world, x, y + level - 2, z - next);
                    this.logDirection = 0;
                }
                this.leafGen(world, level == height - 4 ? 3 : 4, x, y + level, z);
            }
            if (level != height - 10 && level != height - 13) continue;
            this.leafGen(world, level == height - 10 ? 3 : 2, x, y + level, z);
        }
        return true;
    }

    void leafTop(World world, int x, int y, int z) {
        for (int dX = -2; dX <= 2; ++dX) {
            for (int dZ = -2; dZ <= 2; ++dZ) {
                if (Math.abs(dX) + Math.abs(dZ) < 3) {
                    this.placeLeaves(world, x + dX, y, z + dZ);
                }
                if (Math.abs(dX) + Math.abs(dZ) < 2) {
                    this.placeLeaves(world, x + dX, y + 1, z + dZ);
                }
                if (Math.abs(dX) != 0 || Math.abs(dZ) != 0) continue;
                this.placeLeaves(world, x + dX, y + 2, z + dZ);
            }
        }
    }

    void leafGen(World world, int size, int x, int y, int z) {
        int limiter3;
        int limiter2;
        int limiter1;
        int radius;
        switch (size) {
            case 3: {
                radius = 4;
                limiter1 = 3;
                limiter2 = 5;
                limiter3 = 7;
                break;
            }
            case 4: {
                radius = 5;
                limiter1 = 5;
                limiter2 = 7;
                limiter3 = 8;
                break;
            }
            case 5: {
                radius = 6;
                limiter1 = 7;
                limiter2 = 8;
                limiter3 = 9;
                break;
            }
            default: {
                radius = 3;
                limiter1 = 2;
                limiter2 = 3;
                limiter3 = 5;
            }
        }
        this.doLeafGen(world, x, y, z, radius, limiter1, limiter2, limiter3);
    }

    private void doLeafGen(World world, int x, int y, int z, int radius, int limiter1, int limiter2, int limiter3) {
        for (int dX = -radius; dX <= radius; ++dX) {
            for (int dZ = -radius; dZ <= radius; ++dZ) {
                if (Math.abs(dX) + Math.abs(dZ) < limiter1) {
                    this.placeLeaves(world, x + dX, y, z + dZ);
                }
                if (Math.abs(dX) + Math.abs(dZ) < limiter2) {
                    this.placeLeaves(world, x + dX, y - 1, z + dZ);
                }
                if (Math.abs(dX) + Math.abs(dZ) >= limiter3) continue;
                this.placeLeaves(world, x + dX, y - 2, z + dZ);
            }
        }
    }
}

