/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature;

import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class DelnasTree
extends AbstractTree {
    public DelnasTree(boolean fromSapling) {
        super(fromSapling);
    }

    public DelnasTree() {
        this(true);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Random rng = new Random();
        rng.setSeed(rand.nextLong());
        int height = rng.nextInt(5) + 6;
        if (this.isPoorGrowthConditions(world, x, y, z, height, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        if (rng.nextInt(10) > 0) {
            for (int dY = 0; dY <= height; ++dY) {
                this.placeLog(world, x, y + dY, z);
                if (dY != height) continue;
                this.leafGen(world, x, y + dY, z);
            }
        } else {
            switch (rand.nextInt(4)) {
                case 0: {
                    this.growDirect(world, rng, x, y, z, 1, 0, height);
                    break;
                }
                case 1: {
                    this.growDirect(world, rng, x, y, z, 0, 1, height);
                    break;
                }
                case 2: {
                    this.growDirect(world, rng, x, y, z, -1, 0, height);
                    break;
                }
                default: {
                    this.growDirect(world, rng, x, y, z, 0, -1, height);
                }
            }
        }
        return true;
    }

    private void leafGen(World world, int x, int y, int z) {
        for (int dX = -3; dX <= 3; ++dX) {
            for (int dZ = -3; dZ <= 3; ++dZ) {
                if (Math.abs(dX) + Math.abs(dZ) <= 3 && (Math.abs(dX) + Math.abs(dZ) != 3 || Math.abs(dX) == 0 || Math.abs(dZ) == 0)) {
                    this.placeLeaves(world, x + dX, y, z + dZ);
                }
                if (Math.abs(dX) >= 2 || Math.abs(dZ) >= 2 || Math.abs(dX) == 1 && Math.abs(dZ) == 1) continue;
                this.placeLeaves(world, x + dX, y + 1, z + dZ);
            }
        }
    }

    private void growDirect(World world, Random rand, int x, int y, int z, int dX, int dZ, int hight) {
        int x1 = x;
        int z1 = z;
        this.placeLog(world, x1, y, z1);
        if (dX == 1) {
            this.placeLog(world, x1 - 1, y, z1);
        }
        if (dX == -1) {
            this.placeLog(world, x1 + 1, y, z1);
        }
        if (dZ == 1) {
            this.placeLog(world, x1, y, z1 - 1);
        }
        if (dZ == -1) {
            this.placeLog(world, x1, y, z1 + 1);
        }
        int addlRandomLengthX = 0;
        int addlRandomLengthZ = 0;
        for (int level = 0; level <= hight; ++level) {
            if (dX == 1 && rand.nextInt(2 + addlRandomLengthX) == 0) {
                ++x1;
            }
            if (dX == -1 && rand.nextInt(2 + addlRandomLengthX) == 0) {
                --x1;
            }
            if (dZ == 1 && rand.nextInt(2 + addlRandomLengthZ) == 0) {
                ++z1;
            }
            if (dZ == -1 && rand.nextInt(2 + addlRandomLengthZ) == 0) {
                --z1;
            }
            ++addlRandomLengthX;
            ++addlRandomLengthZ;
            this.placeLog(world, x1, level + y, z1);
        }
        this.leafGen(world, x1, hight + y, z1);
    }
}

