/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.content.overworld;

import com.scottkillen.mod.dendrology.block.ModBlocks;
import com.scottkillen.mod.dendrology.block.ModLeavesBlock;
import com.scottkillen.mod.dendrology.block.ModLogBlock;
import com.scottkillen.mod.dendrology.block.ModSaplingBlock;
import com.scottkillen.mod.dendrology.block.ModSlabBlock;
import com.scottkillen.mod.dendrology.block.ModStairsBlock;
import com.scottkillen.mod.dendrology.block.ModWoodBlock;
import com.scottkillen.mod.koresample.common.block.SlabBlock;
import com.scottkillen.mod.koresample.common.block.StairsBlock;
import com.scottkillen.mod.koresample.common.util.slab.SingleDoubleSlab;
import com.scottkillen.mod.koresample.tree.DefinesLeaves;
import com.scottkillen.mod.koresample.tree.DefinesLog;
import com.scottkillen.mod.koresample.tree.DefinesSapling;
import com.scottkillen.mod.koresample.tree.DefinesSlab;
import com.scottkillen.mod.koresample.tree.DefinesStairs;
import com.scottkillen.mod.koresample.tree.DefinesWood;
import com.scottkillen.mod.koresample.tree.TreeBlockFactory;
import com.scottkillen.mod.koresample.tree.block.LeavesBlock;
import com.scottkillen.mod.koresample.tree.block.LogBlock;
import com.scottkillen.mod.koresample.tree.block.SaplingBlock;
import com.scottkillen.mod.koresample.tree.block.WoodBlock;

public final class OverworldTreeBlockFactory
implements TreeBlockFactory {
    public LeavesBlock createLeavesBlock(Iterable<DefinesLeaves> subBlocks) {
        ModLeavesBlock block = new ModLeavesBlock(subBlocks);
        for (DefinesLeaves subBlock : subBlocks) {
            subBlock.assignLeavesBlock((LeavesBlock)block);
        }
        ModBlocks.registerBlock(block);
        return block;
    }

    public LogBlock createLogBlock(Iterable<DefinesLog> subBlocks) {
        ModLogBlock block = new ModLogBlock(subBlocks);
        for (DefinesLog subBlock : subBlocks) {
            subBlock.assignLogBlock((LogBlock)block);
        }
        ModBlocks.registerBlock(block);
        return block;
    }

    public SaplingBlock createSaplingBlock(Iterable<DefinesSapling> subBlocks) {
        ModSaplingBlock block = new ModSaplingBlock(subBlocks);
        for (DefinesSapling subBlock : subBlocks) {
            subBlock.assignSaplingBlock((SaplingBlock)block);
        }
        ModBlocks.registerBlock(block);
        return block;
    }

    public SingleDoubleSlab createSlabBlocks(Iterable<DefinesSlab> subBlocks) {
        ModSlabBlock singleSlabBlock = new ModSlabBlock(false, subBlocks);
        ModSlabBlock doubleSlabBlock = new ModSlabBlock(true, subBlocks);
        for (DefinesSlab subBlock : subBlocks) {
            subBlock.assignSingleSlabBlock((SlabBlock)singleSlabBlock);
            subBlock.assignDoubleSlabBlock((SlabBlock)doubleSlabBlock);
        }
        ModBlocks.registerBlock(singleSlabBlock, doubleSlabBlock);
        return new SingleDoubleSlab((SlabBlock)singleSlabBlock, (SlabBlock)doubleSlabBlock);
    }

    public StairsBlock createStairsBlock(DefinesStairs definition) {
        ModStairsBlock block = new ModStairsBlock(definition);
        block.func_149663_c(String.format("stairs.%s", definition.stairsName()));
        definition.assignStairsBlock((StairsBlock)block);
        ModBlocks.registerBlock(block);
        return block;
    }

    public WoodBlock createWoodBlock(Iterable<DefinesWood> subBlocks) {
        ModWoodBlock block = new ModWoodBlock(subBlocks);
        for (DefinesWood subBlock : subBlocks) {
            subBlock.assignWoodBlock((WoodBlock)block);
        }
        ModBlocks.registerBlock(block);
        return block;
    }
}

