/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.scottkillen.mod.dendrology.TheMod;
import com.scottkillen.mod.koresample.config.ConfigSyncable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;

public enum Settings implements ConfigSyncable
{
    INSTANCE;

    public static final String CONFIG_VERSION = "2";
    private static final int MAX_OVERWORLD_TREE_GEN_RARITY = 10000;
    private static final int DEFAULT_OVER_WORLD_TREE_GEN_RARITY = 1;
    private static final ImmutableMap<String, Integer> DEFAULT_CHEST_RARITIES;
    private static final ImmutableMap<String, String> CHEST_CONFIG_NAMES;
    private final Map<String, Integer> chestRarities = Settings.defaultChestRarities();
    private int overworldTreeGenRarity = 1;
    private boolean integrateChisel = true;
    private boolean integrateForestry = true;
    private boolean integrateGardenStuff = true;
    private boolean integrateMFR = true;
    private boolean integrateMinechem = true;
    private boolean integrateStorageDrawers = true;

    private static ImmutableMap<String, String> chestConfigNames() {
        HashMap map = Maps.newHashMap();
        map.put("villageBlacksmith", "blacksmithRarity");
        map.put("bonusChest", "bonusChestRarity");
        map.put("pyramidDesertyChest", "desertTempleRarity");
        map.put("dungeonChest", "dungeonRarity");
        map.put("pyramidJungleChest", "jungleTempleRarity");
        map.put("pyramidJungleDispenser", "jungleTempleDispenserRarity");
        map.put("mineshaftCorridor", "mineshaftCorridorRarity");
        map.put("strongholdCorridor", "strongholdCorridorRarity");
        map.put("strongholdCrossing", "strongholdCrossingRarity");
        map.put("strongholdLibrary", "strongholdLibraryRarity");
        return ImmutableMap.copyOf((Map)map);
    }

    private static Map<String, Integer> defaultChestRarities() {
        HashMap map = Maps.newHashMap();
        map.put("villageBlacksmith", 0);
        map.put("bonusChest", 0);
        map.put("pyramidDesertyChest", 1);
        map.put("dungeonChest", 1);
        map.put("pyramidJungleChest", 1);
        map.put("pyramidJungleDispenser", 0);
        map.put("mineshaftCorridor", 1);
        map.put("strongholdCorridor", 1);
        map.put("strongholdCrossing", 1);
        map.put("strongholdLibrary", 1);
        return map;
    }

    private static int get(Configuration config, String settingName, int defaultValue) {
        return Settings.get(config, settingName, defaultValue, 0, Integer.MAX_VALUE);
    }

    private static int get(Configuration config, String settingName, String category, int defaultValue) {
        return Settings.get(config, settingName, category, defaultValue, 0, Integer.MAX_VALUE);
    }

    private static boolean get(Configuration config, String settingName, String category, boolean defaultValue) {
        return config.getBoolean(settingName, category, defaultValue, Settings.getLocalizedComment(settingName));
    }

    private static int get(Configuration config, String settingName, int defaultValue, int minumumValue, int maximumValue) {
        return Settings.get(config, settingName, "general", defaultValue, minumumValue, maximumValue);
    }

    private static int get(Configuration config, String settingName, String category, int defaultValue, int minumumValue, int maximumValue) {
        return config.getInt(settingName, category, defaultValue, minumumValue, maximumValue, Settings.getLocalizedComment(settingName));
    }

    private static String getLocalizedComment(String settingName) {
        return StatCollector.func_74838_a((String)("config.dendrology:" + settingName));
    }

    public static Iterable<String> chestTypes() {
        return DEFAULT_CHEST_RARITIES.keySet();
    }

    private void loadChestRarity(Configuration config, String category, String chestType) {
        int defaultRarity = (Integer)DEFAULT_CHEST_RARITIES.get((Object)chestType);
        String settingName = (String)CHEST_CONFIG_NAMES.get((Object)chestType);
        int rarity = Settings.get(config, settingName, category, defaultRarity);
        this.chestRarities.put(chestType, rarity);
    }

    public int chestRarity(String chestType) {
        Integer rarity = this.chestRarities.get(chestType);
        return rarity == null ? 0 : rarity;
    }

    public boolean isOverworldTreeGenEnabled() {
        return this.overworldTreeGenRarity != 0;
    }

    public int overworldTreeGenRarity() {
        return 10000 - this.overworldTreeGenRarity + 1;
    }

    public void convertOldConfig(Configuration oldConfig) {
        if ("1".equals(oldConfig.getLoadedConfigVersion())) {
            for (String chestType : DEFAULT_CHEST_RARITIES.keySet()) {
                this.loadChestRarity(oldConfig, "general", chestType);
            }
            this.overworldTreeGenRarity = Settings.get(oldConfig, "overworldTreeGenRarity", 1, 0, 10000);
        }
        this.syncConfig(TheMod.INSTANCE.configuration());
    }

    public void syncConfig(Configuration config) {
        String chestsCategory = "general.chests";
        for (String chestType : this.chestRarities.keySet()) {
            this.loadChestRarity(config, "general.chests", chestType);
        }
        String worldGenCategory = "general.worldgen";
        this.overworldTreeGenRarity = Settings.get(config, "overworldTreeGenRarity", "general.worldgen", 1, 0, 10000);
        String integrationCategory = "general.integration";
        this.integrateChisel = Settings.get(config, "integrateChisel", "general.integration", true);
        this.integrateForestry = Settings.get(config, "integrateForestry", "general.integration", true);
        this.integrateGardenStuff = Settings.get(config, "integrateGardenStuff", "general.integration", true);
        this.integrateMFR = Settings.get(config, "integrateMFR", "general.integration", true);
        this.integrateMinechem = Settings.get(config, "integrateMinechem", "general.integration", true);
        this.integrateStorageDrawers = Settings.get(config, "integrateStorageDrawers", "general.integration", true);
    }

    public boolean integrateChisel() {
        return this.integrateChisel;
    }

    public boolean integrateForestry() {
        return this.integrateForestry;
    }

    public boolean integrateGardenStuff() {
        return this.integrateGardenStuff;
    }

    public boolean integrateMFR() {
        return this.integrateMFR;
    }

    public boolean integrateMinechem() {
        return this.integrateMinechem;
    }

    public boolean integrateStorageDrawers() {
        return this.integrateStorageDrawers;
    }

    static {
        DEFAULT_CHEST_RARITIES = ImmutableMap.copyOf(Settings.defaultChestRarities());
        CHEST_CONFIG_NAMES = Settings.chestConfigNames();
    }
}

