/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.minechem;

import com.scottkillen.mod.dendrology.TheMod;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import com.scottkillen.mod.koresample.compat.Integrator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Optional;
import minechem.api.RecipeAPI;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public final class MinechemMod
extends Integrator {
    private static final String MOD_ID = "minechem";
    private static final String MOD_NAME = "Minechem";

    private static void reportProgress(String species, String recipeType) {
        TheMod.logger().info("Added Minechem decomposer recipe for %s %s.", new Object[]{species, recipeType});
    }

    @Optional.Method(modid="minechem")
    private static void addDecomposerRecipes() {
        TheMod.logger().info("Adding Minechem decomposer recipes.", new Object[0]);
        for (OverworldTreeSpecies tree : OverworldTreeSpecies.values()) {
            String speciesName = tree.speciesName();
            ItemStack planks = new ItemStack((Block)tree.woodBlock(), 1, tree.woodSubBlockIndex());
            if (RecipeAPI.addDecompositionRecipe((ItemStack)planks, (String[])new String[]{"2 cellulose"})) {
                MinechemMod.reportProgress(speciesName, "planks");
            }
            ItemStack slab = new ItemStack((Block)tree.singleSlabBlock(), 1, tree.slabSubBlockIndex());
            if (RecipeAPI.addDecompositionRecipe((ItemStack)slab, (String[])new String[]{"2 cellulose"})) {
                MinechemMod.reportProgress(speciesName, "slab");
            }
            ItemStack sapling = new ItemStack((Block)tree.saplingBlock(), 1, tree.saplingSubBlockIndex());
            if (RecipeAPI.addDecompositionRecipe((ItemStack)sapling, (String[])new String[]{"cellulose"})) {
                MinechemMod.reportProgress(speciesName, "sapling");
            }
            ItemStack log = new ItemStack((Block)tree.logBlock(), 1, tree.logSubBlockIndex());
            if (RecipeAPI.addDecompositionRecipe((ItemStack)log, (String[])new String[]{"8 cellulose"})) {
                MinechemMod.reportProgress(speciesName, "log");
            }
            ItemStack leaves = new ItemStack((Block)tree.leavesBlock(), 1, tree.leavesSubBlockIndex());
            if (!RecipeAPI.addDecompositionRecipe((ItemStack)leaves, (String[])new String[]{"4 cellulose"})) continue;
            MinechemMod.reportProgress(speciesName, "leaves");
        }
    }

    public void doIntegration(LoaderState.ModState modState) {
        if (Loader.isModLoaded((String)MOD_ID) && Settings.INSTANCE.integrateMinechem() && modState == LoaderState.ModState.POSTINITIALIZED) {
            MinechemMod.addDecomposerRecipes();
        }
    }

    protected String modID() {
        return MOD_ID;
    }

    protected String modName() {
        return MOD_NAME;
    }
}

