/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.gardencollection;

import com.jaquadro.minecraft.gardencore.api.SaplingRegistry;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeFactory;
import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeRegistry;
import com.scottkillen.mod.dendrology.TheMod;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import com.scottkillen.mod.koresample.compat.Integrator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public final class GardenTreesMod
extends Integrator {
    private static final String MOD_ID = "GardenTrees";
    private static final String MOD_NAME = "GardenTrees";

    @Optional.Method(modid="GardenTrees")
    private static void registerSmallTrees() {
        TheMod.logger().info("Registering small trees with GardenTrees.", new Object[0]);
        SaplingRegistry saplingReg = SaplingRegistry.instance();
        for (OverworldTreeSpecies tree : OverworldTreeSpecies.values()) {
            String ornamentalTreeType = GardenTreesMod.getOrnametalTreeType(tree);
            OrnamentalTreeFactory factory = OrnamentalTreeRegistry.getTree((String)ornamentalTreeType);
            if (factory == null) continue;
            Item sapling = Item.func_150898_a((Block)tree.saplingBlock());
            int saplingMeta = tree.saplingSubBlockIndex();
            UniqueMetaIdentifier logBlock = saplingReg.getWoodForSapling(sapling, saplingMeta);
            UniqueMetaIdentifier leavesBlock = saplingReg.getLeavesForSapling(sapling, saplingMeta);
            if (logBlock == null && leavesBlock == null) continue;
            saplingReg.putExtendedData(sapling, saplingMeta, "sm_generator", (Object)factory.create(logBlock.getBlock(), logBlock.meta, leavesBlock.getBlock(), leavesBlock.meta));
        }
    }

    @Optional.Method(modid="GardenTrees")
    private static String getOrnametalTreeType(OverworldTreeSpecies tree) {
        switch (tree) {
            case CEDRUM: {
                return "small_spruce";
            }
            case DELNAS: {
                return "small_palm";
            }
            case EWCALY: {
                return "small_mahogany";
            }
            case HEKUR: {
                return "small_acacia";
            }
            case KIPARIS: {
                return "small_pine";
            }
            case KULIST: {
                return "large_oak";
            }
            case LATA: {
                return "small_canopy";
            }
            case NUCIS: {
                return "tall_small_oak";
            }
            case SALYX: {
                return "small_willow";
            }
            case TUOPA: {
                return "small_pine";
            }
        }
        return "small_oak";
    }

    public void doIntegration(LoaderState.ModState modState) {
        if (Loader.isModLoaded((String)"GardenTrees") && Settings.INSTANCE.integrateGardenStuff() && modState == LoaderState.ModState.INITIALIZED) {
            GardenTreesMod.registerSmallTrees();
        }
    }

    protected String modID() {
        return "GardenTrees";
    }

    protected String modName() {
        return "GardenTrees";
    }
}

