/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.scottkillen.mod.dendrology.block.ModBlocks;
import com.scottkillen.mod.dendrology.compat.chisel.ChiselMod;
import com.scottkillen.mod.dendrology.compat.forestry.ForestryMod;
import com.scottkillen.mod.dendrology.compat.gardencollection.GardenCoreMod;
import com.scottkillen.mod.dendrology.compat.gardencollection.GardenTreesMod;
import com.scottkillen.mod.dendrology.compat.mfr.MineFactoryReloadedMod;
import com.scottkillen.mod.dendrology.compat.minechem.MinechemMod;
import com.scottkillen.mod.dendrology.compat.storagedrawers.StorageDrawersMod;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.dendrology.content.ParcelManager;
import com.scottkillen.mod.dendrology.content.crafting.Crafter;
import com.scottkillen.mod.dendrology.content.crafting.OreDictHandler;
import com.scottkillen.mod.dendrology.content.crafting.Smelter;
import com.scottkillen.mod.dendrology.content.fuel.FuelHandler;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeGenerator;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import com.scottkillen.mod.dendrology.item.ModItems;
import com.scottkillen.mod.dendrology.proxy.Proxy;
import com.scottkillen.mod.koresample.common.util.log.Logger;
import com.scottkillen.mod.koresample.compat.Integrates;
import com.scottkillen.mod.koresample.config.ConfigEventHandler;
import com.scottkillen.mod.koresample.config.ConfigSyncable;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="dendrology", name="Ancient Trees", version="1.7.10-1.6.2", useMetadata=true, guiFactory="com.scottkillen.mod.dendrology.config.client.ModGuiFactory")
public final class TheMod {
    public static final String MOD_ID = "dendrology";
    static final String MOD_NAME = "Ancient Trees";
    static final String MOD_VERSION = "1.7.10-1.6.2";
    static final String MOD_GUI_FACTORY = "com.scottkillen.mod.dendrology.config.client.ModGuiFactory";
    private static final String RESOURCE_PREFIX = "dendrology".toLowerCase() + ':';
    @Mod.Instance(value="dendrology")
    public static TheMod INSTANCE;
    private final CreativeTabs creativeTab = new CreativeTabs("dendrology".toLowerCase()){
        private final OverworldTreeSpecies ICON;
        {
            this.ICON = OverworldTreeSpecies.PORFFOR;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            return new ItemStack((Block)this.ICON.saplingBlock(), 1, this.ICON.saplingSubBlockIndex());
        }

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            return null;
        }
    };
    private final List<Integrates> integrators = Lists.newArrayList();
    private Optional<ConfigEventHandler> configEventHandler = Optional.absent();

    public static String getResourcePrefix() {
        return RESOURCE_PREFIX;
    }

    public static Logger logger() {
        return Logger.forMod((String)MOD_ID);
    }

    private void initIntegrators() {
        Logger.forMod((String)MOD_ID).info("Preparing integration with other mods.", new Object[0]);
        this.integrators.add((Integrates)new MinechemMod());
        this.integrators.add((Integrates)new ForestryMod());
        this.integrators.add((Integrates)new GardenCoreMod());
        this.integrators.add((Integrates)new GardenTreesMod());
        this.integrators.add((Integrates)new ChiselMod());
        this.integrators.add((Integrates)new MineFactoryReloadedMod());
        this.integrators.add((Integrates)new StorageDrawersMod());
    }

    public Configuration configuration() {
        if (this.configEventHandler.isPresent()) {
            return ((ConfigEventHandler)this.configEventHandler.get()).configuration();
        }
        return new Configuration();
    }

    public CreativeTabs creativeTab() {
        return this.creativeTab;
    }

    private void integrateMods(LoaderState.ModState modState) {
        for (Integrates integrator : this.integrators) {
            integrator.integrate(modState);
        }
    }

    @Mod.EventHandler
    public void onFMLPreInitialization(FMLPreInitializationEvent event) {
        this.configEventHandler = Optional.of((Object)new ConfigEventHandler(MOD_ID, event.getSuggestedConfigurationFile(), (ConfigSyncable)Settings.INSTANCE, "2"));
        ((ConfigEventHandler)this.configEventHandler.get()).activate();
        new ModBlocks().loadContent();
        new ModItems().loadContent();
        this.initIntegrators();
        this.integrateMods(event.getModState());
    }

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        Logger.forMod((String)MOD_ID).info("Adding recipes.", new Object[0]);
        new OreDictHandler().registerBlocksWithOreDictinary();
        new Crafter().writeRecipes();
        new Smelter().registerSmeltings();
        this.integrateMods(event.getModState());
    }

    @Mod.EventHandler
    public void onFMLPostInitialization(FMLPostInitializationEvent event) {
        Proxy.render.postInit();
        FuelHandler.postInit();
        this.integrateMods(event.getModState());
        this.integrators.clear();
        ParcelManager.INSTANCE.init();
        new OverworldTreeGenerator().install();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("creativeTab", (Object)this.creativeTab).add("integrators", this.integrators).add("configEventHandler", this.configEventHandler).toString();
    }
}

