/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.replacement.ReplacementTool;
import net.malisis.doors.door.renderer.DoorRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraftforge.common.util.ForgeDirection;

public class TrapDoorRenderer
extends DoorRenderer {
    RenderParameters rpTop;

    @Override
    protected void initialize() {
        Cube s = new Cube();
        s.setSize(1.0f, 0.1875f, 1.0f);
        s.interpolateUV();
        this.model = new MalisisModel();
        this.model.addShape("shape", (Shape)s);
        this.model.storeState();
        s.getFace((String)Face.nameFromDirection((ForgeDirection)ForgeDirection.UP)).getParameters().calculateAOColor.set((Object)true);
        this.initParams();
    }

    @Override
    protected void setup() {
        this.model.resetState();
        float angle = 0.0f;
        if (this.direction == 1) {
            angle = 180.0f;
        } else if (this.direction == 2) {
            angle = 90.0f;
        } else if (this.direction == 3) {
            angle = 270.0f;
        }
        this.model.rotate(angle, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.topBlock) {
            this.model.translate(0.0f, 0.8125f, 0.0f);
        }
    }

    @Override
    protected void renderTileEntity() {
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        this.setup();
        if (this.tileEntity.getMovement() != null) {
            Animation[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        Shape s = this.model.getShape("shape");
        Face f = s.getFace(Face.nameFromDirection((ForgeDirection)ForgeDirection.UP));
        s.applyMatrix();
        f.getParameters().aoMatrix.set((Object)f.calculateAoMatrix(ForgeDirection.UP));
        this.model.render((MalisisRenderer)this, this.rp);
    }

    @Override
    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && dbp.func_73109_c() == this.y && dbp.func_73108_d() == this.z;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        renderer.func_147800_a(ReplacementTool.orignalBlock((Block)block), 0, 1.0f);
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

