/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Scale;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SpinningAroundDoorMovement
implements IDoorMovement {
    private Rotation rotBot = new Rotation(720.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotTop = new Rotation(720.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotBot2 = new Rotation(-720.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotTop2 = new Rotation(-720.0f).aroundAxis(0.0f, 0.0f, 1.0f).offset(0.0f, 1.0f, 0.0f);
    private Scale scaleBot = new Scale(0.0f, 0.0f, 0.0f);
    private Scale scaleTop = new Scale(0.0f, 0.0f, 0.0f).offset(0.0f, 1.0f, 0.0f);

    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        if (opened && type != BoundingBoxType.RAYTRACE) {
            return null;
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
        }
        if (dir == 3) {
            z = 0.8125f;
        }
        if (dir == 0) {
            X = 0.1875f;
        }
        if (dir == 2) {
            x = 0.8125f;
        }
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        boolean doubleDoor = tileEntity.getDoubleDoor() != null;
        boolean closed = tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED;
        int ot = tileEntity.getDescriptor().getOpeningTime();
        float offsetX = doubleDoor ? (tileEntity.isReversed() ? 0.5f : -0.5f) : 0.0f;
        this.rotBot.offset(offsetX, 0.5f, 0.0f);
        this.rotBot.reversed(closed);
        this.rotBot.forTicks(ot);
        this.rotBot2.forTicks(ot);
        this.rotBot2.reversed(closed);
        this.rotTop.offset(offsetX, 0.5f, 0.0f);
        this.rotTop.reversed(closed);
        this.rotTop.forTicks(ot);
        this.rotTop2.forTicks(ot);
        this.rotTop2.reversed(closed);
        this.scaleBot.reversed(closed);
        this.scaleBot.forTicks(ot);
        this.scaleTop.reversed(closed);
        this.scaleTop.forTicks(ot);
        ParallelTransformation bot = new ParallelTransformation(new Transformation[]{this.rotBot, this.rotBot2, this.scaleBot});
        ParallelTransformation top = new ParallelTransformation(new Transformation[]{this.rotTop, this.rotTop2, this.scaleTop});
        return new Animation[]{new Animation((ITransformable)model.getShape("bottom"), (Transformation)bot), new Animation((ITransformable)model.getShape("top"), (Transformation)top)};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

