/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class Rotating4WaysMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        boolean reversed = tileEntity.isReversed();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (!opened) {
            if (dir == 1) {
                Z = 0.1875f;
            } else if (dir == 0) {
                X = 0.1875f;
            } else if (dir == 2) {
                x = 0.8125f;
            } else if (dir == 3) {
                z = 0.8125f;
            }
        } else if (topBlock == !reversed) {
            if (topBlock) {
                y = 0.8125f;
            } else {
                Y = type == BoundingBoxType.SELECTION ? 0.1875f : 0.0f;
            }
        } else if (dir == 1 && !reversed || dir == 3 && reversed) {
            x = 0.8125f;
        } else if (dir == 3 && !reversed || dir == 1 && reversed) {
            X = 0.1875f;
        } else if (dir == 2 && !reversed || dir == 0 && reversed) {
            z = 0.8125f;
        } else if (dir == 0 && !reversed || dir == 2 && reversed) {
            Z = 0.1875f;
        }
        if (type == BoundingBoxType.SELECTION && !opened) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float angle = 90.0f;
        float hingeX = 0.40625f;
        float hingeY = -0.40625f;
        float hingeZ = -0.40625f;
        boolean axisX = false;
        boolean axisY = false;
        if (topBlock) {
            angle = -angle;
            hingeY = 1.0f - hingeY;
        }
        if (tileEntity.isReversed()) {
            hingeX = -hingeX;
        }
        if (topBlock != tileEntity.isReversed()) {
            axisX = true;
        } else {
            axisY = true;
        }
        Rotation rotation = new Rotation(angle);
        rotation.aroundAxis((float)axisX, (float)axisY, 0.0f).offset(hingeX, hingeY, hingeZ);
        rotation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        rotation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return rotation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model.getShape("top"), this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("bottom"), this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

