/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class CurtainMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        boolean reversed = tileEntity.isReversed();
        float left = -0.8125f;
        float right = 0.8125f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
            if (opened) {
                if (reversed) {
                    X += left;
                } else {
                    x += right;
                }
            }
        }
        if (dir == 3) {
            z = 0.8125f;
            if (opened) {
                if (reversed) {
                    x += right;
                } else {
                    X += left;
                }
            }
        }
        if (dir == 0) {
            X = 0.1875f;
            if (opened) {
                if (reversed) {
                    z += right;
                } else {
                    Z += left;
                }
            }
        }
        if (dir == 2) {
            x = 0.8125f;
            if (opened) {
                if (reversed) {
                    Z += left;
                } else {
                    z += right;
                }
            }
        }
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        float x = 0.8125f;
        String dir = "west";
        ForgeDirection fd = ForgeDirection.WEST;
        if (tileEntity.isReversed()) {
            x = -0.8125f;
            dir = "east";
            fd = ForgeDirection.EAST;
        }
        Translation translation = new Translation(x, 0.0f, 0.0f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        Shape top = model.getShape("top");
        Shape bottom = model.getShape("bottom");
        top.enableMergedVertexes();
        bottom.enableMergedVertexes();
        List vertexes = top.getMergedVertexes(new String[]{"bottom", dir});
        vertexes.addAll(bottom.getMergedVertexes(fd));
        Animation[] anims = new Animation[vertexes.size()];
        int i = 0;
        for (MergedVertex mv : vertexes) {
            anims[i++] = new Animation((ITransformable)mv, (Transformation)translation);
        }
        return anims;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

