/*
 * Decompiled with CFR 0.152.
 */
package igwmod.api;

import igwmod.api.IRecipeIntegrator;
import igwmod.api.ITextInterpreter;
import igwmod.gui.GuiWiki;
import igwmod.gui.tabs.IWikiTab;
import igwmod.gui.tabs.ServerWikiTab;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class WikiRegistry {
    private static List<Map.Entry<String, ItemStack>> itemAndBlockPageEntries = new ArrayList<Map.Entry<String, ItemStack>>();
    private static Map<Class<? extends Entity>, String> entityPageEntries = new HashMap<Class<? extends Entity>, String>();
    public static List<IRecipeIntegrator> recipeIntegrators = new ArrayList<IRecipeIntegrator>();
    public static List<ITextInterpreter> textInterpreters = new ArrayList<ITextInterpreter>();

    public static void registerWikiTab(IWikiTab tab) {
        if (tab instanceof ServerWikiTab) {
            for (IWikiTab t : GuiWiki.wikiTabs) {
                if (!(t instanceof ServerWikiTab)) continue;
                GuiWiki.wikiTabs.remove(t);
                break;
            }
            GuiWiki.wikiTabs.add(0, tab);
        } else {
            GuiWiki.wikiTabs.add(tab);
        }
    }

    public static void registerBlockAndItemPageEntry(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            throw new IllegalArgumentException("Can't register null items");
        }
        WikiRegistry.registerBlockAndItemPageEntry(stack, stack.func_77977_a().replace("tile.", "block/").replace("item.", "item/"));
    }

    public static void registerBlockAndItemPageEntry(Block block, String page) {
        WikiRegistry.registerBlockAndItemPageEntry(new ItemStack(block, 1, Short.MAX_VALUE), page);
    }

    public static void registerBlockAndItemPageEntry(Item item, String page) {
        WikiRegistry.registerBlockAndItemPageEntry(new ItemStack(item, 1, Short.MAX_VALUE), page);
    }

    public static void registerBlockAndItemPageEntry(ItemStack stack, String page) {
        itemAndBlockPageEntries.add(new AbstractMap.SimpleEntry<String, ItemStack>(page, stack));
    }

    public static void registerEntityPageEntry(Class<? extends Entity> entityClass) {
        WikiRegistry.registerEntityPageEntry(entityClass, "entity/" + EntityList.field_75626_c.get(entityClass));
    }

    public static void registerEntityPageEntry(Class<? extends Entity> entityClass, String page) {
        entityPageEntries.put(entityClass, page);
    }

    public static void registerRecipeIntegrator(IRecipeIntegrator recipeIntegrator) {
        recipeIntegrators.add(recipeIntegrator);
    }

    public static void registerTextInterpreter(ITextInterpreter textInterpreter) {
        textInterpreters.add(textInterpreter);
    }

    public static String getPageForItemStack(ItemStack stack) {
        for (Map.Entry<String, ItemStack> entry : itemAndBlockPageEntries) {
            if (!entry.getValue().func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)entry.getValue(), (ItemStack)stack)) continue;
            return entry.getKey();
        }
        for (Map.Entry<String, ItemStack> entry : itemAndBlockPageEntries) {
            if (!OreDictionary.itemMatches((ItemStack)entry.getValue(), (ItemStack)stack, (boolean)false)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getPageForEntityClass(Class<? extends Entity> entityClass) {
        return entityPageEntries.get(entityClass);
    }

    public static List<ItemStack> getItemAndBlockPageEntries() {
        ArrayList<ItemStack> entries = new ArrayList<ItemStack>();
        for (Map.Entry<String, ItemStack> entry : itemAndBlockPageEntries) {
            if (entry.getValue().func_77960_j() == Short.MAX_VALUE) {
                entry.getValue().func_77973_b().func_150895_a(entry.getValue().func_77973_b(), CreativeTabs.field_78027_g, entries);
                continue;
            }
            entries.add(entry.getValue());
        }
        return entries;
    }

    public static List<Class<? extends Entity>> getEntityPageEntries() {
        ArrayList<Class<? extends Entity>> entries = new ArrayList<Class<? extends Entity>>();
        for (Class<? extends Entity> entityClass : entityPageEntries.keySet()) {
            entries.add(entityClass);
        }
        return entries;
    }
}

