/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import openperipheral.adapter.method.Argument;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.converter.IConverter;

public class OptionalArgument
extends Argument {
    public OptionalArgument(String name, String description, ArgType luaType, TypeToken<?> javaType, int javaArgIndex) {
        super(name, description, luaType, javaType, javaArgIndex);
    }

    @Override
    protected TypeToken<?> getArgType(TypeToken<?> javaArgClass) {
        Preconditions.checkArgument((!javaArgClass.isPrimitive() ? 1 : 0) != 0, (Object)"Optional arguments can't be primitive");
        return super.getArgType(javaArgClass);
    }

    @Override
    public Object convert(IConverter converter, Iterator<Object> args) {
        if (!args.hasNext()) {
            return null;
        }
        Object arg = args.next();
        return arg != null ? this.convertSingleArg(converter, arg) : null;
    }

    @Override
    public String toString() {
        return this.name + "?";
    }

    @Override
    public boolean optional() {
        return true;
    }
}

