/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import openperipheral.adapter.method.Argument;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.converter.IConverter;

public class NullableArgument
extends Argument {
    public NullableArgument(String name, String description, ArgType luaType, TypeToken<?> javaType, int javaArgIndex) {
        super(name, description, luaType, javaType, javaArgIndex);
    }

    @Override
    protected TypeToken<?> getArgType(TypeToken<?> javaArgClass) {
        Preconditions.checkArgument((!javaArgClass.isPrimitive() ? 1 : 0) != 0, (Object)"Nullable arguments can't be primitive");
        return super.getArgType(javaArgClass);
    }

    @Override
    public Object convert(IConverter converter, Iterator<Object> args) {
        Preconditions.checkArgument((boolean)args.hasNext(), (String)"Not enough arguments, first missing: %s", (Object[])new Object[]{this.name});
        Object arg = args.next();
        return this.convertSingleArg(converter, arg);
    }

    @Override
    public boolean nullable() {
        return true;
    }
}

