/*
 * Decompiled with CFR 0.152.
 */
package ec3.utils.common;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.DummyDistance;
import DummyCore.Utils.DummyPacketHandler;
import DummyCore.Utils.DummyPacketIMSG;
import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import DummyCore.Utils.Notifier;
import baubles.api.BaublesApi;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import ec3.api.ApiCore;
import ec3.api.EnumStructureType;
import ec3.api.IItemAllowsSeeingMRUCU;
import ec3.api.IMRUPressence;
import ec3.api.IMRUStorage;
import ec3.api.ISpell;
import ec3.api.ITEHasMRU;
import ec3.api.IWorldEvent;
import ec3.api.MagicalAssemblerRecipes;
import ec3.api.MagicianTableRecipe;
import ec3.api.MagicianTableRecipes;
import ec3.api.RadiatingChamberRecipe;
import ec3.api.RadiatingChamberRecipes;
import ec3.api.ShapedFurnaceRecipe;
import ec3.api.WorldEventLibrary;
import ec3.common.entity.EntityMRUPresence;
import ec3.common.inventory.InventoryMagicFilter;
import ec3.common.item.ItemBaublesWearable;
import ec3.common.item.ItemBoundGem;
import ec3.common.item.ItemFilter;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.registry.PotionRegistry;
import ec3.common.tile.TileMRUReactor;
import ec3.common.tile.TileRayTower;
import ec3.network.PacketNBT;
import ec3.utils.common.PlayerGenericData;
import ec3.utils.common.ScheduledServerAction;
import ec3.utils.common.ServerToClientSyncAction;
import ec3.utils.common.SpellEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ECUtils {
    public static Hashtable<EnumStructureType, List<Block>> allowedBlocks = new Hashtable();
    public static Hashtable<String, Float> mruResistance = new Hashtable();
    public static Hashtable<String, Boolean> ignoreMeta = new Hashtable();
    public static List<SpellEntry> spells = new ArrayList<SpellEntry>();
    public static Hashtable<Object, Integer> inPortalTime = new Hashtable();
    public static Hashtable<String, PlayerGenericData> playerDataTable = new Hashtable();
    private static final List<ScheduledServerAction> actions = new ArrayList<ScheduledServerAction>();
    public static NBTTagCompound ec3WorldTag = new NBTTagCompound();
    public static GameProfile EC3FakePlayerProfile = new GameProfile(UUID.fromString("5cd89d0b-e9ba-0000-89f4-b5dbb05963da"), "[EC3]");

    public static void requestSync(EntityPlayer e) {
        NBTTagCompound tag = new NBTTagCompound();
        ECUtils.getData(e).writeToNBTTagCompound(tag);
        PacketNBT pkt = new PacketNBT(tag).setID(0);
        EssentialCraftCore.network.sendTo((IMessage)pkt, (EntityPlayerMP)e);
    }

    public static PlayerGenericData getData(EntityPlayer e) {
        return ECUtils.playerDataExists(e) ? playerDataTable.get(e.func_70005_c_()) : ECUtils.createPlayerData(e);
    }

    public static PlayerGenericData getData(String username) {
        return ECUtils.playerDataExists(username) ? playerDataTable.get(username) : null;
    }

    public static boolean playerDataExists(String username) {
        return playerDataTable.containsKey(username);
    }

    public static boolean playerDataExists(EntityPlayer e) {
        return playerDataTable.containsKey(e.func_70005_c_());
    }

    public static PlayerGenericData createPlayerData(EntityPlayer e) {
        PlayerGenericData dat = new PlayerGenericData(e);
        playerDataTable.put(e.func_70005_c_(), dat);
        return dat;
    }

    public static void changePlayerPositionOnClient(EntityPlayer e) {
        if (!e.field_70170_p.field_72995_K) {
            DummyData aaa = new DummyData("x", (Object)e.field_70165_t);
            DummyData aab = new DummyData("y", (Object)e.field_70163_u);
            DummyData aac = new DummyData("z", (Object)e.field_70161_v);
            DummyData aad = new DummyData("yaw", (Object)Float.valueOf(e.field_70177_z));
            DummyData aae = new DummyData("pitch", (Object)Float.valueOf(e.field_70125_A));
            DummyPacketIMSG pkt = new DummyPacketIMSG("||mod:ec3.player.position" + aaa + "" + aab + "" + aac + "" + aad + "" + aae);
            DummyPacketHandler.sendToPlayer((DummyPacketIMSG)pkt, (EntityPlayerMP)((EntityPlayerMP)e));
        }
    }

    public static void playSoundToAllNearby(double x, double y, double z, String sound, float volume, float pitch, double radius, int dim) {
        DummyData aaa = new DummyData("x", (Object)x);
        DummyData aab = new DummyData("y", (Object)y);
        DummyData aac = new DummyData("z", (Object)z);
        DummyData aad = new DummyData("vol", (Object)Float.valueOf(volume));
        DummyData aae = new DummyData("pitch", (Object)Float.valueOf(pitch));
        DummyData aaf = new DummyData("sound", sound);
        DummyPacketIMSG pkt = new DummyPacketIMSG("||mod:ec3.sound" + aaa + "" + aab + "" + aac + "" + aad + "" + aae + "" + aaf);
        DummyPacketHandler.sendToAllAround((DummyPacketIMSG)pkt, (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(dim, x, y, z, radius));
    }

    public static void readOrCreatePlayerData(EntityPlayer e, NBTTagCompound tag) {
        if (!playerDataTable.containsKey(e.func_70005_c_())) {
            PlayerGenericData dat = new PlayerGenericData(e);
            playerDataTable.put(e.func_70005_c_(), dat);
        }
        playerDataTable.get(e.func_70005_c_()).readFromNBTTagCompound(tag);
    }

    public static void createNBTTag(ItemStack stack) {
        if (stack.func_77942_o()) {
            return;
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        stack.func_77982_d(itemTag);
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        ECUtils.createNBTTag(stack);
        return stack.func_77978_p();
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static void initMRUTag(ItemStack stack, int maxMRU) {
        if (maxMRU == 0) {
            try {
                Class<?> itemClz = stack.func_77973_b().getClass();
                Field f = itemClz.getField("maxMRU");
                f.setInt(stack.func_77973_b(), 5000);
                maxMRU = 5000;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ECUtils.getStackTag(stack).func_74768_a("maxMRU", maxMRU);
        if (!ECUtils.getStackTag(stack).func_74764_b("mru")) {
            ECUtils.getStackTag(stack).func_74768_a("mru", 0);
        }
    }

    public static void registerBlockResistance(Block blk, int meta, float resistance) {
        DummyData dt = new DummyData(blk.func_149739_a(), (Object)meta);
        ignoreMeta.put(blk.func_149739_a(), meta == -1);
        mruResistance.put(dt.toString(), Float.valueOf(resistance));
    }

    public static boolean canPlayerSeeMRU(EntityPlayer player) {
        ItemStack currentItem = player.func_71045_bC();
        ItemStack headwear = player.func_71124_b(4);
        return currentItem != null && ApiCore.allowsSeeingMRU.contains(currentItem.func_77973_b()) || headwear != null && ApiCore.allowsSeeingMRU.contains(headwear.func_77973_b()) || currentItem != null && currentItem.func_77973_b() instanceof IItemAllowsSeeingMRUCU || headwear != null && headwear.func_77973_b() instanceof IItemAllowsSeeingMRUCU;
    }

    public static boolean canSpellWork(ItemStack spell, ISpell spell_2, int ubmru, int attune, EntityPlayer player) {
        NBTTagCompound tag = MiscUtils.getStackTag((ItemStack)spell);
        return tag.func_74764_b("cooldown") ? tag.func_74762_e("cooldown") <= 0 && ubmru >= spell_2.getUBMRURequired(spell) && (spell_2.getAttunementRequired(spell) == -1 || spell_2.getAttunementRequired(spell) == attune) : ubmru >= spell_2.getUBMRURequired(spell) && (spell_2.getAttunementRequired(spell) == -1 || spell_2.getAttunementRequired(spell) == attune);
    }

    public static boolean tryToDecreaseMRUInStorage(EntityPlayer player, int amount) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IInventory _gen_var_0_0 = BaublesApi.getBaubles((EntityPlayer)player);
        for (int _gen_int_0 = 0; _gen_int_0 < _gen_var_0_0.func_70302_i_(); ++_gen_int_0) {
            ItemStack _gen_var_1 = _gen_var_0_0.func_70301_a(_gen_int_0);
            if (_gen_var_1 == null || !(_gen_var_1.func_77973_b() instanceof IMRUStorage) || !((IMRUStorage)_gen_var_1.func_77973_b()).setMRU(_gen_var_1, amount)) continue;
            return true;
        }
        InventoryPlayer _gen_var_0 = player.field_71071_by;
        for (int _gen_int_0 = 0; _gen_int_0 < _gen_var_0.field_70462_a.length; ++_gen_int_0) {
            ItemStack _gen_var_1 = _gen_var_0.field_70462_a[_gen_int_0];
            if (_gen_var_1 == null || !(_gen_var_1.func_77973_b() instanceof IMRUStorage) || !((IMRUStorage)_gen_var_1.func_77973_b()).setMRU(_gen_var_1, amount)) continue;
            return true;
        }
        return false;
    }

    public static void saveMRUState(ITEHasMRU tile, NBTTagCompound saveTag) {
        saveTag.func_74776_a("mru", (float)tile.getMRU());
        saveTag.func_74776_a("maxMRU", (float)tile.getMaxMRU());
        saveTag.func_74776_a("balance", tile.getBalance());
        saveTag.func_74778_a("uuid", tile.getUUID().toString());
    }

    public static void loadMRUState(ITEHasMRU tile, NBTTagCompound loadTag) {
        tile.setBalance(loadTag.func_74760_g("balance"));
        tile.setMRU((int)loadTag.func_74760_g("mru"));
        tile.setMaxMRU(loadTag.func_74760_g("maxMRU"));
    }

    public static void createMRUCUAt(World w, Coord3D c, int MRU, float balance, boolean flag, boolean canAlwaysStay) {
        EntityMRUPresence mru = new EntityMRUPresence(w);
        mru.func_70080_a(c.x, c.y, c.z, 0.0f, 0.0f);
        if (!w.field_72995_K) {
            mru.setMRU(MRU);
            mru.setBalance(balance);
            mru.setFlag(flag);
            mru.setAlwaysStay(canAlwaysStay);
            w.func_72838_d((Entity)mru);
        }
    }

    public static void mruIn(TileEntity tile, int slotNum) {
        if (tile instanceof IInventory && tile instanceof ITEHasMRU) {
            ITEHasMRU t;
            ItemStack s;
            int[] o;
            IInventory inv = (IInventory)tile;
            ITEHasMRU mrut = (ITEHasMRU)tile;
            if (inv.func_70301_a(slotNum) != null && inv.func_70301_a(slotNum).func_77973_b() instanceof ItemBoundGem && inv.func_70301_a(slotNum).func_77978_p() != null && MathUtils.getDifference((float)tile.field_145851_c, (float)(o = ItemBoundGem.getCoords(s = inv.func_70301_a(slotNum)))[0]) <= 16.0f && MathUtils.getDifference((float)tile.field_145848_d, (float)o[1]) <= 16.0f && MathUtils.getDifference((float)tile.field_145849_e, (float)o[2]) <= 16.0f && tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) != null && tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof ITEHasMRU && (t = (ITEHasMRU)tile.func_145831_w().func_147438_o(o[0], o[1], o[2])) != tile && t != null && !tile.func_145831_w().field_72995_K && mrut.getMRU() < mrut.getMaxMRU()) {
                int mru = t.getMRU();
                if (mru > mrut.getMaxMRU() - mrut.getMRU()) {
                    t.setMRU(mru - (mrut.getMaxMRU() - mrut.getMRU()));
                    mrut.setMRU(mrut.getMaxMRU());
                } else {
                    t.setMRU(0);
                    mrut.setMRU(mrut.getMRU() + mru);
                }
                mrut.setBalance((mrut.getBalance() + t.getBalance()) / 2.0f);
            }
            if (mrut.getMRU() < 0) {
                mrut.setMRU(0);
            }
        }
    }

    public static boolean increaseCorruptionAt(World w, float x, float y, float z, int amount) {
        Coord3D c = new Coord3D(x, y, z);
        try {
            EntityMRUPresence mru = (EntityMRUPresence)ECUtils.getClosestMRUCU(w, c, 32);
            if (mru != null) {
                if (!w.field_72995_K) {
                    mru.setMRU(mru.getMRU() + amount);
                }
            } else {
                ECUtils.createMRUCUAt(w, c, amount, 1.0f + MathUtils.randomFloat((Random)w.field_73012_v), true, false);
            }
            List players = w.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0f), (double)(y + 1.0f), (double)(z + 1.0f)).func_72314_b(6.0, 3.0, 6.0));
            for (int i = 0; i < players.size(); ++i) {
                if (w.field_72995_K) continue;
                ECUtils.calculateAndAddMRUCorruptionPE((EntityPlayer)players.get(i));
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void calculateAndAddMRUCorruptionPE(EntityPlayer player) {
        boolean hasEffect;
        boolean bl = hasEffect = player.func_70660_b((Potion)PotionRegistry.mruCorruptionPotion) != null;
        if (hasEffect) {
            int currentDuration = player.func_70660_b((Potion)PotionRegistry.mruCorruptionPotion).func_76459_b();
            int newDuration = currentDuration + 2;
            int newModifier = currentDuration / 2000;
            player.func_82170_o(PotionRegistry.mruCorruptionPotion.field_76415_H);
            player.func_70690_d(new PotionEffect(PotionRegistry.mruCorruptionPotion.field_76415_H, newDuration, newModifier));
        } else {
            player.func_70690_d(new PotionEffect(PotionRegistry.mruCorruptionPotion.field_76415_H, 200, 0));
        }
    }

    public static void calculateAndAddPE(EntityPlayer player, Potion potion, int index, int index2) {
        boolean hasEffect;
        boolean bl = hasEffect = player.func_70660_b(potion) != null;
        if (hasEffect) {
            int currentDuration = player.func_70660_b(potion).func_76459_b();
            int newDuration = currentDuration + index2;
            int newModifier = currentDuration / index;
            player.func_82170_o(potion.field_76415_H);
            player.func_70690_d(new PotionEffect(potion.field_76415_H, newDuration, newModifier));
        } else {
            player.func_70690_d(new PotionEffect(potion.field_76415_H, index2, 0));
        }
    }

    public static IMRUPressence getClosestMRUCU(World w, Coord3D c, int radius) {
        List l = w.func_72872_a(IMRUPressence.class, AxisAlignedBB.func_72330_a((double)((double)c.x - 0.5), (double)((double)c.y - 0.5), (double)((double)c.z - 0.5), (double)((double)c.x + 0.5), (double)((double)c.y + 0.5), (double)((double)c.z + 0.5)).func_72314_b((double)radius, (double)(radius / 2), (double)radius));
        IMRUPressence ret = null;
        if (!l.isEmpty()) {
            if (!(l.get(0) instanceof EntityMRUPresence)) {
                ret = (IMRUPressence)l.get(0);
            } else {
                List actualList = l;
                double currentDistance = 0.0;
                double dominatingDistance = 0.0;
                int dominatingIndex = 0;
                Coord3D main = new Coord3D(c.x, c.y, c.z);
                for (int i = 0; i < actualList.size(); ++i) {
                    if (!(actualList.get(i) instanceof EntityMRUPresence)) continue;
                    EntityMRUPresence pressence = (EntityMRUPresence)EntityMRUPresence.class.cast(actualList.get(i));
                    Coord3D current = new Coord3D(pressence.field_70165_t, pressence.field_70163_u, pressence.field_70161_v);
                    DummyDistance dist = new DummyDistance(main, current);
                    if (i == 0) {
                        dominatingIndex = i;
                        dominatingDistance = dist.getDistance();
                        continue;
                    }
                    currentDistance = dist.getDistance();
                    if (!(currentDistance < dominatingDistance)) continue;
                    dominatingIndex = i;
                    dominatingDistance = dist.getDistance();
                }
                ret = (IMRUPressence)actualList.get(dominatingIndex);
            }
        }
        return ret;
    }

    public static void spawnMRUParticles(TileEntity tile, int slotNum) {
        ItemStack s;
        int[] o;
        IInventory inv = (IInventory)tile;
        if (tile.func_145831_w().field_72995_K && inv.func_70301_a(slotNum) != null && inv.func_70301_a(slotNum).func_77973_b() instanceof ItemBoundGem && inv.func_70301_a(slotNum).func_77978_p() != null && MathUtils.getDifference((float)tile.field_145851_c, (float)(o = ItemBoundGem.getCoords(s = inv.func_70301_a(slotNum)))[0]) <= 16.0f && MathUtils.getDifference((float)tile.field_145848_d, (float)o[1]) <= 16.0f && MathUtils.getDifference((float)tile.field_145849_e, (float)o[2]) <= 16.0f && tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) != null && tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof ITEHasMRU) {
            float balance = ((ITEHasMRU)tile.func_145831_w().func_147438_o(o[0], o[1], o[2])).getBalance();
            float colorRRender = 0.0f;
            float colorGRender = 1.0f;
            float colorBRender = 1.0f;
            float colorRNormal = 0.0f;
            float colorGNormal = 1.0f;
            float colorBNormal = 1.0f;
            float colorRChaos = 1.0f;
            float colorGChaos = 0.0f;
            float colorBChaos = 0.0f;
            float colorRFrozen = 0.0f;
            float colorGFrozen = 0.0f;
            float colorBFrozen = 1.0f;
            if (balance != 1.0f) {
                float diff;
                if (balance < 1.0f) {
                    diff = balance;
                    if (diff < 0.01f) {
                        diff = 0.0f;
                    }
                    colorRRender = colorRNormal * diff + colorRFrozen * (1.0f - diff);
                    colorGRender = colorGNormal * diff + colorGFrozen * (1.0f - diff);
                    colorBRender = colorBNormal * diff + colorBFrozen * (1.0f - diff);
                }
                if (balance > 1.0f) {
                    diff = 2.0f - balance;
                    if (diff < 0.01f) {
                        diff = 0.0f;
                    }
                    colorRRender = colorRNormal * diff + colorRChaos * (1.0f - diff);
                    colorGRender = colorGNormal * diff + colorGChaos * (1.0f - diff);
                    colorBRender = colorBNormal * diff + colorBChaos * (1.0f - diff);
                }
            }
            if (tile instanceof TileRayTower) {
                if (tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof TileRayTower) {
                    EssentialCraftCore.proxy.MRUFX((float)((double)o[0] + 0.5), (float)((double)o[1] + 1.85), (float)((double)o[2] + 0.5), tile.field_145851_c - o[0], (double)(tile.field_145848_d - o[1]) + 0.25, tile.field_145849_e - o[2], colorRRender, colorGRender, colorBRender);
                } else if (tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof TileMRUReactor) {
                    EssentialCraftCore.proxy.MRUFX((float)((double)o[0] + 0.5), (float)((double)o[1] + 1.1), (float)((double)o[2] + 0.5), tile.field_145851_c - o[0], (double)(tile.field_145848_d - o[1]) + 0.8, tile.field_145849_e - o[2], colorRRender, colorGRender, colorBRender);
                } else {
                    EssentialCraftCore.proxy.MRUFX((float)((double)o[0] + 0.5), (float)((double)o[1] + 0.5), (float)((double)o[2] + 0.5), tile.field_145851_c - o[0], (double)(tile.field_145848_d - o[1]) + 1.5, tile.field_145849_e - o[2], colorRRender, colorGRender, colorBRender);
                }
            } else if (tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof TileRayTower) {
                EssentialCraftCore.proxy.MRUFX((float)((double)o[0] + 0.5), (float)((double)o[1] + 1.85), (float)((double)o[2] + 0.5), tile.field_145851_c - o[0], (double)(tile.field_145848_d - o[1]) - 1.5, tile.field_145849_e - o[2], colorRRender, colorGRender, colorBRender);
            } else if (tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof TileMRUReactor) {
                EssentialCraftCore.proxy.MRUFX((float)((double)o[0] + 0.5), (float)((double)o[1] + 1.1), (float)((double)o[2] + 0.5), tile.field_145851_c - o[0], (double)(tile.field_145848_d - o[1]) - 0.6, tile.field_145849_e - o[2], colorRRender, colorGRender, colorBRender);
            } else {
                EssentialCraftCore.proxy.MRUFX((float)((double)o[0] + 0.5), (float)((double)o[1] + 0.5), (float)((double)o[2] + 0.5), tile.field_145851_c - o[0], tile.field_145848_d - o[1], tile.field_145849_e - o[2], colorRRender, colorGRender, colorBRender);
            }
        }
    }

    public static float getGenResistance(int index, EntityPlayer p) {
        float retFlt;
        float resistance = 0.0f;
        for (int i = 0; i < p.field_71071_by.field_70460_b.length; ++i) {
            Item itm;
            ItemStack armorStk = p.field_71071_by.field_70460_b[i];
            if (armorStk == null || !ApiCore.reductionsTable.containsKey(itm = armorStk.func_77973_b())) continue;
            ArrayList<Float> lst = ApiCore.reductionsTable.get(itm);
            resistance += lst.get(index).floatValue();
        }
        resistance /= 4.0f;
        IInventory baublesInventory = BaublesApi.getBaubles((EntityPlayer)p);
        if (baublesInventory != null) {
            for (int i = 0; i < baublesInventory.func_70302_i_(); ++i) {
                ItemStack stk = baublesInventory.func_70301_a(i);
                if (stk == null || !(stk.func_77973_b() instanceof ItemBaublesWearable) || !MiscUtils.getStackTag((ItemStack)stk).func_74764_b("type")) continue;
                NBTTagCompound bTag = MiscUtils.getStackTag((ItemStack)stk);
                ArrayList<Float> fltLst = new ArrayList<Float>();
                fltLst.add(Float.valueOf(bTag.func_74760_g("mrucr")));
                fltLst.add(Float.valueOf(bTag.func_74760_g("mrurr")));
                fltLst.add(Float.valueOf(bTag.func_74760_g("car")));
                resistance += ((Float)fltLst.get(index)).floatValue();
            }
        }
        if ((retFlt = 1.0f - resistance) < 0.0f) {
            retFlt = 0.0f;
        }
        return retFlt;
    }

    public static void newWorldEvent(World w) {
        IWorldEvent event;
        if (WorldEventLibrary.currentEvent == null && (event = WorldEventLibrary.selectRandomEffect(w)) != null && WorldEventLibrary.currentEvent == null) {
            WorldEventLibrary.currentEvent = event;
            WorldEventLibrary.currentEventDuration = event.getEventDuration(w);
            event.onEventBeginning(w);
        }
    }

    public static void endEvent(World w) {
        if (WorldEventLibrary.currentEvent != null) {
            if (WorldEventLibrary.currentEventDuration - 20 <= 0) {
                WorldEventLibrary.currentEvent.onEventEnd(w);
                WorldEventLibrary.currentEvent = null;
                WorldEventLibrary.currentEventDuration = -1;
            } else {
                WorldEventLibrary.currentEventDuration -= 20;
            }
        }
    }

    public static void requestCurrentEventSyncForPlayer(EntityPlayerMP player) {
        PacketNBT syncPacket = new PacketNBT(ec3WorldTag).setID(2);
        EssentialCraftCore.network.sendTo((IMessage)syncPacket, player);
    }

    public static void requestCurrentEventSync() {
        PacketNBT syncPacket = new PacketNBT(ec3WorldTag).setID(2);
        EssentialCraftCore.network.sendToAll((IMessage)syncPacket);
    }

    public static int getActiveEventDuration() {
        return ec3WorldTag.func_74762_e("currentEventDuration");
    }

    public static String getActiveEvent() {
        return ec3WorldTag.func_74779_i("currentEvent");
    }

    public static boolean hasActiveEvent() {
        return !ec3WorldTag.func_82582_d() && ec3WorldTag.func_74779_i("currentEvent") != null && !ec3WorldTag.func_74779_i("currentEvent").isEmpty();
    }

    public static boolean isEventActive(String id) {
        return ec3WorldTag.func_74779_i("currentEvent").equalsIgnoreCase(id);
    }

    public static void sendChatMessageToAllPlayersInDim(int dimID, String msg) {
        for (int i = 0; i < MinecraftServer.func_71276_C().func_71233_x(); ++i) {
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(MinecraftServer.func_71276_C().func_71213_z()[i]);
            if (player.field_71093_bK != dimID) continue;
            player.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    public static IRecipe findRecipeByIS(ItemStack searched, int recipeType) {
        ShapedRecipes mRecipe;
        ItemStack output;
        IRecipe recipe;
        int i;
        List rec;
        if (recipeType == 0 || recipeType == 1) {
            rec = CraftingManager.func_77594_a().func_77592_b();
            for (i = 0; i < rec.size(); ++i) {
                recipe = (IRecipe)rec.get(i);
                if (recipe instanceof ShapedRecipes && ItemStack.func_77970_a((ItemStack)(output = (mRecipe = (ShapedRecipes)recipe).func_77571_b()), (ItemStack)searched) && output.func_77969_a(searched)) {
                    return new ShapedRecipes(mRecipe.field_77576_b, mRecipe.field_77577_c, mRecipe.field_77574_d, mRecipe.func_77571_b());
                }
                if (!(recipe instanceof ShapelessRecipes) || !(output = (mRecipe = (ShapelessRecipes)recipe).func_77571_b()).func_77969_a(searched)) continue;
                return new ShapelessRecipes(mRecipe.func_77571_b(), mRecipe.field_77579_b);
            }
        }
        if (recipeType == 2 || recipeType == 3) {
            rec = CraftingManager.func_77594_a().func_77592_b();
            for (i = 0; i < rec.size(); ++i) {
                recipe = (IRecipe)rec.get(i);
                if (recipe instanceof ShapedOreRecipe && ItemStack.func_77970_a((ItemStack)(output = (mRecipe = (ShapedOreRecipe)recipe).func_77571_b()), (ItemStack)searched) && output.func_77969_a(searched)) {
                    return ECUtils.copyShapedOreRecipe((ShapedOreRecipe)mRecipe);
                }
                if (!(recipe instanceof ShapelessOreRecipe) || !(output = (mRecipe = (ShapelessOreRecipe)recipe).func_77571_b()).func_77969_a(searched)) continue;
                return ECUtils.copyShapelessOreRecipe((ShapelessOreRecipe)mRecipe);
            }
            return !MagicalAssemblerRecipes.findRecipes(searched).isEmpty() ? MagicalAssemblerRecipes.findRecipes(searched).get(0) : null;
        }
        if (recipeType == 4) {
            Set $s = FurnaceRecipes.func_77602_a().func_77599_b().entrySet();
            Iterator $i = $s.iterator();
            while ($i.hasNext()) {
                try {
                    Map.Entry obj;
                    Map.Entry entry = obj = $i.next();
                    ItemStack key = (ItemStack)entry.getKey();
                    ItemStack value = (ItemStack)entry.getValue();
                    if (!value.func_77969_a(searched)) continue;
                    return new ShapedFurnaceRecipe(key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (recipeType == 5) {
            return new RadiatingChamberRecipe(RadiatingChamberRecipes.getRecipeByResult(searched));
        }
        if (recipeType == 6) {
            return new MagicianTableRecipe(MagicianTableRecipes.getRecipeByResult(searched));
        }
        if (recipeType == 8) {
            return !MagicalAssemblerRecipes.findRecipes(searched).isEmpty() ? MagicalAssemblerRecipes.findRecipes(searched).get(0) : null;
        }
        return null;
    }

    public static ShapelessOreRecipe copyShapelessOreRecipe(ShapelessOreRecipe recipe) {
        ShapelessOreRecipe ret = null;
        ArrayList lst = recipe.getInput();
        Object[] returnObj = new Object[lst.size()];
        for (int i = 0; i < lst.size(); ++i) {
            ItemStack listStk;
            Object work = lst.get(i);
            if (work instanceof ItemStack || work instanceof Block || work instanceof Item || work instanceof String) {
                returnObj[i] = work;
            }
            if (!(work instanceof List) || ((List)List.class.cast(work)).isEmpty() || OreDictionary.getOreIDs((ItemStack)(listStk = (ItemStack)((List)work).get(0))) == null || OreDictionary.getOreIDs((ItemStack)listStk).length <= 0) continue;
            String oreDictName = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)listStk)[0]);
            returnObj[i] = oreDictName;
        }
        ret = new ShapelessOreRecipe(recipe.func_77571_b(), returnObj);
        return ret;
    }

    public static ShapedOreRecipe copyShapedOreRecipe(ShapedOreRecipe recipe) {
        ShapedOreRecipe ret = new ShapedOreRecipe(recipe.func_77571_b(), new Object[]{"ooo", "ooo", "ooo", Character.valueOf('o'), Items.field_151055_y});
        try {
            Class<ShapedOreRecipe> sorClazz = ShapedOreRecipe.class;
            Field wFld = sorClazz.getDeclaredFields()[4];
            wFld.setAccessible(true);
            Field hFld = sorClazz.getDeclaredFields()[5];
            hFld.setAccessible(true);
            hFld.getInt(recipe);
            Field inputFld = sorClazz.getDeclaredFields()[3];
            inputFld.setAccessible(true);
            Object[] obj = (Object[])inputFld.get(recipe);
            Field inputFld_acess = sorClazz.getDeclaredFields()[3];
            inputFld_acess.setAccessible(true);
            inputFld_acess.set(ret, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ret;
    }

    public static boolean oreDictionaryCompare(ItemStack stk, ItemStack stk1) {
        if (stk == null || stk1 == null) {
            return false;
        }
        if (OreDictionary.getOreIDs((ItemStack)stk) == null || OreDictionary.getOreIDs((ItemStack)stk).length == 0 || OreDictionary.getOreIDs((ItemStack)stk1) == null || OreDictionary.getOreIDs((ItemStack)stk1).length == 0) {
            return false;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stk);
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)stk1);
        for (int i = 0; i < ids.length; ++i) {
            for (int j = 0; j < ids1.length; ++j) {
                if (ids[i] != ids1[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canFilterAcceptItem(IInventory filterInventory, ItemStack is, ItemStack filter) {
        if (filter.func_77960_j() == 0 || filter.func_77960_j() == 2) {
            for (int i = 0; i < filterInventory.func_70302_i_(); ++i) {
                ItemStack f = filterInventory.func_70301_a(i);
                if (f == null) continue;
                if (f.func_77973_b() instanceof ItemFilter) {
                    if (!ECUtils.canFilterAcceptItem(new InventoryMagicFilter(f), is, f)) continue;
                    return true;
                }
                if (filter.func_77960_j() == 2) {
                    return !f.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)f, (ItemStack)is);
                }
                if (!f.func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)f, (ItemStack)is)) continue;
                return true;
            }
        } else {
            boolean ignoreMeta = MiscUtils.getStackTag((ItemStack)filter).func_74767_n("ignoreMeta");
            boolean ignoreNBT = MiscUtils.getStackTag((ItemStack)filter).func_74767_n("ignoreNBT");
            boolean ignoreOreDict = MiscUtils.getStackTag((ItemStack)filter).func_74767_n("ignoreOreDict");
            for (int i = 0; i < filterInventory.func_70302_i_(); ++i) {
                ItemStack f = filterInventory.func_70301_a(i);
                if (f == null) continue;
                if (f.func_77973_b() instanceof ItemFilter) {
                    if (!ECUtils.canFilterAcceptItem(new InventoryMagicFilter(f), is, f)) continue;
                    return true;
                }
                if (filter.func_77960_j() == 1) {
                    if (!(ECUtils.oreDictionaryCompare(is, f) || ignoreOreDict ? ItemStack.func_77970_a((ItemStack)f, (ItemStack)is) || ignoreNBT : (ItemStack.func_77989_b((ItemStack)is, (ItemStack)f) || is.func_77973_b() == f.func_77973_b() && ignoreMeta) && (ItemStack.func_77970_a((ItemStack)f, (ItemStack)is) || ignoreNBT))) continue;
                    return true;
                }
                if (!ECUtils.oreDictionaryCompare(is, f) || ignoreOreDict) {
                    return !ItemStack.func_77970_a((ItemStack)f, (ItemStack)is) || ignoreNBT;
                }
                if (!ItemStack.func_77989_b((ItemStack)is, (ItemStack)f) || is.func_77973_b() == f.func_77973_b() && ignoreMeta) {
                    return !ItemStack.func_77970_a((ItemStack)f, (ItemStack)is) || ignoreNBT;
                }
                return false;
            }
        }
        return filter.func_77960_j() > 1;
    }

    public static void spawnItemFX(TileEntity source, TileEntity destination) {
        double sX = (double)source.field_145851_c + 0.5;
        double sY = (double)source.field_145848_d + 0.5;
        double sZ = (double)source.field_145849_e + 0.5;
        double mX = (double)destination.field_145851_c + 0.5 - sX;
        double mY = (double)destination.field_145848_d + 0.5 - sY;
        double mZ = (double)destination.field_145849_e + 0.5 - sZ;
        String dataString = new String();
        dataString = dataString + "||mod:EC3.Particle.Item";
        dataString = dataString + "||x:" + sX + "||y:" + sY + "||z:" + sZ;
        dataString = dataString + "||mX:" + mX + "||mY:" + mY + "||mZ:" + mZ;
        DummyPacketIMSG pkt = new DummyPacketIMSG(dataString);
        DummyPacketHandler.sendToAll((DummyPacketIMSG)pkt);
    }

    public static void spawnItemFX(double sX, double sY, double sZ, double dX, double dY, double dZ) {
        double mX = dX - sX;
        double mY = dY - sY;
        double mZ = dZ - sZ;
        String dataString = new String();
        dataString = dataString + "||mod:EC3.Particle.Item";
        dataString = dataString + "||x:" + sX + "||y:" + sY + "||z:" + sZ;
        dataString = dataString + "||mX:" + mX + "||mY:" + mY + "||mZ:" + mZ;
        DummyPacketIMSG pkt = new DummyPacketIMSG(dataString);
        DummyPacketHandler.sendToAll((DummyPacketIMSG)pkt);
    }

    protected static void actionsTick() {
        if (!actions.isEmpty()) {
            for (int i = 0; i < actions.size(); ++i) {
                ScheduledServerAction ssa = actions.get(i);
                --ssa.actionTime;
                if (ssa.actionTime > 0) continue;
                ssa.execute();
                actions.remove(i);
            }
        }
    }

    public static void addScheduledAction(ScheduledServerAction ssa) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            Notifier.notifyCustomMod((String)"EssentialCraft", (String)"[WARNING][SEVERE]Trying to add a scheduled server action not on server side, aborting!");
        }
        actions.add(ssa);
    }

    public static void requestScheduledTileSync(TileEntity tile, EntityPlayer requester) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            if (tile.func_145831_w() == null || tile.func_145831_w().field_73011_w == null) {
                return;
            }
            NBTTagCompound clientData = new NBTTagCompound();
            clientData.func_74778_a("playername", requester.func_70005_c_());
            clientData.func_74768_a("x", tile.field_145851_c);
            clientData.func_74768_a("y", tile.field_145848_d);
            clientData.func_74768_a("z", tile.field_145849_e);
            clientData.func_74768_a("dim", tile.func_145831_w().field_73011_w.field_76574_g);
            PacketNBT packet = new PacketNBT(clientData).setID(7);
            EssentialCraftCore.network.sendToServer((IMessage)packet);
        } else {
            ECUtils.addScheduledAction(new ServerToClientSyncAction(requester, tile));
        }
    }

    public static void balanceIn(TileEntity tile, int slotNum) {
        if (tile instanceof IInventory && tile instanceof ITEHasMRU) {
            ItemStack s;
            int[] o;
            IInventory inv = (IInventory)tile;
            ITEHasMRU mrut = (ITEHasMRU)tile;
            if (inv.func_70301_a(slotNum) != null && inv.func_70301_a(slotNum).func_77973_b() instanceof ItemBoundGem && inv.func_70301_a(slotNum).func_77978_p() != null && MathUtils.getDifference((float)tile.field_145851_c, (float)(o = ItemBoundGem.getCoords(s = inv.func_70301_a(slotNum)))[0]) <= 16.0f && MathUtils.getDifference((float)tile.field_145848_d, (float)o[1]) <= 16.0f && MathUtils.getDifference((float)tile.field_145849_e, (float)o[2]) <= 16.0f && tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) != null && tile.func_145831_w().func_147438_o(o[0], o[1], o[2]) instanceof ITEHasMRU) {
                mrut.setBalance(((ITEHasMRU)tile.func_145831_w().func_147438_o(o[0], o[1], o[2])).getBalance());
            }
        }
    }

    public static void manage(TileEntity tile, int slotNum) {
        ECUtils.mruIn(tile, 0);
        ECUtils.spawnMRUParticles(tile, 0);
        ECUtils.balanceIn(tile, 0);
    }
}

