/*
 * Decompiled with CFR 0.152.
 */
package ec3.integration.nei;

import DummyCore.Utils.MiscUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ec3.api.WindImbueRecipe;
import ec3.common.block.BlocksCore;
import ec3.common.item.ItemSoulStone;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class WindImbueRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 0, 18, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getOverlayIdentifier() {
        return "windRecipes";
    }

    public String getRecipeName() {
        return "Wind Imbue";
    }

    public String getGuiTexture() {
        return "essentialcraft:textures/gui/gui_generic.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (results.length > 0) {
            ItemStack stk;
            WindImbueRecipe rec;
            Object obj = results[0];
            if (obj instanceof ItemStack && (rec = WindImbueRecipe.findRecipeByResult(stk = (ItemStack)obj)) != null) {
                this.arecipes.add(new WindImbueCraftingPair(rec));
            }
        } else if (outputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            for (int i = 0; i < WindImbueRecipe.recipes.size(); ++i) {
                this.arecipes.add(new WindImbueCraftingPair(WindImbueRecipe.recipes.get(i)));
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length > 0) {
            ItemStack stk;
            WindImbueRecipe rec;
            Object obj = ingredients[0];
            if (obj instanceof ItemStack && (rec = WindImbueRecipe.findRecipeByComponent(stk = (ItemStack)obj)) != null) {
                this.arecipes.add(new WindImbueCraftingPair(rec));
            }
        } else if (inputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            for (int i = 0; i < WindImbueRecipe.recipes.size(); ++i) {
                this.arecipes.add(new WindImbueCraftingPair(WindImbueRecipe.recipes.get(i)));
            }
        }
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
        GL11.glPushMatrix();
        WindImbueCraftingPair pair = (WindImbueCraftingPair)((Object)WindImbueCraftingPair.class.cast(this.arecipes.get(recipe)));
        Minecraft.func_71410_x().field_71466_p.func_85187_a(MathHelper.func_76128_c((double)pair.energy) + " ESPE", 53, 36, 0, false);
        if (pair.result.item != null && pair.result.item.func_77973_b() instanceof ItemSoulStone) {
            Minecraft.func_71410_x().field_71466_p.func_85187_a("+Wind Relations", 53, 46, 8507773, true);
        }
        GL11.glPopMatrix();
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        GL11.glPushMatrix();
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        MiscUtils.drawTexturedModalRect((int)55, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)91, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/special/wind_icon.png");
        Tessellator tec = Tessellator.field_78398_a;
        tec.func_78382_b();
        tec.func_78374_a(74.0, 0.0, 50.0, 0.0, 0.0);
        tec.func_78374_a(74.0, 16.0, 50.0, 0.0, 1.0);
        tec.func_78374_a(90.0, 16.0, 50.0, 1.0, 1.0);
        tec.func_78374_a(90.0, 0.0, 50.0, 1.0, 0.0);
        tec.func_78381_a();
        GL11.glPopMatrix();
    }

    public int recipiesPerPage() {
        return 2;
    }

    public class WindImbueCraftingPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        PositionedStack[] ingred;
        PositionedStack result;
        public float energy;
        public int size;

        public WindImbueCraftingPair(WindImbueRecipe recipe) {
            super((TemplateRecipeHandler)WindImbueRecipeHandler.this);
            this.ingred = new PositionedStack[2];
            ItemStack craftMatrix = recipe.transforming;
            this.ingred[0] = new PositionedStack((Object)craftMatrix, 92, 6);
            this.result = new PositionedStack((Object)recipe.result, 92, 1);
            this.ingredients = new ArrayList();
            this.setIngredients(craftMatrix, 1);
            this.energy = recipe.enderEnergy;
        }

        public void setIngredients(ItemStack items, int size) {
            ArrayList<ItemStack> possibleStacks = new ArrayList<ItemStack>();
            possibleStacks.add(items);
            for (int i = 0; i < possibleStacks.size(); ++i) {
                ItemStack is = (ItemStack)possibleStacks.get(i);
                is.field_77994_a = size;
            }
            PositionedStack stack = new PositionedStack(possibleStacks, 56, 1, false);
            PositionedStack rune = new PositionedStack((Object)new ItemStack(BlocksCore.windRune), 74, 19, false);
            this.ingredients.add(stack);
            this.ingredients.add(rune);
            possibleStacks.clear();
            possibleStacks = null;
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

