/*
 * Decompiled with CFR 0.152.
 */
package ec3.integration.nei;

import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ec3.api.RadiatingChamberRecipe;
import ec3.api.RadiatingChamberRecipes;
import ec3.common.mod.EssentialCraftCore;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class RadiatingChamberRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Radiating Chamber";
    }

    public String getGuiTexture() {
        return "essentialcraft:textures/gui/gui_generic.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (results.length > 0) {
            ItemStack stk;
            RadiatingChamberRecipe rec;
            Object obj = results[0];
            if (obj instanceof ItemStack && (rec = RadiatingChamberRecipes.getRecipeByResult(stk = (ItemStack)obj)) != null) {
                RadiatingChamberCraftingPair pair = new RadiatingChamberCraftingPair(rec);
                this.arecipes.add(pair);
            }
        } else if (outputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            Enumeration<RadiatingChamberRecipe> e = RadiatingChamberRecipes.recipesByIS.elements();
            while (e.hasMoreElements()) {
                RadiatingChamberRecipe rec = e.nextElement();
                if (rec == null) continue;
                RadiatingChamberCraftingPair pair = new RadiatingChamberCraftingPair(rec);
                this.arecipes.add(pair);
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length > 0) {
            Object obj = ingredients[0];
            if (obj instanceof ItemStack) {
                ItemStack stk = (ItemStack)obj;
                ItemStack genStk = stk.func_77946_l();
                genStk.field_77994_a = 0;
                String searchPair = genStk.toString();
                genStk = null;
                for (int i = 0; i < RadiatingChamberRecipes.craftMatrixByID.size(); ++i) {
                    List<RadiatingChamberRecipe> lst;
                    String searchPairSecond = RadiatingChamberRecipes.craftMatrixByID.get(i);
                    if (searchPairSecond == null || searchPairSecond.isEmpty() || !searchPairSecond.contains(searchPair) || (lst = RadiatingChamberRecipes.recipes.get(searchPairSecond)) == null || lst.isEmpty()) continue;
                    for (int i1 = 0; i1 < lst.size(); ++i1) {
                        RadiatingChamberRecipe rec = lst.get(i1);
                        if (rec == null) continue;
                        RadiatingChamberCraftingPair pair = new RadiatingChamberCraftingPair(rec);
                        this.arecipes.add(pair);
                    }
                }
            }
        } else if (inputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(18, 20, 18, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getOverlayIdentifier() {
        return "radiatingChamber";
    }

    public void drawExtras(int recipe) {
        float lowerBalance;
        GL11.glPushMatrix();
        int posX = 0;
        int posY = 0;
        RadiatingChamberCraftingPair rec = (RadiatingChamberCraftingPair)((Object)this.arecipes.get(recipe));
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/mruStorage.png");
        MiscUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)18, (int)72, (int)1);
        int percentageScaled = MathUtils.pixelatedTextureSize((int)((int)((float)rec.mruRequired * rec.mod)), (int)5000, (int)72);
        IIcon icon = (IIcon)EssentialCraftCore.proxy.getClientIcon("mru");
        MiscUtils.drawTexture((int)1, (int)(-1 + (74 - percentageScaled)), (IIcon)icon, (int)16, (int)(percentageScaled - 2), (float)0.0f);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        posX = 18;
        posY = 54;
        MiscUtils.drawTexturedModalRect((int)posX, (int)posY, (int)0, (int)0, (int)17, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 16), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 32), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 48), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 64), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 80), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 96), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 111), (int)posY, (int)1, (int)0, (int)17, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 36), (int)0, (int)0, (int)0, (int)17, (int)17, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 36), (int)17, (int)0, (int)1, (int)17, (int)16, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 36), (int)26, (int)0, (int)1, (int)17, (int)16, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 36), (int)37, (int)0, (int)1, (int)17, (int)17, (int)1);
        for (int x = 1; x < 6; ++x) {
            MiscUtils.drawTexturedModalRect((int)(posX + 36 + 16 * x), (int)0, (int)1, (int)0, (int)16, (int)17, (int)1);
            MiscUtils.drawTexturedModalRect((int)(posX + 36 + 16 * x), (int)17, (int)1, (int)1, (int)16, (int)16, (int)1);
            MiscUtils.drawTexturedModalRect((int)(posX + 36 + 16 * x), (int)26, (int)1, (int)1, (int)16, (int)16, (int)1);
            MiscUtils.drawTexturedModalRect((int)(posX + 36 + 16 * x), (int)37, (int)1, (int)1, (int)16, (int)17, (int)1);
        }
        MiscUtils.drawTexturedModalRect((int)(posX + 32 + 96), (int)0, (int)1, (int)0, (int)17, (int)17, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 32 + 96), (int)17, (int)1, (int)1, (int)17, (int)16, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 32 + 96), (int)26, (int)1, (int)1, (int)17, (int)16, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 32 + 96), (int)37, (int)1, (int)1, (int)17, (int)17, (int)1);
        Minecraft.func_71410_x().field_71466_p.func_78261_a((int)((float)rec.mruRequired * rec.mod) + " MRU", posX + 2, posY + 5, 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_78261_a("" + rec.mruRequired / 20 / 60 + "Min " + (rec.mruRequired / 20 - rec.mruRequired / 20 / 60 * 60) + "Sec", posX + 2 + 60, posY + 5, 0xFFFFFF);
        float upperBalance = rec.balanceBounds[0];
        if (upperBalance > 2.0f) {
            upperBalance = 2.0f;
        }
        if ((lowerBalance = rec.balanceBounds[1]) < 0.1f) {
            lowerBalance = 0.0f;
        }
        Minecraft.func_71410_x().field_71466_p.func_78261_a("Upper Balance: " + upperBalance, posX + 38, 5, 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_78261_a("MRU/Tick: " + (int)rec.mod, posX + 38, 23, 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_78261_a("Lower Balance: " + lowerBalance, posX + 38, 40, 0xFFFFFF);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("R", 11, 10, 0);
        GL11.glScalef((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        MiscUtils.drawTexturedModalRect((int)18, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)36, (int)18, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)18, (int)36, (int)0, (int)0, (int)18, (int)18, (int)0);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class RadiatingChamberCraftingPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        PositionedStack[] ingred;
        PositionedStack result;
        public int mruRequired;
        public float[] balanceBounds;
        public float mod;

        public RadiatingChamberCraftingPair(RadiatingChamberRecipe recipe) {
            super((TemplateRecipeHandler)RadiatingChamberRecipeHandler.this);
            this.balanceBounds = new float[2];
            this.balanceBounds[0] = recipe.upperBalanceLine;
            this.balanceBounds[1] = recipe.lowerBalanceLine;
            this.ingred = new PositionedStack[2];
            Object[] craftMatrix = recipe.recipeItems;
            for (int t = 0; t < craftMatrix.length; ++t) {
                if (craftMatrix[t] == null) continue;
                this.ingred[t] = new PositionedStack((Object)craftMatrix[t], 51 + t * 18, 6);
            }
            this.result = new PositionedStack((Object)recipe.result, 37, 19);
            this.ingredients = new ArrayList();
            this.setIngredients(craftMatrix);
            this.mruRequired = recipe.mruRequired;
            this.mod = recipe.costModifier;
        }

        public void setIngredients(Object[] items) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                int x = 0;
                int y = 0;
                switch (i) {
                    case 0: {
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 1: {
                        x = 0;
                        y = 2;
                        break;
                    }
                    case 2: {
                        x = 2;
                        y = 0;
                        break;
                    }
                    case 3: {
                        x = 0;
                        y = 2;
                        break;
                    }
                    case 4: {
                        x = 2;
                        y = 2;
                    }
                }
                PositionedStack stack = new PositionedStack(items[i], 19 + x * 18, 1 + y * 18, false);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

