/*
 * Decompiled with CFR 0.152.
 */
package ec3.integration.nei;

import DummyCore.Utils.MiscUtils;
import DummyCore.Utils.UnformedItemStack;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ec3.api.MithrilineFurnaceRecipe;
import ec3.api.MithrilineFurnaceRecipes;
import ec3.common.tile.TileMithrilineFurnace;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class MithrilineFurnaceRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(36, 0, 18, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getOverlayIdentifier() {
        return "mithrilineFurnace";
    }

    public String getRecipeName() {
        return "Mithriline Furnace";
    }

    public String getGuiTexture() {
        return "essentialcraft:textures/gui/gui_generic.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (results.length > 0) {
            ItemStack stk;
            MithrilineFurnaceRecipe rec;
            Object obj = results[0];
            if (obj instanceof ItemStack && (rec = MithrilineFurnaceRecipes.findRecipeByResult(stk = (ItemStack)obj)) != null) {
                MithrilineFurnaceCraftingPair pair = new MithrilineFurnaceCraftingPair(rec);
                this.arecipes.add(pair);
            }
        } else if (outputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            for (int i = 0; i < MithrilineFurnaceRecipes.allRegisteredRecipes.size(); ++i) {
                MithrilineFurnaceRecipe rec = MithrilineFurnaceRecipes.allRegisteredRecipes.get(i);
                if (rec == null) continue;
                MithrilineFurnaceCraftingPair pair = new MithrilineFurnaceCraftingPair(rec);
                this.arecipes.add(pair);
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length > 0) {
            ItemStack stk;
            MithrilineFurnaceRecipe recs;
            Object obj = ingredients[0];
            if (obj instanceof ItemStack && (recs = MithrilineFurnaceRecipes.findRecipeByComponent(stk = (ItemStack)obj)) != null) {
                MithrilineFurnaceCraftingPair pair = new MithrilineFurnaceCraftingPair(recs);
                this.arecipes.add(pair);
            }
        } else if (inputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
    }

    public void drawExtras(int recipe) {
        if (this.cycleticks % 30 == 0) {
            Random rng = new Random();
            MithrilineFurnaceCraftingPair cp = (MithrilineFurnaceCraftingPair)((Object)this.arecipes.get(recipe));
            for (int i = 0; i < cp.getIngredients().size(); ++i) {
                PositionedStack stack = cp.getIngredients().get(i);
                stack.setPermutationToRender(rng.nextInt(stack.items.length));
                for (int j = 0; j < stack.items.length; ++j) {
                    if (stack.items[j] == null) continue;
                    stack.items[j].field_77994_a = cp.size;
                }
            }
        }
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        GL11.glPushMatrix();
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        MiscUtils.drawTexturedModalRect((int)18, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)54, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/mithrilineFurnaceElements.png");
        MithrilineFurnaceCraftingPair rec = (MithrilineFurnaceCraftingPair)((Object)this.arecipes.get(recipe));
        float current = rec.energy;
        float max = TileMithrilineFurnace.maxEnergy;
        float m = current / max * 100.0f;
        int n = MathHelper.func_76141_d((float)(m / 100.0f * 18.0f));
        int posX = 36;
        int posY = 0;
        MiscUtils.drawTexturedModalRect((int)posX, (int)posY, (int)0, (int)14, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)posX, (int)(posY + 18 - n), (int)18, (int)(14 + (18 - n)), (int)18, (int)n, (int)0);
        GL11.glPopMatrix();
    }

    public int recipiesPerPage() {
        return 2;
    }

    public class MithrilineFurnaceCraftingPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        PositionedStack[] ingred;
        PositionedStack result;
        public float energy;
        public int size;

        public MithrilineFurnaceCraftingPair(MithrilineFurnaceRecipe recipe) {
            super((TemplateRecipeHandler)MithrilineFurnaceRecipeHandler.this);
            this.ingred = new PositionedStack[2];
            UnformedItemStack craftMatrix = recipe.smelted;
            this.ingred[0] = new PositionedStack((Object)craftMatrix.possibleStacks, 51, 6);
            this.result = new PositionedStack((Object)recipe.result, 55, 1);
            this.ingredients = new ArrayList();
            this.setIngredients(craftMatrix, recipe.requiredRecipeSize);
            this.energy = recipe.enderStarPulsesRequired;
            this.size = recipe.requiredRecipeSize;
        }

        public void setIngredients(UnformedItemStack items, int size) {
            ArrayList possibleStacks = new ArrayList();
            possibleStacks.addAll(items.possibleStacks);
            for (int i = 0; i < possibleStacks.size(); ++i) {
                ItemStack is = (ItemStack)possibleStacks.get(i);
                is.field_77994_a = size;
            }
            PositionedStack stack = new PositionedStack(possibleStacks, 19, 1, false);
            this.ingredients.add(stack);
            possibleStacks.clear();
            possibleStacks = null;
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

